
/* global Curve, Chart, Graph, THREE, pi */

// 
// agelis dimitrios 2018 all rights reserved


"use strict";


var mygrey = rgb(244, 244, 244)

var evn = 0;///user events
function bodyload() {
    create();
    init();

    gf.start();
}

function click() {
    alert("click");
}
function clickdown(event) {
    alert(event.target.id);
}

function clickhelp() {
    hideelement(getelement("help"));
}
setbackcolor(getelement("body"), "white");
var gf = new GF();
var sm = gf.getmanager();

var ttcolor = "pink";

var appw = sm.width;
var apph = sm.height;
var logw = appw;
var logh = apph;
sm.adddebug();/// here because form


sm.dwin.drawoutline = true;
sm.dwin.x = 800;

sm.setbackcolor(0, 0, 0);
sm.drawbackground = false;//true; /// dont draw background if have a 2d or 3d app


var scene0 = sm.createscene();      ///  0



scene0.userevent = function (e, type) {
    //label2.title=e.type;

    evn++;
    if (type === "KEYDOWN") {

        if (e.keyCode === 32) {
        }
        ;
    }

}

////  app 
var appname = "Διατήρηση της ορμής"

var helptext = 'Διατήρηση της ορμής. # Μπορείς να δείς πως μεταβάλλεται η ενέργεια των δύο σωμάτων και του ελατηρίου, να παρατηρήσεις τις μεταβολές της ορμής των σωμάτων και του συστήματος. # # Η ακρίβεια μέτρησης της ταχύτητας είναι 0,01 m/sec. (δηλαδή αν ένα σώμα έχει ταχύτητα 0,0281 m/sec η ένδειξη  της ταχύτητας θα είναι 0,03 m/sec)'
var gui = scene0.addform(0, "", 0, 0, appw, apph);

gui.drawbackground = false;
gui.pickable = false;

/// -------------------------resources

var imwall1 = sm.createimage("images/1wall.png");
var imwall2 = sm.createimage("images/2wall.png");
 
///------------------  appplication var ---------------------

///////////////////////////////-------------------

////////////////////////////////-----------------------------
var form0 = gui.addform("form0", "", 0, 48, appw, apph-48);
form0.backcolor = "white";
form0.backout(false);


///////////////////////////////-------------------
////////////////////////***************                   h e l p e r       **********////////////////////////////////////////////

//////////////////////////////////////*****************************///////////////////////////////////////////
////////////////////////////////-----------------------------
var t=0;
var dt=0.01;
var dt0=dt;
var tdir=1;
var tsc=1;
var tslow=false;
var m1 = 1;
var m2 = 1;
var K = 8;
var epim=0;
var L0 = 1.7+0.3;
var b = 0;

var x0=640;
var y0=300;
var scx=200;
var h=0.0; 
var rpix=30;
var x1=-0.5;
var x2=+0.5;
var l1=x1;var l2=x2;
var v1=0;
var v2=0;
var p1=0;
var p2=0;
var K1=0;
var K2=0;
var U=0;
var ar=0;
var par=[];
var sbw=200;
var sby=200;
var sb1=form0.addscrollbar(0,"m1",x0+x1*scx-sbw/2,y0+sby,sbw,48);

sb1.setvalues(1,100,m1);
var sb2=form0.addscrollbar(0,"m2",x0+x2*scx-sbw/2,y0+sby,sbw,48);
sb2.setvalues(1,100,m2);
sb1.valuedraw=false;sb2.valuedraw=false;
var fwall1 =form0.addshape(0,"",x0-3*scx-11+1,y0-89+rpix,11,89,imwall1)
var fwall2 =form0.addshape(0,"",x0+3*scx-1,y0-89+rpix,11,89,imwall2)
fwall1.visible=false;
fwall2.visible=false;


var fcheck=form0.addcheck(0,"",0,622,appw,50);
//fcheck.backout(false)
var chw=250;
var ch1=fcheck.addlistitem(0,"Τοιχώματα",10,10,chw-30,32);
fcheck.backout(true,false);
fcheck.backcolor=mygrey;
ch1.onclick=function(){
    fwall1.visible=ch1.checked;
    fwall2.visible=ch1.checked;
    reset();
}



var ch2=fcheck.addlistitem(0,"Ενέργεια",10+1*chw,10,chw-30,32);
var ch3=fcheck.addlistitem(0,"Ορμή",10+2*chw,10,chw-30,32);
var ch4=fcheck.addlistitem(0,"Αργή προβολή",10+3*chw,10,chw-30,32);
var clock=fcheck.addclockwin(0,"",10+4*chw,1);
clock.ff3.visible=false;clock.ff4.visible=false;
ch4.onclick=function(){
    tsc=1;
    if (ch4.checked) tsc=0.1;
}

clock.onmessage=function(msg){
    tdir=1;
    if (msg==="reset") reset();
    if (msg==="left") { tdir=-1}
}
function col(m){
    var c1=200;
    var c=1.5;
    return rgb(c1-m*c,c1-m*c,c1-m*c)
}

function spring(){
    styles(form0.ctx,"grey");
    //form0.drawpolar(x0+(l1)*scx+rpix,y0,(l2-l1)*scx-2*rpix,0)
   
    drawspring(form0.ctx,(l2-l1)*scx-2*rpix,rpix,11,x0+(l1)*scx+rpix,y0+form0.yg,0,3)
}

sm.ondrop = function (ob, over) {
    ///// only if has draggobject
    

}
sm.onmouseup = function () {
  
}

sm.ondragstart = function (ob) {

    
}

sm.onvaluechange = function (sb) {
reset();
 
}

function reset() {
{
    clock.clockstop();
        x1=-0.5;x2=+0.5;v1=0;v2=0;t=0;
    l1=x1+h;l2=x2-h;
    }
}

function create() {

}


function init() {
   
}

function update() {
    m1=toint(sb1.value);
    m2=toint(sb2.value);
    dt=tsc*dt0*(!clock.stopped)*tdir;
    
    //if (t<0){t=0;dt=0;}
    ar=rk2(x1,v1,x2,v2,dt,t);
    x1=ar[0];v1=ar[1];x2=ar[2];v2=ar[3]
   t+=dt;
   if (x1<-3+rpix/scx && ch1.checked){ v1=-v1;}
   if (x2>3-rpix/scx && ch1.checked) {v2=-v2;}
 if (x1>l1){
     l1=x1;
 if (x2-x1>L0) l2=l1+L0;
    }
if (x2<l2) {l2=x2;
   if (x2-x1>L0) l1=l2-L0;
    }    
  if (x2-x1<=L0) {l2=x2;l1=x1;}
epim=0;
epim=L0-(x2-x1);
if (epim<0 ) epim=0;
U=1/2*K*epim*epim;
K1=1/2*m1*v1*v1;
K2=1/2*m2*v2*v2;
}
   
 
function axis() {
    var colf=1.5;
    styles(form0.ctx, col(m1))
    form0.drawrect(x0 + x1 * scx - rpix, y0 - rpix, 2 * rpix, 2 * rpix, 1);///m1
    styles(form0.ctx, "black","grey")
    form0.drawcircle(x0 + x1 * scx, y0, 2 ,2);
    styles(form0.ctx, col(m2))
    form0.drawrect(x0 + x2 * scx - rpix, y0 - rpix, 2 * rpix, 2 * rpix, 1);///m2
     styles(form0.ctx, "black","grey")
    form0.drawcircle(x0 + x2 * scx, y0, 2 ,2);
 styles(form0.ctx, "grey")
   var i = 0;
  
    for (i = -3; i <= 3; i++) {
        form0.drawpolar(x0 + i * scx, y0 + rpix, 12, pi / 2)
        form0.drawtext(abs(i), x0 + i * scx, y0 + rpix + 23)
    }

    for (i = -3; i <= 3; i += 0.1) {
        form0.drawpolar(x0 + i * scx, y0 + rpix, 6, pi / 2)
    }
    //styles(form0.ctx, "black")
        for (i = -3; i <= 3; i += 0.5) {
        form0.drawpolar(x0 + i * scx, y0 + rpix, 12, pi / 2)
    }
     styles(form0.ctx, "grey")
  form0.drawpolar(x0 - 3 * scx, y0 + rpix, 6 * scx, 0);// x axis
  
  spring();
  
  /// energy
  var sce=80;
  if (ch2.checked){
  styles(form0.ctx, "black");
  form0.drawtext("K1",10,y0-250,16,true);
  styles(form0.ctx, "blue")
  form0.drawrect(40,y0-250-15,K1*sce,30,1)
  form0.drawrect(40+sce*4-K2*sce,y0-250-15+30,K2*sce,30,1)
  styles(form0.ctx, "black");
  form0.drawtext("K2",10+40+sce*4,y0-250+30,16,true);
  styles(form0.ctx, "red")
  form0.drawrect(40+sce*K1,y0-250-15+2*30,U*sce,30,1)
  styles(form0.ctx, "black");
  form0.drawtext("U",40+sce*2,y0-250+3*30);
  }
  /// velocities
  var scv=25;
   styles(form0.ctx, "blue")
  form0.drawarrow(x0+x1*scx,y0-60,v1*scv,0,8,1,2)
  form0.drawarrow(x0+x2*scx,y0-60,v2*scv,0,8,1,2)
  getpolar(x0+x1*scx,y0-60,v1*scv+16*sign(v1),0,par);
  form0.drawtext("v",par[0],par[1],16)
     form0.drawtext("1",par[0]+6,par[1]+6,12,true)
  getpolar(x0+x2*scx,y0-60,v2*scv+16*sign(v2),0,par);
  form0.drawtext("v",par[0],par[1],16)
     form0.drawtext("2",par[0]+6,par[1]+6,12,true)
  
  styles(form0.ctx, "blue")
/// force
if (ch3.checked)   {
    var f1=-K*epim;
    if (abs(f1)>0.01){
   styles(form0.ctx, "green")
form0.drawarrow(x0+x1*scx,y0,f1*scv,0,8,1,2)
  form0.drawarrow(x0+x2*scx,y0,-f1*scv,0,8,1,2)
  
  getpolar(x0+x1*scx,y0,f1*scv+16*sign(f1),0,par);
  form0.drawtext("F",par[0],par[1],16)
  form0.drawtext("1",par[0]+6,par[1]+6,12,true)
  
  getpolar(x0+x2*scx,y0,-f1*scv+16*sign(-f1),0,par);
  form0.drawtext("F",par[0],par[1],16)
     form0.drawtext("2",par[0]+6,par[1]+6,12,true)
  }
  /// momentum
  
  var p1=m1*v1;
  var p2=m2*v2;
  var pol=p1+p2;
    styles(form0.ctx, "orange")
  
    if (abs(p2)>0.01){
  getpolar(x0,y0+100,p1*scv,0,par)
  
  form0.drawarrow(par[0],y0+120,p2*scv,0,8,1,2) 
  
  
  getpolar(par[0],y0+120,p2*scv+16*sign(p2),0,par);
  form0.drawtext("p",par[0],par[1],16)
   form0.drawtext("2",par[0]+6,par[1]+6,12,true)
 
 
  }
  
  if (abs(p1)>0.01){
      form0.drawarrow(x0,y0+100,p1*scv,0,8,1,2);
     getpolar(x0,y0+100,p1*scv+16*sign(p1),0,par);
  form0.drawtext("p",par[0],par[1],16)   
  
   form0.drawtext("1",par[0]+6,par[1]+6,12,true)
   }
   
   
   if (abs(pol)>0.01){
    styles(form0.ctx, "blue")   
   form0.drawarrow(x0,y0+140,pol*scv,0,8,1,2)     
   getpolar(x0,y0+140,pol*scv+24*sign(pol),0,par);
   form0.drawtext("p",par[0],par[1],16)
   form0.drawtext("ολ",par[0]+6,par[1]+6,12,true)
   }
    
    }
}
  
form0.userdraw=function(ctx){
    update();
    axis();
    
    styles(ctx,"black")
    
    
   // form0.drawtext("U="+todecimal(U,2),100,80,true)
   //  form0.drawtext("K1="+todecimal(K1,2),100,80+30,true)
    //   form0.drawtext("K2="+todecimal(K2,2),100,80+60,true)
    sb1.drawtext("m  ="+m1+"Kg",70,0,16,true)
    sb1.drawtext("  1",70+6, 6,12,true)
    sb2.drawtext("m  ="+m2+"Kg",70,0,16,true)
    sb2.drawtext("  2",70+6, 6,12,true)
    
    sb1.drawtext("v ="+todecimal(v1,2)+"m/s",70,70,16,true );
    sb1.drawtext("1",70+6,70+6,12,true );
    sb2.drawtext("v ="+todecimal(v2,2)+"m/s",70,70,16,true );
     sb2.drawtext("2",70+6,70+6,12,true );
    
    sb2.drawtext("t="+todecimal(t,2)+" s",425,70,16,true)
}

//-------------------------------------  app var


 function rk2 (x1,v1,x2,v2,dt,t)
{
 
   var k1 = fv1(x1,v1,x2,v2,t);
   var l1 = facc1(x1,v1,x2,v2,t);
   var m1 = fv2(x1,v1,x2,v2,t);
   var n1 = facc2(x1,v1,x2,v2,t);
   var k2 = fv1(x1 + dt * k1 / 2,v1 + dt * l1 / 2,x2 + dt * m1 / 2,v2 + dt * n1 / 2,t + dt / 2);
   var l2 = facc1(x1 + dt * k1 / 2,v1 + dt * l1 / 2,x2 + dt * m1 / 2,v2 + dt * n1 / 2,t + dt / 2);
   var m2 = fv2(x1 + dt * k1 / 2,v1 + dt * l1 / 2,x2 + dt * m1 / 2,v2 + dt * n1 / 2,t + dt / 2);
   var n2 = facc2(x1 + dt * k1 / 2,v1 + dt * l1 / 2,x2 + dt * m1 / 2,v2 + dt * n1 / 2,t + dt / 2);
   var k3 = fv1(x1 + dt * k2 / 2,v1 + dt * l2 / 2,x2 + dt * m2 / 2,v2 + dt * n2 / 2,t + dt / 2);
   var l3 = facc1(x1 + dt * k2 / 2,v1 + dt * l2 / 2,x2 + dt * m2 / 2,v2 + dt * n2 / 2,t + dt / 2);
   var m3 = fv2(x1 + dt * k2 / 2,v1 + dt * l2 / 2,x2 + dt * m2 / 2,v2 + dt * n2 / 2,t + dt / 2);
   var n3 = facc2(x1 + dt * k2 / 2,v1 + dt * l2 / 2,x2 + dt * m2 / 2,v2 + dt * n2 / 2,t + dt / 2);
   var k4 = fv1(x1 + dt * k3,v1 + dt * l3,x2 + dt * m3,v2 + dt * n3,t + dt);
   var l4 = facc1(x1 + dt * k3,v1 + dt * l3,x2 + dt * m3,v2 + dt * n3,t + dt);
   var m4 = fv2(x1 + dt * k3,v1 + dt * l3,x2 + dt * m3,v2 + dt * n3,t + dt);
   var n4 = facc2(x1 + dt * k3,v1 + dt * l3,x2 + dt * m3,v2 + dt * n3,t + dt);
   x1 = x1 + dt * (k1 + 2 * k2 + 2 * k3 + k4) / 6;
   v1 = v1 + dt * (l1 + 2 * l2 + 2 * l3 + l4) / 6;
   x2 = x2 + dt * (m1 + 2 * m2 + 2 * m3 + m4) / 6;
   v2 = v2 + dt * (n1 + 2 * n2 + 2 * n3 + n4) / 6;
   return [x1,v1,x2,v2]
};
   function fv1(x1, v1, x2, v2, t)
{
   return v1;
};
 function facc1 (x1, v1, x2, v2, t)
{
   var x = x2 - x1 - L0 - h;
   var res = 0;
   if(x < 0)
   {
      res = K * x / m1 - b * v1 / m1;
   }
   return res;
};
function fv2  (x1, v1, x2, v2, t)
{
   return v2;
};
function facc2  (x1, v1, x2, v2, t)
{
   var x = x2 - x1 - L0 - h;
   var res = 0;
   if(x < 0)
   {
      res = (- K) * x / m2 - b * v2 / m2;
   }
   return res;
};




//////////////////////      etc /////////////////////

var label2 = gui.addlabel(0, appname, 0, 0, appw, 48);
label2.backcolor = "orange";
label2.backcolor = mygrey;
label2.textcentered = false;//


var btnabout = label2.addbutton(0, "", appw - 48, 0, 48, 48, sm.getimageres("about"));
btnabout.drawbackground = false;
btnabout.drawoutline = false;

var btnhelp = label2.addbutton(0, "", appw - 100, 0, 48, 48, sm.getimageres("help"));
btnhelp.drawbackground = false;
btnhelp.drawoutline = false;
//var sceneabout = sm.adddialog(512, 360, sm.createimage("images/about.png"), 0);/// scene 1

btnabout.onclick = function () {
    window.open('index_DS_II.html');
//formabout.visible = !false;
}
btnhelp.onclick = function () {
    formhelp.visible = !formhelp.visible;//false;

}


var fhw = 620;
var fhh = 240;
var formhelp = gui.addform(0, "", 1280 - fhw - 20, 64, fhw, fhh);
formhelp.backcolor = rgb(255, 255, 204);
formhelp.userdraw = function (ctx) {
//function wraptext(ctx, text, x, y, maxWidth, lineHeight) {
    wraptext(formhelp.ctx, helptext, formhelp.xg + 8, formhelp.yg + 28, formhelp.width - 55, 24)
}

formhelp.visible = false;
//formhelp.center();

var bc1 = formhelp.addbutton(0, "", formhelp.width - 56, 0, 42, 42, sm.getimageres("close"));
bc1.drawoutline = false;

bc1.drawoutline = false;
bc1.onclick = function () {
    formhelp.visible = false;
}

bc1.drawbackground = false;
bc1.drawoutline = false;



 