RungeKutta = function(x1,v1,x2,v2,dt,t)
{
 
   var k1 = fv1(x1,v1,x2,v2,t);
   var l1 = facc1(x1,v1,x2,v2,t);
   var m1 = fv2(x1,v1,x2,v2,t);
   var n1 = facc2(x1,v1,x2,v2,t);
   var k2 = fv1(x1 + dt * k1 / 2,v1 + dt * l1 / 2,x2 + dt * m1 / 2,v2 + dt * n1 / 2,t + dt / 2);
   var l2 = facc1(x1 + dt * k1 / 2,v1 + dt * l1 / 2,x2 + dt * m1 / 2,v2 + dt * n1 / 2,t + dt / 2);
   var m2 = fv2(x1 + dt * k1 / 2,v1 + dt * l1 / 2,x2 + dt * m1 / 2,v2 + dt * n1 / 2,t + dt / 2);
   var n2 = facc2(x1 + dt * k1 / 2,v1 + dt * l1 / 2,x2 + dt * m1 / 2,v2 + dt * n1 / 2,t + dt / 2);
   var k3 = fv1(x1 + dt * k2 / 2,v1 + dt * l2 / 2,x2 + dt * m2 / 2,v2 + dt * n2 / 2,t + dt / 2);
   var l3 = facc1(x1 + dt * k2 / 2,v1 + dt * l2 / 2,x2 + dt * m2 / 2,v2 + dt * n2 / 2,t + dt / 2);
   var m3 = fv2(x1 + dt * k2 / 2,v1 + dt * l2 / 2,x2 + dt * m2 / 2,v2 + dt * n2 / 2,t + dt / 2);
   var n3 = facc2(x1 + dt * k2 / 2,v1 + dt * l2 / 2,x2 + dt * m2 / 2,v2 + dt * n2 / 2,t + dt / 2);
   var k4 = fv1(x1 + dt * k3,v1 + dt * l3,x2 + dt * m3,v2 + dt * n3,t + dt);
   var l4 = facc1(x1 + dt * k3,v1 + dt * l3,x2 + dt * m3,v2 + dt * n3,t + dt);
   var m4 = fv2(x1 + dt * k3,v1 + dt * l3,x2 + dt * m3,v2 + dt * n3,t + dt);
   var n4 = facc2(x1 + dt * k3,v1 + dt * l3,x2 + dt * m3,v2 + dt * n3,t + dt);
   x1 = x1 + dt * (k1 + 2 * k2 + 2 * k3 + k4) / 6;
   v1 = v1 + dt * (l1 + 2 * l2 + 2 * l3 + l4) / 6;
   x2 = x2 + dt * (m1 + 2 * m2 + 2 * m3 + m4) / 6;
   v2 = v2 + dt * (n1 + 2 * n2 + 2 * n3 + n4) / 6;
};
fv1 = function(x1, v1, x2, v2, t)
{
   return v1;
};
facc1 = function(x1, v1, x2, v2, t)
{
   var x = x2 - x1 - L0 - h;
   var res = 0;
   if(x < 0)
   {
      res = K * x / m1 - b * v1 / m1;
   }
   return res;
};
fv2 = function(x1, v1, x2, v2, t)
{
   return v2;
};
facc2 = function(x1, v1, x2, v2, t)
{
   var x = x2 - x1 - L0 - h;
   var res = 0;
   if(x < 0)
   {
      res = (- K) * x / m2 - b * v2 / m2;
   }
   return res;
};

