﻿/*
(c) by Sitsanlis Ilias
*/

var canvas;
var stage;
var self;
var percent = 0.8
var showVariablesFlag = true

var q1_mc = new createjs.Shape();
var q2_mc = new createjs.Shape();

var q1Text_mc = new createjs.Shape();
var q2Text_mc = new createjs.Shape();

var F1Text_mc = new createjs.Shape();
var F1Vec

var F2Text_mc = new createjs.Shape();
var F2Vec;

var text = new createjs.Text();
text.font = "16px Trebuchet MS";
text.x = 50;
text.y = 372;

var snapFlag = false;
var forceFlag = true;

// ΣΤΑΘΕΡΕΣ
var PI = Math.PI;
var toDeg = 180/PI;
var toRad = PI/180;

var X0=360;
var Y0=200;

var t=0;
var dt=1/120;

var isInSlowMotion=false
var dtInitial = dt;
var dtSlow = dt;

var factor = 1/2;
var playMovie=false;
var framePlay=false;

var xScale=50;
var yScale=-xScale;
var FScale = 1;

var kc = 90;

var x1 , y1 , x2 , y2
var q1 = 1 , q2 = -4

q1_mc.name="q1_mc";
q1_mc.addEventListener("mousedown",mouseDownGen);
q1_mc.addEventListener("pressup", pressUpGen);
q1_mc.mouseChildren = false;

q2_mc.name="q2_mc";
q2_mc.addEventListener("mousedown",mouseDownGen);
q2_mc.addEventListener("pressup", pressUpGen);
q2_mc.mouseChildren = false;


// ΑΡΧΙΚΟΠΟΙΗΣΗ
function init() {
	
	stage = new createjs.Stage(document.getElementById('demoCanvas'));
	createjs.Touch.enable(stage); 
	stage.enableMouseOver();
	canvas = document.getElementById("demoCanvas");
	self = stage;
	handleComplete();

	drawChange(q1_mc,q1);
	q1_mc.x=X0-1.5*xScale;
	q1_mc.y=Y0;
	self.addChild(q1_mc);
	
	
	drawChange(q2_mc,q2);
	q2_mc.x=X0+1.5*xScale;
	q2_mc.y=Y0;
	self.addChild(q2_mc);
	
	q1Text_mc.graphics.f("#000000").s().p("AAzBvIAAgCIAGgBIADgDIABgIIAAgrIgBgLIgBgDIgDgBIgGACIgBgCIAUgJIACAAIAABDIAAAIIACADIAIABIAAACgAg1A1IAAgEIAQgCQAEgCADgEQADgFAEgNIAQg7QgPAYgOAJQgLAGgIAAQgMAAgGgJQgHgKAAgMQAAgSAMgUQALgVATgNQAOgKAMAAQAIAAAFAFQAGAEACAJIAFgOIATgEIgoCJIgCAMQAAADABACQABABAAAAQAAABABAAQAAAAABABQAAAAABAAQAEACAFAAIgBAEgAgqhOQgQAagBAWQABAJAEAFQAEAFAFAAQAIAAAKgIQANgNAKgUQAJgTAAgPQAAgIgFgFQgEgFgHAAQgPAAgQAag");
	self.addChild(q1Text_mc);
	q2Text_mc.graphics.f("#000000").s().p("AAhBvIAAgCQAVgTAIgMQAIgMAAgKQAAgIgEgFQgFgEgGAAQgGAAgFADQgEADgDAHIgCAAQACgLAGgGQAGgFAJAAQAJAAAHAGQAGAGAAAJQAAAGgCAGQgFAJgJALIgTATIAVAAIAJgBIAFgBIADgFIACAAIgFAQgAg6A1IABgEIAPgCQAEgCADgEQADgFAEgNIARg7QgQAYgOAJQgKAGgJAAQgMAAgGgJQgGgKAAgMQAAgSALgUQALgVATgNQAOgKAMAAQAJAAAFAFQAFAEADAJIAEgOIATgEIgnCJIgDAMQAAADACACQAAABAAAAQABABAAAAQABAAAAABQABAAAAAAQAEACAFAAIAAAEgAgvhOQgQAaAAAWQAAAJAEAFQAEAFAGAAQAHAAAKgIQAOgNAJgUQAJgTAAgPQAAgIgEgFQgFgFgHAAQgOAAgRAag");
	self.addChild(q2Text_mc);
	
	F1Text_mc.graphics.f("#000000").s().p("AhWBTIACgFIANgBQAEgDADgDQADgFAFgQIAdhiQAEgNgBgGQABgEgCgCQgCgCgDgBQgDgBgKAAIACgFICAAAIgNAqIgEAAIABgMQAAgIgFgFQgEgFgHgCQgFgBgQAAIghAAIgSBCIAUAAQAPAAAHgFQAHgEAIgPIAFAAIgRA7IgGAAIACgMQAAgHgFgEQgEgFgOAAIgVAAIgPAyQgDAOAAAEQAAAEADADQADACAOABIgCAFg");
	self.addChild(F1Text_mc);
	
	F2Text_mc.graphics.f("#000000").s().p("AhWBTIACgFIANgBQAEgDADgDQADgFAFgQIAdhiQAEgNgBgGQABgEgCgCQgCgCgDgBQgDgBgKAAIACgFICAAAIgNAqIgEAAIABgMQAAgIgFgFQgEgFgHgCQgFgBgQAAIghAAIgSBCIAUAAQAPAAAHgFQAHgEAIgPIAFAAIgRA7IgGAAIACgMQAAgHgFgEQgEgFgOAAIgVAAIgPAyQgDAOAAAEQAAAEADADQADACAOABIgCAFg");
	self.addChild(F2Text_mc);
	
	
	F1Vec=createVector("#000000",false,true);
	self.addChild(F1Vec);
	
	
	F2Vec=createVector("#000000",false,true);
	self.addChild(F2Vec);
	
	self.addChild(text);
	
	
	createRegister();
	buttonVariables();
	initialize();
	
	createjs.Ticker.setFPS(60);   
	createjs.Ticker.addEventListener("tick", tick); 
	
	canvas.style.visibility = "visible";
}

// ΑΡΧΙΚΟΠΟΙΗΣΗ
function initialize() {
	restart();
}

// ΕΠΑΝΕΚΚΙΝΗΣΗ
function restart() {
	$( "#FScaleSlider" ).slider({value:50});
	$( "#q1Spinner" ).spinner().spinner('value',q1);
	$( "#q2Spinner" ).spinner().spinner('value',q2);
	$( "#force" ).prop('checked', forceFlag);
	
	checkCheckbox();
	
	positions();
}

// ΣΕ ΚΑΘΕ FRAME
function tick(e) {
	if (playMovie) {
		if (framePlay) {
			playMovie=false;
			framePlay=false;
		}
		positions();
	}
}
// ΘΕΣΕΙΣ
function positions() {
	// ΕΝΗΜΕΡΩΣΗ ΤΙΜΩΝ
	
	var x1 = (q1_mc.x-X0)/xScale;
	var y1 = (q1_mc.y-Y0)/yScale;
	
	var x2 = (q2_mc.x-X0)/xScale;
	var y2 = (q2_mc.y-Y0)/yScale;
	
	var φ1 = Math.atan2(y2-y1,x2-x1);
	if (q1*q2>0) {
		φ1=φ1+Math.PI;
	}
	
	var r = Math.sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
	var r2=r*r;
	
	var F = kc*Math.abs(q1*q2)/r2;
	
	q1Text_mc.setTransform(q1_mc.x,q1_mc.y-35);
	q2Text_mc.setTransform(q2_mc.x,q2_mc.y-35);
	
	F1Vec.setScaleX(F*FScale);
	F1Vec.rotation = -φ1*toDeg;
	F1Vec.x=q1_mc.x;
	F1Vec.y=q1_mc.y;
	
	F2Vec.setScaleX(F*FScale);
	F2Vec.rotation = -φ1*toDeg+180;
	F2Vec.x=q2_mc.x;
	F2Vec.y=q2_mc.y;
	
	updateTextVector(F1Text_mc,F1Vec,12,0);
	updateTextVector(F2Text_mc,F2Vec,12,0);
	
	if (forceFlag) {
		text.text = "r = "+Math.sqrt(r2).toFixed(1)+ " cm, F = "+F.toFixed(1)+" N";
	} else {
		text.text = "r = "+Math.sqrt(r2).toFixed(1)+ " cm";
	}
	stage.update();
};
// ΥΠΟΛΟΓΙΣΜΟΣ ΑΠΟΣΤΑΣΗΣ
function calckDistance() {
	var res = new Object();
	
	var x1 = (q1_mc.x-X0)/xScale;
	var y1 = (q1_mc.y-Y0)/yScale;
	
	var x2 = (q2_mc.x-X0)/xScale;
	var y2 = (q2_mc.y-Y0)/yScale;
	
	var φ = Math.atan2(y2-y1,x2-x1);
	if (q1*q2>0) {
		φ=φ+Math.PI;
	}
	
	var r = Math.sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
	
	res.r = Math.sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
	res.φ = φ;
	
	return res;
}
