﻿/*
(c) by Sitsanlis Ilias
*/

function mouseDownGen(e) {
	var w = canvas.width;
	var h = canvas.height;
	
	e.target.offset = {x: e.target.x - e.stageX*(720/w), y: e.target.y - e.stageY*(420/h)};
	e.target.addEventListener("pressmove",pressMoveGen);
};

function pressMoveGen(e) {
	var w = canvas.width;
	var h = canvas.height;
	
	var newX = e.stageX*(720/w) + e.target.offset.x;
	var newY = e.stageY*(420/h) + e.target.offset.y;
	
	e.target.x = newX
	e.target.y = newY
	
	positions()
	
};

function pressUpGen(e) {
	if (snapFlag) {
		snapToGrid(e.target.name)
	}
	e.target.removeEventListener("pressmove",pressMoveGen)	
};

function snapToGrid(dragName) {
	
	var x1 = (q1_mc.x-X0)/xScale
	var y1 = (q1_mc.y-Y0)/yScale

	var x2 = (q2_mc.x-X0)/xScale
	var y2 = (q2_mc.y-Y0)/yScale

	var r = Math.sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1))

	if (dragName=="q1_mc") {

		r = Math.round(r)
		var φ = Math.atan2(y1-y2,x1-x2)

		q1_mc.x = X0+xScale*(x2+r*Math.cos(φ))
		q1_mc.y = Y0+yScale*(y2+r*Math.sin(φ))
	}

	if (dragName=="q2_mc") {

		r = Math.round(r)
		var φ = Math.atan2(y2-y1,x2-x1)
		
		q2_mc.x = X0+xScale*(x1+r*Math.cos(φ))
		q2_mc.y = Y0+yScale*(y1+r*Math.sin(φ))
	}
	
	positions()
}