/*
(c) by Sitsanlis Ilias
*/

function handleComplete() { 
	function makeResponsive(isResp, respDim, isScale, scaleType) {		
		var lastW, lastH, lastS=1;
		window.addEventListener('resize', resizeCanvas);
		resizeCanvas();	
		function resizeCanvas() {
			
			var w = 720, h = 420;
			var iw =percent*window.innerWidth-4, ih=window.innerHeight-4;			
			var pRatio = window.devicePixelRatio || 1, xRatio=iw/w, yRatio=ih/h, sRatio=1;			
			
			if(isResp) {                
				if((respDim=='width'&&lastW==iw) || (respDim=='height'&&lastH==ih)) {                    
					sRatio = lastS;                
				}				
				else if(!isScale) {					
					if(iw<w || ih<h)						
						sRatio = Math.min(xRatio, yRatio);				
				}				
				else if(scaleType==1) {					
					sRatio = Math.min(xRatio, yRatio);
				}
				else if(scaleType==2) {
					sRatio = Math.max(xRatio, yRatio);
				}
			}
			
			canvas.width = w*pRatio*sRatio;	
			canvas.height = h*pRatio*sRatio;
			canvas.style.width =  w*sRatio+'px';
			canvas.style.height =  h*sRatio+'px';
			stage.scaleX = pRatio*sRatio;
			stage.scaleY = pRatio*sRatio;
			lastW = iw; lastH = ih; lastS = sRatio;
			
			document.getElementById('buttons').style.height = (h*sRatio).toString()+'px'
			
			stage.update();
		}
	}
	makeResponsive(true,'both',true,1);	
}

// ΣΧΕΔΙΑΣΗ ΦΟΡΤΙΟΥ
function drawChange(q_mc,q) {
	var g = q_mc.graphics;
	g.clear();
	if (q>0) {
		g.beginFill("#ff6633");
	} else if (q<0) {
		g.beginFill("#00ccff");
	} else {
		g.beginFill("#dddddd");
	}
	g.dc(0,0,20);
}

// ΔΗΜΙΟΥΡΓΙΑ ΠΡΟΣΗΜΟΥ
function sngNumber(x) {
	var res ;
	if (x<=0) {
		res=x.toString();
	} else {
		res = "+"+x.toString();
	}
	return res;
}


// ΔΗΜΙΟΥΡΓΙΑ ΔΙΑΝΥΣΜΑΤΟΣ
function createVector(lineColor,canDrag,drawStart) {
	if (lineColor==undefined) lineColor="#000000";
	if (canDrag==undefined) canDrag=false
	if (drawStart==undefined) drawStart=false
		
	var myVec = new createjs.Container();
	
	// ΟΡΙΣΜΟΣ ΤΗΣ ΓΡΑΜΜΗΣ ΤΟΥ ΔΙΑΝΥΣΜΑΤΟΣ
	var myLine = new createjs.Shape();
	myLine=createLineVector(lineColor);
	myVec.addChild(myLine);
	
	// ΟΡΙΣΜΟΣ ΤΟΥ ΒΕΛΟΥΣ ΤΟΥ ΔΙΑΝΥΣΜΑΤΟΣ
	var myArrow = new createjs.Shape();
	myArrow=createArrowVector(lineColor);
	myVec.addChild(myArrow);
	
	// ΟΡΙΣΜΟΣ ΤΗΣ ΓΡΑΜΜΗΣ ΓΙΑ drag and drop ΤΟΥ ΔΙΑΝΥΣΜΑΤΟΣ
	if (canDrag) {
		var myDragLine = new createjs.Shape();
		myDragLine=createDragLineVector();
		myVec.addChild(myDragLine);
	}
	
	// ΟΡΙΣΜΟΣ ΤΟΥ ΚΥΚΛΟΥ ΤΟΥ ΔΙΑΝΥΣΜΑΤΟΣ
	if (drawStart) {
		var myCircle = new createjs.Shape();
		myCircle=createCircleVector(lineColor);
		myVec.addChild(myCircle);
	}

	return myVec;
}

// ΣΧΕΔΙΑΣΗ ΓΡΑΜΜΗΣ ΔΙΑΝΥΣΜΑΤΟΣ
function createLineVector(lineColor) {
	if (lineColor==undefined) lineColor="#000000";
	
	var s = new createjs.Shape();
	var g = s.graphics;
	
	g.setStrokeStyle(2.5);
	g.beginStroke(lineColor);	
	g.moveTo(0,0);
	g.lineTo(100,0);
	g.endStroke();
	
	return s;
}
function createDragLineVector() {
	var s = new createjs.Shape();
	var g = s.graphics;
	g.setStrokeStyle(25)
	g.beginStroke("#ffffff");	
	g.moveTo(0,0);
	g.lineTo(100,0);
	g.endStroke();
	s.alpha=0.01;
	s.name="dragLine"
	return s;
}
function createCircleVector(lineColor) {
	if (lineColor==undefined) lineColor="#000000";
	var s = new createjs.Shape();
	var g = s.graphics;
	g.beginFill(lineColor);
	g.dc(0,0,4);
	s.name = "startVector";
	return s;
}
// ΣΧΕΔΙΑΣΗ ΒΕΛΟΥΣ
function createArrowVector(lineColor) {
	if (lineColor==undefined) lineColor="#000000";
	var s = new createjs.Shape();
	var g = s.graphics;
	var dL=8;
	var φ1=180-25;
	var φ2=180+25;
	g.setStrokeStyle(1.5,'round','round');
	g.beginStroke(lineColor);
	g.beginFill(lineColor);
	g.moveTo(0,0);
	g.lineTo(dL*Math.cos(φ1*toRad),-dL*Math.sin(φ1*toRad));
	g.lineTo(-5.5,0)
	g.lineTo(dL*Math.cos(φ2*toRad),-dL*Math.sin(φ2*toRad));
	g.closePath();
	g.endFill();
	g.endStroke();
	return s;
}
// ΕΝΗΜΕΡΩΣΗ ΜΕΤΡΟΥ ΔΙΑΝΥΣΜΑΤΟΣ
createjs.Container.prototype.setScaleX=function(norm) {
	var lineVec=this.getChildAt(0);
	var arrowVec=this.getChildAt(1);
	var dragLineVec=this.getChildByName("dragLine")
	var dragCircleVec=this.getChildByName("startVector")
	arrowVec.x=norm;
	var e;
	if (norm<0) {e=-1} else {e=1}
	if (Math.abs(norm)>=25) {
		arrowVec.scaleX=e;
		lineVec.scaleX = (norm-e)/100;
		if (dragLineVec!=null) dragLineVec.scaleX = (norm-e)/100;
	} else {
		arrowVec.scaleX=4*norm/100;
		lineVec.scaleX = (norm)/100-4*norm/100/100;
		if (dragLineVec!=null) dragLineVec.scaleX = (norm)/100-4*norm/100/100;
	}
}

// ΕΝΗΜΕΡΩΣΗ ΚΕΙΜΕΝΟΥ
function updateTextVector(myText,myVec,dx,dy) {
	var ω=myVec.rotation;
	arrowVec=myVec.getChildAt(1);
	var scaleVec=arrowVec.x
	if (scaleVec<0) {
		scaleVec=Math.abs(scaleVec);
		ω+=180;
	}
	var scaleVec=Math.abs(scaleVec);
	var X=scaleVec*Math.cos(ω*toRad);
	var Y=scaleVec*Math.sin(ω*toRad);
	var textX=myVec.x+X+dx*Math.cos(ω*toRad)+dy*Math.cos((ω+90)*toRad);
	var textY=myVec.y+Y+dx*Math.sin(ω*toRad)+dy*Math.sin((ω+90)*toRad);
	myText.x = textX;
	myText.y = textY;
	myText.textBaseline = "alphabetic";
	myText.textAlign = "center";
	if (Math.abs(scaleVec)<5) {
		myText.alpha=0;
	} else {
		myText.alpha=1;
	}
}
// DRAG AND DROP ΔΙΑΝΥΣΜΑΤΟΣ
function mouseDownVector(e) {
	var targetObject=e.target
	targetObject.addEventListener("pressmove",pressMoveVector);
}

function pressMoveVector (e) {
	
}

function pressUpVector(e) {
	e.target.removeEventListener("pressmove",pressMoveVector);	
}

