/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa;

import com.singularsys.aa.ExpressionPrinterVisitor;
import com.singularsys.aa.SimpleExpr;
import com.singularsys.aa.linear.LinearCoefficientExtractor;
import com.singularsys.aa.linear.LinearExpr;
import com.singularsys.aa.logging.Logger;
import com.singularsys.aa.manipulation.Substituter;
import com.singularsys.aa.polynomial.PolyExtractor;
import com.singularsys.aa.polynomial.PolySimplifier;
import com.singularsys.aa.polynomial.PolynomialExpr;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.EvaluatorVisitor;
import org.nfunk.jep.Node;
import org.nfunk.jep.SymbolTable;

public class UntypifiedExpr
extends SimpleExpr {
    private boolean isPolynomial;
    private PolynomialExpr poly;
    private boolean isLinear;
    private LinearExpr linearEq;
    private Node topNode;
    private Vector errorList = new Vector();
    private static EvaluatorVisitor ev = new EvaluatorVisitor();

    public UntypifiedExpr(Node node) throws Exception {
        this.topNode = node;
        this.collectVariables(this.topNode);
    }

    public void setTopNode(Node node) {
        this.topNode = node;
        this.variables = new Vector();
        this.collectVariables(this.topNode);
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public String toString() {
        return new ExpressionPrinterVisitor().getString(this.topNode);
    }

    private void collectVariables(Node node) {
        if (node instanceof ASTVarNode) {
            String string = ((ASTVarNode)node).getName();
            if (!this.variables.contains(string)) {
                this.variables.addElement(string);
            }
        } else {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                this.collectVariables(node.jjtGetChild(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(Hashtable hashtable) throws Exception {
        Object object;
        Object object2;
        SymbolTable symbolTable = new SymbolTable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            symbolTable.put(object2, hashtable.get(object2));
        }
        this.errorList.removeAllElements();
        try {
            object2 = ev;
            synchronized (object2) {
                object = ev.getValue(this.topNode, this.errorList, symbolTable);
            }
        }
        catch (Exception exception) {
            String string = "Errors occured during evaluation of equation:\n";
            string = string + "Exception: " + exception.toString() + "\n";
            for (int i = 0; i < this.errorList.size(); ++i) {
                string = string + (String)this.errorList.elementAt(i) + "\n";
            }
            System.out.println(string);
            throw new Exception(string);
        }
        return object;
    }

    public PolynomialExpr polynomialCheck() {
        PolynomialExpr polynomialExpr = new PolynomialExpr(this.variables);
        try {
            PolyExtractor.extractFromTree(this, polynomialExpr);
            Logger.println("Polynomial extraction successful");
            Logger.println(polynomialExpr.toString());
            PolySimplifier.simplify(polynomialExpr);
            Logger.println("After simplification:");
            Logger.println(polynomialExpr.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        this.isPolynomial = true;
        this.poly = polynomialExpr;
        return this.poly;
    }

    public boolean isPolynomial() {
        return this.isPolynomial;
    }

    public LinearExpr linearCheck() {
        LinearExpr linearExpr;
        if (!this.isPolynomial) {
            return null;
        }
        try {
            linearExpr = LinearCoefficientExtractor.getLinearExpr(this.poly);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        return linearExpr;
    }

    public boolean substitute(String string, Object object) {
        return this.substitute(string, object, new Substituter());
    }

    public boolean substitute(String string, Object object, Substituter substituter) {
        if (this.variables.removeElement(string)) {
            substituter.substitute(this.topNode, string, object);
            return true;
        }
        return false;
    }
}

