/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa.gui.awt;

import com.singularsys.aa.Solution;
import com.singularsys.aa.SolverListener;
import com.singularsys.aa.ThreadControl;
import com.singularsys.aa.gui.awt.AboutDialog;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;

public class AWTFrame
extends Frame
implements ClipboardOwner {
    private static final boolean useClipboard = false;
    private Clipboard clipboard;
    private Image icon;
    private MenuItem aboutItem;
    private MenuItem closeItem;
    private MenuItem copyItem;
    private MenuItem cutItem;
    private Menu editMenu;
    private Label eqLabel;
    private TextArea eqTextArea;
    private Label eqoutLabel;
    private TextArea eqoutTextArea;
    private Label errorsLabel;
    private TextArea errorsTextArea;
    private Menu fileMenu;
    private Menu helpMenu;
    private MenuBar menuBar;
    private MenuItem openItem;
    private Panel panel1;
    private Panel panel2;
    private MenuItem pasteItem;
    private MenuItem saveItem;
    private MenuItem saveasItem;
    private Label solLabel;
    private TextArea solTextArea;

    public AWTFrame() {
        this.initIcon();
        this.initComponents();
        this.solveEquations();
        ((Component)this).setSize(500, 350);
    }

    private void initIcon() {
        this.icon = null;
        String string = "/com/singularsys/aa/gui/images/icon.gif";
        try {
            MediaTracker mediaTracker = new MediaTracker(this);
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                System.out.println("InputStream is null for " + string);
                return;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[10000];
            int n = bufferedInputStream.read(byArray, 0, 10000);
            this.icon = Toolkit.getDefaultToolkit().createImage(byArray);
            mediaTracker.addImage(this.icon, 0);
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initComponents() {
        this.panel1 = new Panel();
        this.eqLabel = new Label();
        this.eqTextArea = new TextArea();
        this.panel2 = new Panel();
        this.eqoutLabel = new Label();
        this.eqoutTextArea = new TextArea();
        this.solLabel = new Label();
        this.solTextArea = new TextArea();
        this.errorsLabel = new Label();
        this.errorsTextArea = new TextArea();
        this.menuBar = new MenuBar();
        this.fileMenu = new Menu();
        this.openItem = new MenuItem();
        this.saveItem = new MenuItem();
        this.saveasItem = new MenuItem();
        this.closeItem = new MenuItem();
        this.editMenu = new Menu();
        this.cutItem = new MenuItem();
        this.copyItem = new MenuItem();
        this.pasteItem = new MenuItem();
        this.helpMenu = new Menu();
        this.aboutItem = new MenuItem();
        this.setLayout(new GridBagLayout());
        this.setIconImage(this.icon);
        this.setTitle("AutoAbacus");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AWTFrame.this.exitForm(windowEvent);
            }
        });
        this.panel1.setLayout(new GridBagLayout());
        this.eqLabel.setText("Equations");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 2, 0, 0);
        this.panel1.add((Component)this.eqLabel, gridBagConstraints);
        this.eqTextArea.setFont(new Font("Monospaced", 0, 12));
        this.eqTextArea.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent textEvent) {
                AWTFrame.this.eqTextAreaTextValueChanged(textEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panel1.add((Component)this.eqTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panel1, gridBagConstraints);
        this.panel2.setLayout(new GridBagLayout());
        this.eqoutLabel.setText("Equations");
        this.eqoutLabel.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 2, 0, 0);
        this.panel2.add((Component)this.eqoutLabel, gridBagConstraints);
        this.eqoutTextArea.setEditable(false);
        this.eqoutTextArea.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.panel2.add((Component)this.eqoutTextArea, gridBagConstraints);
        this.solLabel.setText("Solutions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 2, 0, 0);
        this.panel2.add((Component)this.solLabel, gridBagConstraints);
        this.solTextArea.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.panel2.add((Component)this.solTextArea, gridBagConstraints);
        this.errorsLabel.setText("Errors");
        this.errorsLabel.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 2, 0, 0);
        this.panel2.add((Component)this.errorsLabel, gridBagConstraints);
        this.errorsTextArea.setEditable(false);
        this.errorsTextArea.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.panel2.add((Component)this.errorsTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panel2, gridBagConstraints);
        this.fileMenu.setLabel("File");
        this.openItem.setLabel("Open...");
        this.openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWTFrame.this.openItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.openItem);
        this.saveItem.setEnabled(false);
        this.saveItem.setLabel("Save");
        this.saveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWTFrame.this.saveItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.saveItem);
        this.saveasItem.setLabel("Save As...");
        this.saveasItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWTFrame.this.saveasItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.saveasItem);
        this.fileMenu.addSeparator();
        this.closeItem.setLabel("Close");
        this.closeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWTFrame.this.closeItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.closeItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setEnabled(false);
        this.editMenu.setLabel("Edit");
        this.cutItem.setEnabled(false);
        this.cutItem.setLabel("Cut");
        this.cutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWTFrame.this.cutItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.cutItem);
        this.copyItem.setEnabled(false);
        this.copyItem.setLabel("Copy");
        this.copyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWTFrame.this.copyItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.copyItem);
        this.pasteItem.setEnabled(false);
        this.pasteItem.setLabel("Paste");
        this.pasteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWTFrame.this.pasteItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.pasteItem);
        this.menuBar.add(this.editMenu);
        this.helpMenu.setLabel("Help");
        this.aboutItem.setActionCommand("About AutoAbacus");
        this.aboutItem.setLabel("About AutoAbacus");
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWTFrame.this.aboutItemActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.menuBar.add(this.helpMenu);
        this.setMenuBar(this.menuBar);
        this.pack();
    }

    private void saveasItemActionPerformed(ActionEvent actionEvent) {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save", 1);
        String string = System.getProperty("line.separator");
        fileDialog.show();
        try {
            FileWriter fileWriter = new FileWriter(fileDialog.getDirectory() + fileDialog.getFile());
            String string2 = this.eqTextArea.getText();
            for (int i = 0; i < string2.length(); ++i) {
                String string3 = "";
                while (i < string2.length() && string2.charAt(i) != '\n') {
                    string3 = string3 + string2.charAt(i);
                    ++i;
                }
                fileWriter.write(string3 + string);
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            System.err.println("Error saving to \"" + fileDialog.getDirectory() + fileDialog.getFile() + "\"");
        }
    }

    private void openItemActionPerformed(ActionEvent actionEvent) {
        FileDialog fileDialog = new FileDialog((Frame)this, "Open", 0);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        fileDialog.show();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(fileDialog.getDirectory() + fileDialog.getFile()));
            while (bufferedReader.ready()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(bufferedReader.readLine());
            }
            bufferedReader.close();
            this.eqTextArea.setText(stringBuffer.toString());
        }
        catch (Exception exception) {
            System.err.println("Error while opening \"" + fileDialog.getDirectory() + fileDialog.getFile() + "\"");
        }
    }

    private void saveItemActionPerformed(ActionEvent actionEvent) {
    }

    private void cutItemActionPerformed(ActionEvent actionEvent) {
    }

    private void copyItemActionPerformed(ActionEvent actionEvent) {
    }

    private void pasteItemActionPerformed(ActionEvent actionEvent) {
    }

    private void aboutItemActionPerformed(ActionEvent actionEvent) {
        new AboutDialog((Frame)this, true).show();
    }

    private void closeItemActionPerformed(ActionEvent actionEvent) {
        this.exitForm(null);
    }

    private void eqTextAreaTextValueChanged(TextEvent textEvent) {
        this.solveEquations();
    }

    private void solveEquations() {
        SolverListener solverListener = new SolverListener(){

            public void updateSolution(Solution solution, String string, String string2) {
                AWTFrame.this.updateSol(solution, string, string2);
            }
        };
        String string = this.eqTextArea.getText();
        try {
            ThreadControl.startNewThread(solverListener, string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public void updateSol(Solution solution, String string, String string2) {
        if (solution == null) {
            this.solTextArea.setText("No solutions found\n\n" + string);
        } else {
            this.solTextArea.setText(solution.toString());
        }
        System.out.println(string2);
    }

    private void exitForm(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public static void main(String[] stringArray) {
        ((Component)new AWTFrame()).setVisible(true);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

