/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa.linear;

import Jama.Matrix;
import com.singularsys.aa.EquationSystem;
import com.singularsys.aa.Solution;
import com.singularsys.aa.UntypifiedExpr;
import com.singularsys.aa.linear.LinearExpr;
import com.singularsys.aa.logging.Logger;
import com.singularsys.aa.polynomial.PolynomialExpr;
import java.io.PrintWriter;
import java.util.Vector;

public class LinearSolver {
    public Solution solveSystem(EquationSystem equationSystem) throws Exception {
        Vector vector = equationSystem.getVariables();
        int n = vector.size();
        Matrix matrix = new Matrix(n, n);
        Matrix matrix2 = new Matrix(n, 1);
        Logger.println("LinearSolver.solveSystem()");
        if (n != equationSystem.getNumEquations()) {
            Logger.println("#eq != #unknowns");
            throw new Exception("Unequal number of equations and unknowns.");
        }
        try {
            this.getCoefficients(equationSystem, matrix, matrix2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        Logger.println("Matrices loaded");
        Logger.println("Matrix A = ");
        matrix.print((PrintWriter)Logger.getLogWriter(), 10, 3);
        Logger.println("Matrix b = ");
        matrix2.print((PrintWriter)Logger.getLogWriter(), 10, 3);
        Logger.println("----------------------");
        Matrix matrix3 = this.trySolving(matrix, matrix2);
        Solution solution = new Solution();
        for (int i = 0; i < n; ++i) {
            solution.addSolution((String)vector.elementAt(i), new Double(matrix3.get(i, 0)));
        }
        return solution;
    }

    private void getCoefficients(EquationSystem equationSystem, Matrix matrix, Matrix matrix2) throws Exception {
        Vector vector = equationSystem.getVariables();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            LinearExpr linearExpr;
            UntypifiedExpr untypifiedExpr = (UntypifiedExpr)equationSystem.getEquation(i);
            PolynomialExpr polynomialExpr = untypifiedExpr.polynomialCheck();
            if (polynomialExpr != null) {
                linearExpr = untypifiedExpr.linearCheck();
                if (linearExpr == null) {
                    throw new Exception("Equation is polynomial, but not linear");
                }
            } else {
                throw new Exception("Equation is not polynomial");
            }
            matrix2.set(i, 0, -((Double)linearExpr.getConstant()).doubleValue());
            for (int j = 0; j < n; ++j) {
                String string = (String)vector.elementAt(j);
                double d = (Double)linearExpr.getCoefficient(string);
                matrix.set(i, j, d);
            }
        }
    }

    private Matrix trySolving(Matrix matrix, Matrix matrix2) throws Exception {
        Matrix matrix3 = matrix.solve(matrix2);
        Logger.println("Matrix x = ");
        matrix3.print((PrintWriter)Logger.getLogWriter(), 10, 3);
        Matrix matrix4 = matrix.times(matrix3).minus(matrix2);
        double d = matrix4.normInf();
        Logger.println("Normalized residual = " + d);
        return matrix3;
    }
}

