/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa.polynomial;

import com.singularsys.aa.polynomial.PolynomialExpr;
import com.singularsys.aa.polynomial.PolynomialTerm;
import java.util.Vector;

public class PolySimplifier {
    private static final double zeroTolerance = 1.0E-20;
    private static final double expTolerance = 1.0E-16;

    public static void simplify(PolynomialExpr polynomialExpr) {
        PolySimplifier.combineTerms(polynomialExpr);
        PolySimplifier.deleteZeroTerms(polynomialExpr);
    }

    private static void combineTerms(PolynomialExpr polynomialExpr) {
        PolynomialExpr polynomialExpr2 = new PolynomialExpr(polynomialExpr.getVariables());
        Vector vector = polynomialExpr.getTerms();
        for (int i = 0; i < vector.size() - 1; ++i) {
            PolynomialTerm polynomialTerm = (PolynomialTerm)vector.elementAt(i);
            double d = ((Number)polynomialTerm.getCoefficient()).doubleValue();
            int n = i + 1;
            while (n < vector.size()) {
                PolynomialTerm polynomialTerm2 = (PolynomialTerm)vector.elementAt(n);
                if (PolySimplifier.exponentsMatch(polynomialTerm, polynomialTerm2)) {
                    d += ((Number)polynomialTerm2.getCoefficient()).doubleValue();
                    vector.removeElementAt(n);
                    continue;
                }
                ++n;
            }
            polynomialTerm.setCoefficient(new Double(d));
        }
    }

    private static void deleteZeroTerms(PolynomialExpr polynomialExpr) {
        Vector vector = polynomialExpr.getTerms();
        int n = 0;
        while (n < vector.size()) {
            PolynomialTerm polynomialTerm = (PolynomialTerm)vector.elementAt(n);
            double d = ((Number)polynomialTerm.getCoefficient()).doubleValue();
            if (d < 1.0E-20 && d > -1.0E-20) {
                vector.removeElementAt(n);
                continue;
            }
            ++n;
        }
    }

    private static boolean exponentsMatch(PolynomialTerm polynomialTerm, PolynomialTerm polynomialTerm2) {
        for (int i = 0; i < polynomialTerm.getNumberOfVariables(); ++i) {
            double d;
            double d2 = ((Number)polynomialTerm.getExponent(i)).doubleValue();
            if (!(Math.abs((d2 - (d = ((Number)polynomialTerm2.getExponent(i)).doubleValue())) / d2) > 1.0E-16)) continue;
            return false;
        }
        return true;
    }
}

