/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa.polynomial;

import java.util.Hashtable;
import java.util.Vector;

public class PolynomialTerm {
    private int nVar;
    private Object coefficient;
    private Object[] exponent;

    public PolynomialTerm(int n) {
        this.nVar = n;
        this.coefficient = new Double(1.0);
        this.exponent = new Object[this.nVar];
        for (int i = 0; i < this.nVar; ++i) {
            this.exponent[i] = new Double(0.0);
        }
    }

    public void setCoefficient(Object object) {
        this.coefficient = object;
    }

    public void setExponent(int n, Object object) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.nVar - 1) {
            throw new IndexOutOfBoundsException();
        }
        this.exponent[n] = object;
    }

    public Object getCoefficient() {
        return this.coefficient;
    }

    public Object getExponent(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.nVar - 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.exponent[n];
    }

    public int getNumberOfVariables() {
        return this.nVar;
    }

    public double getValue(Vector vector, Hashtable hashtable) {
        double d = (Double)this.coefficient;
        for (int i = 0; i < this.nVar; ++i) {
            Object v = hashtable.get(vector.elementAt(i));
            double d2 = (Double)this.exponent[i];
            d *= Math.pow((Double)v, d2);
        }
        return d;
    }
}

