/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Multiply
extends PostfixMathCommand {
    public Multiply() {
        this.numberOfParameters = -1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object object = stack.pop();
        int n = 1;
        while (n < this.curNumberOfParameters) {
            Object e = stack.pop();
            object = this.mul(object, e);
            ++n;
        }
        stack.push(object);
    }

    public Object mul(Object object, Object object2) throws ParseException {
        if (object instanceof Double) {
            if (object2 instanceof Double) {
                return this.mul((Double)object, (Double)object2);
            }
            if (object2 instanceof Complex) {
                return this.mul((Complex)object2, (Double)object);
            }
            if (object2 instanceof Vector) {
                return this.mul((Vector)object2, (Double)object);
            }
        } else if (object instanceof Complex) {
            if (object2 instanceof Double) {
                return this.mul((Complex)object, (Double)object2);
            }
            if (object2 instanceof Complex) {
                return this.mul((Complex)object, (Complex)object2);
            }
            if (object2 instanceof Vector) {
                return this.mul((Vector)object2, (Complex)object);
            }
        } else if (object instanceof Vector) {
            if (object2 instanceof Double) {
                return this.mul((Vector)object, (Double)object2);
            }
            if (object2 instanceof Complex) {
                return this.mul((Vector)object, (Complex)object2);
            }
        }
        throw new ParseException("Invalid parameter type");
    }

    public Double mul(Double d, Double d2) {
        return new Double(d * d2);
    }

    public Complex mul(Complex complex, Complex complex2) {
        return complex.mul(complex2);
    }

    public Complex mul(Complex complex, Double d) {
        return complex.mul(d);
    }

    public Vector mul(Vector vector, Double d) {
        Vector<Double> vector2 = new Vector<Double>();
        int n = 0;
        while (n < vector.size()) {
            vector2.addElement(this.mul((Double)vector.elementAt(n), d));
            ++n;
        }
        return vector2;
    }

    public Vector mul(Vector vector, Complex complex) {
        Vector<Complex> vector2 = new Vector<Complex>();
        int n = 0;
        while (n < vector.size()) {
            vector2.addElement(this.mul(complex, (Double)vector.elementAt(n)));
            ++n;
        }
        return vector2;
    }
}

