/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Subtract
extends PostfixMathCommand {
    public Subtract() {
        this.numberOfParameters = 2;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e = stack.pop();
        Object e2 = stack.pop();
        stack.push(this.sub(e2, e));
    }

    public Object sub(Object object, Object object2) throws ParseException {
        if (object instanceof Double) {
            if (object2 instanceof Double) {
                return this.sub((Double)object, (Double)object2);
            }
            if (object2 instanceof Complex) {
                return this.sub((Double)object, (Complex)object2);
            }
        } else if (object instanceof Complex) {
            if (object2 instanceof Double) {
                return this.sub((Complex)object, (Double)object2);
            }
            if (object2 instanceof Complex) {
                return this.sub((Complex)object, (Complex)object2);
            }
        }
        throw new ParseException("Invalid parameter type");
    }

    public Double sub(Double d, Double d2) {
        return new Double(d - d2);
    }

    public Complex sub(Complex complex, Complex complex2) {
        return new Complex(complex.re() - complex2.re(), complex.im() - complex2.im());
    }

    public Complex sub(Complex complex, Double d) {
        return new Complex(complex.re() - d, complex.im());
    }

    public Complex sub(Double d, Complex complex) {
        return new Complex(d - complex.re(), -complex.im());
    }
}

