/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class MulSquareGrid
extends Canvas {
    private int cols;
    private int rows;
    private int xVal;
    private int yVal;
    private int yellow;
    private int red;
    private int gridx;
    private int gridy;

    public MulSquareGrid(int cols, int rows) {
        this.setBounds(0, 0, 360, 360);
        this.cols = cols;
        this.rows = rows;
    }

    private void fixGrid(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        this.gridx = w / this.cols;
        this.gridy = h / this.rows;
        g.setColor(Color.lightGray);
        int x = this.gridx;
        while (x < w) {
            g.drawLine(x, 1, x, h + 1);
            x += this.gridx;
        }
        int y = this.gridy;
        while (y < h) {
            g.drawLine(1, h - y, w + 1, h - y);
            y += this.gridy;
        }
        g.setColor(Color.black);
        int i = 1;
        int x2 = this.gridx;
        while (x2 < w) {
            if (i % 10 == 0) {
                g.drawLine(x2, 1, x2, h + 1);
            }
            ++i;
            x2 += this.gridx;
        }
        i = 1;
        int y2 = this.gridy;
        while (y2 < h) {
            if (i % 10 == 0) {
                g.drawLine(1, h - y2, w + 1, h - y2);
            }
            ++i;
            y2 += this.gridy;
        }
        g.drawRect(0, 0, w - 1, h - 1);
    }

    public void repaint() {
        Graphics g = this.getGraphics();
        if (g != null) {
            this.paint(g);
        }
    }

    public void paint(Graphics g) {
        Image tmp = this.createImage(this.getWidth(), this.getHeight());
        Graphics tmpg = tmp.getGraphics();
        tmpg.setColor(Color.white);
        tmpg.fillRect(0, 0, this.getWidth(), this.getHeight());
        tmpg.setColor(Color.yellow);
        tmpg.fillRect(0, this.getHeight() - this.yVal * this.gridy, this.yellow * this.gridx, this.yVal * this.gridy);
        tmpg.setColor(Color.red);
        tmpg.fillRect(this.yellow * this.gridx, this.getHeight() - this.yVal * this.gridy, this.red * this.gridx, this.yVal * this.gridy);
        this.fixGrid(tmpg);
        g.drawImage(tmp, 0, 0, this);
    }

    public void setDimensions(int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
        this.repaint();
    }

    public void setYellow(int y) {
        this.yellow = y;
        this.repaint();
    }

    public void setRed(int r) {
        this.red = r;
        this.repaint();
    }

    public void setRectangles(int yellow, int red) {
        this.red = red;
        this.yellow = yellow;
        this.repaint();
    }

    public void setXVal(int x) {
        this.xVal = x;
        if (x != 0) {
            this.yellow = x / 10;
            this.yellow *= 10;
            this.red = x % 10;
        } else {
            this.yellow = 0;
            this.red = 0;
        }
        this.repaint();
    }

    public void setYVal(int y) {
        this.yVal = y;
        this.repaint();
    }

    public void setXYVal(int x, int y) {
        this.xVal = x;
        this.yVal = y;
        this.repaint();
    }
}

