/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class SpreadSheet
extends JPanel
implements ClipboardOwner {
    private Clipboard clipboard;
    JTable table;
    MyTableModel myModel;
    JScrollPane scrollPane;
    Vector functions = new Vector();
    boolean disabled = false;
    int selectedRow = -1;
    int selectedCol = -1;
    int selectedFunction = -1;
    Vector iconPlotImages;
    Applet parent;
    final int ADD = 1;
    final int SUB = 2;
    final int MUL = 3;
    final int DIV = 4;
    final int SUM = 5;
    final int AVG = 6;
    Vector source1_sel = new Vector();
    Vector source2_sel = new Vector();
    Vector target_sel = new Vector();
    int data_counter;
    private JButton jButton2;
    private JPanel jPanel4;
    private JComboBox func;
    private JLabel jLabel1;
    private JButton jButton7;
    private JLabel jLabel3;
    private JPanel jPanel3;
    private JButton jButton8;
    private JLabel jLabel2;
    private JButton jButton1;
    private JButton jButton12;
    private JPanel jPanel2;
    private JButton jButton11;
    private JButton jButton3;
    private JButton jButton9;
    private JButton jButton10;
    private JButton jButton6;
    private JButton jButton5;
    private JButton field_3;
    private JLabel status;
    private JButton field_2;
    private JButton field_1;
    private JPanel jPanel1;
    private JButton jButton4;
    private JLabel jLabel6;
    private JButton insertFunction;
    private JTextField function_name;
    private JTabbedPane jTabbedPane1;
    static /* synthetic */ Class class$java$lang$String;

    public SpreadSheet(Applet parent) {
        this.parent = parent;
        this.initComponents();
        this.createTable();
        this.clipboard = this.getToolkit().getSystemClipboard();
        this.data_counter = 0;
        this.func.addItem(new FunctionType(1, "+"));
        this.func.addItem(new FunctionType(2, "-"));
        this.func.addItem(new FunctionType(3, "*"));
        this.func.addItem(new FunctionType(4, "/"));
        this.func.addItem(new FunctionType(5, "\u0386\u03b8\u03c1\u03bf\u03b9\u03c3\u03bc\u03b1"));
        this.func.addItem(new FunctionType(6, "\u039c\u03ad\u03c3\u03bf\u03c2 \u038c\u03c1\u03bf\u03c2"));
    }

    public void addData(String str) {
        StringTokenizer stoken = new StringTokenizer(str, " ");
        int col_count = 1;
        while (stoken.hasMoreTokens()) {
            String val = stoken.nextToken();
            this.table.setValueAt(val, this.data_counter, col_count++);
        }
        ++this.data_counter;
    }

    private void createTable() {
        this.myModel = new MyTableModel(this);
        this.table = new JTable(this.myModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.table.getColumnModel().getColumn(0).setMaxWidth(25);
        this.table.getColumnModel().getColumn(1).setMinWidth(25);
        this.table.setColumnSelectionAllowed(true);
        this.table.setCellSelectionEnabled(true);
        this.table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = SpreadSheet.class$("java.lang.String")) : class$java$lang$String, new myTableRenderer());
        ListSelectionModel tableSM_col = this.table.getColumnModel().getSelectionModel();
        tableSM_col.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                SpreadSheet.this.selectedCol = lsm.isSelectionEmpty() ? -1 : lsm.getMinSelectionIndex();
                SpreadSheet.this.checkTableSelection();
            }
        });
        ListSelectionModel tableSM_row = this.table.getSelectionModel();
        tableSM_row.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                SpreadSheet.this.selectedRow = lsm.isSelectionEmpty() ? -1 : lsm.getMinSelectionIndex();
                SpreadSheet.this.checkTableSelection();
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 127) {
                    SpreadSheet.this.DeleteTable();
                }
                if (ke.getModifiers() == 2) {
                    if (ke.getKeyCode() == 67) {
                        SpreadSheet.this.CopyToClipboard();
                        ke.consume();
                    }
                    if (ke.getKeyCode() == 86) {
                        SpreadSheet.this.PasteFromClipboard();
                        ke.consume();
                    }
                    if (ke.getKeyCode() == 88) {
                        SpreadSheet.this.CopyToClipboard();
                        SpreadSheet.this.DeleteTable();
                        ke.consume();
                    }
                }
            }
        });
        this.scrollPane = new JScrollPane(this.table);
        this.add((Component)this.scrollPane, "Center");
    }

    public void checkFunctions() {
        NumberFormat nformat = NumberFormat.getInstance();
        nformat.setMaximumFractionDigits(5);
        this.disabled = true;
        block10: for (int j = 0; j < this.functions.size(); ++j) {
            Function f = (Function)this.functions.get(j);
            Point[] p1 = f.source1;
            Point[] p2 = f.source2;
            Point[] p3 = f.target;
            try {
                switch (f.func_type) {
                    case 1: {
                        float result;
                        float p2_val;
                        if (p2.length == 1) {
                            for (int i = 0; i < p1.length; ++i) {
                                float p1_val = Float.parseFloat(((String)this.table.getValueAt(p1[i].x, p1[i].y)).replace(',', '.'));
                                p2_val = Float.parseFloat(((String)this.table.getValueAt(p2[0].x, p2[0].y)).replace(',', '.'));
                                result = p1_val + p2_val;
                                this.table.setValueAt(nformat.format(result), p3[i].x, p3[i].y);
                            }
                            continue block10;
                        }
                        for (int i = 0; i < p1.length; ++i) {
                            float p1_val = Float.parseFloat(((String)this.table.getValueAt(p1[i].x, p1[i].y)).replace(',', '.'));
                            p2_val = Float.parseFloat(((String)this.table.getValueAt(p2[i].x, p2[i].y)).replace(',', '.'));
                            result = p1_val + p2_val;
                            this.table.setValueAt(nformat.format(result), p3[i].x, p3[i].y);
                        }
                        continue block10;
                    }
                    case 2: {
                        float result;
                        float p2_val;
                        if (p2.length == 1) {
                            for (int i = 0; i < p1.length; ++i) {
                                float p1_val = Float.parseFloat(((String)this.table.getValueAt(p1[i].x, p1[i].y)).replace(',', '.'));
                                p2_val = Float.parseFloat(((String)this.table.getValueAt(p2[0].x, p2[0].y)).replace(',', '.'));
                                result = p1_val - p2_val;
                                this.table.setValueAt(nformat.format(result), p3[i].x, p3[i].y);
                            }
                            continue block10;
                        }
                        for (int i = 0; i < p1.length; ++i) {
                            float p1_val = Float.parseFloat(((String)this.table.getValueAt(p1[i].x, p1[i].y)).replace(',', '.'));
                            p2_val = Float.parseFloat(((String)this.table.getValueAt(p2[i].x, p2[i].y)).replace(',', '.'));
                            result = p1_val - p2_val;
                            this.table.setValueAt(nformat.format(result), p3[i].x, p3[i].y);
                        }
                        continue block10;
                    }
                    case 3: {
                        float result;
                        float p2_val;
                        if (p2.length == 1) {
                            for (int i = 0; i < p1.length; ++i) {
                                float p1_val = Float.parseFloat(((String)this.table.getValueAt(p1[i].x, p1[i].y)).replace(',', '.'));
                                p2_val = Float.parseFloat(((String)this.table.getValueAt(p2[0].x, p2[0].y)).replace(',', '.'));
                                result = p1_val * p2_val;
                                this.table.setValueAt(nformat.format(result), p3[i].x, p3[i].y);
                            }
                            continue block10;
                        }
                        for (int i = 0; i < p1.length; ++i) {
                            float p1_val = Float.parseFloat(((String)this.table.getValueAt(p1[i].x, p1[i].y)).replace(',', '.'));
                            p2_val = Float.parseFloat(((String)this.table.getValueAt(p2[i].x, p2[i].y)).replace(',', '.'));
                            result = p1_val * p2_val;
                            this.table.setValueAt(nformat.format(result), p3[i].x, p3[i].y);
                        }
                        continue block10;
                    }
                    case 4: {
                        String result_str;
                        float result;
                        float p2_val;
                        if (p2.length == 1) {
                            for (int i = 0; i < p1.length; ++i) {
                                float p1_val = Float.parseFloat(((String)this.table.getValueAt(p1[i].x, p1[i].y)).replace(',', '.'));
                                p2_val = Float.parseFloat(((String)this.table.getValueAt(p2[0].x, p2[0].y)).replace(',', '.'));
                                result = 0.0f;
                                result_str = "";
                                if (p2_val == 0.0f) {
                                    result_str = "NaN";
                                } else {
                                    result = p1_val / p2_val;
                                    result_str = nformat.format(result);
                                }
                                this.table.setValueAt(result_str, p3[i].x, p3[i].y);
                            }
                            continue block10;
                        }
                        for (int i = 0; i < p1.length; ++i) {
                            float p1_val = Float.parseFloat(((String)this.table.getValueAt(p1[i].x, p1[i].y)).replace(',', '.'));
                            p2_val = Float.parseFloat(((String)this.table.getValueAt(p2[i].x, p2[i].y)).replace(',', '.'));
                            result = 0.0f;
                            result_str = "";
                            if (p2_val == 0.0f) {
                                result_str = "NaN";
                            } else {
                                result = p1_val / p2_val;
                                result_str = nformat.format(result);
                            }
                            this.table.setValueAt(result_str, p3[i].x, p3[i].y);
                        }
                        continue block10;
                    }
                    case 5: {
                        float p1_val;
                        int i;
                        float result = 0.0f;
                        for (i = 0; i < p1.length; ++i) {
                            p1_val = Float.parseFloat(((String)this.table.getValueAt(p1[i].x, p1[i].y)).replace(',', '.'));
                            result += p1_val;
                        }
                        this.table.setValueAt(nformat.format(result), p3[0].x, p3[0].y);
                        break;
                    }
                    case 6: {
                        float p1_val;
                        int i;
                        float result = 0.0f;
                        for (i = 0; i < p1.length; ++i) {
                            p1_val = Float.parseFloat(((String)this.table.getValueAt(p1[i].x, p1[i].y)).replace(',', '.'));
                            result += p1_val;
                        }
                        this.table.setValueAt(nformat.format(result /= (float)p1.length), p3[0].x, p3[0].y);
                    }
                }
                continue;
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        this.disabled = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void registerFunction() {
        block20: {
            Function f;
            String name;
            Point[] p3;
            Point[] p2;
            Point[] p1;
            FunctionType sel_func;
            block21: {
                block22: {
                    sel_func = (FunctionType)this.func.getSelectedItem();
                    if (sel_func.type != 1 && sel_func.type != 2 && sel_func.type != 3 && sel_func.type != 4) break block21;
                    if (this.source1_sel.size() <= 1 || this.source2_sel.size() <= 1) break block22;
                    if (this.source1_sel.size() != this.source2_sel.size()) {
                        JOptionPane.showMessageDialog(this, "\u0397 \u03b5\u03c0\u03b9\u03bb\u03bf\u03b3\u03ae \u03c4\u03c9\u03bd \u03ba\u03b5\u03bb\u03b9\u03ce\u03bd \u03c0\u03c1\u03bf\u03bf\u03c1\u03b9\u03c3\u03bc\u03bf\u03cd \u03b4\u03b5\u03bd \u03b5\u03af\u03bd\u03b1\u03b9 \u03c3\u03c9\u03c3\u03c4\u03ae", "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1", 0);
                        return;
                    }
                    if (this.target_sel.size() != this.source1_sel.size()) {
                        JOptionPane.showMessageDialog(this, "\u0397 \u03b5\u03c0\u03b9\u03bb\u03bf\u03b3\u03ae \u03c4\u03bf\u03c5 \u03ba\u03b5\u03bb\u03b9\u03bf\u03cd \u03c0\u03c1\u03bf\u03bf\u03c1\u03b9\u03c3\u03bc\u03bf\u03cd \u03b4\u03b5\u03bd \u03b5\u03af\u03bd\u03b1\u03b9 \u03c3\u03c9\u03c3\u03c4\u03ae", "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1", 0);
                        return;
                    }
                    p1 = new Point[this.source1_sel.size()];
                    p2 = new Point[this.source2_sel.size()];
                    p3 = new Point[this.target_sel.size()];
                    for (int i = 0; i < this.source1_sel.size(); ++i) {
                        p1[i] = (Point)this.source1_sel.get(i);
                        p2[i] = (Point)this.source2_sel.get(i);
                        p3[i] = (Point)this.target_sel.get(i);
                    }
                    name = this.function_name.getText().trim();
                    if (name.length() == 0) {
                        name = this.field_1.getText() + " " + this.func.getSelectedItem().toString() + " " + this.field_2.getText() + " = " + this.field_3.getText();
                    }
                    f = new Function(sel_func.type, name, p1, p2, p3);
                    this.functions.add(f);
                    break block20;
                }
                if (this.source1_sel.size() > 1 && this.source2_sel.size() == 1) {
                    if (this.target_sel.size() != this.source1_sel.size()) {
                        JOptionPane.showMessageDialog(this, "\u0397 \u03b5\u03c0\u03b9\u03bb\u03bf\u03b3\u03ae \u03c4\u03c9\u03bd \u03ba\u03b5\u03bb\u03b9\u03ce\u03bd \u03c0\u03c1\u03bf\u03bf\u03c1\u03b9\u03c3\u03bc\u03bf\u03cd \u03b4\u03b5\u03bd \u03b5\u03af\u03bd\u03b1\u03b9 \u03c3\u03c9\u03c3\u03c4\u03ae", "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1", 0);
                        return;
                    }
                    p1 = new Point[this.source1_sel.size()];
                    p2 = new Point[this.source2_sel.size()];
                    p3 = new Point[this.target_sel.size()];
                    for (int i = 0; i < this.source1_sel.size(); ++i) {
                        p1[i] = (Point)this.source1_sel.get(i);
                        p2[0] = (Point)this.source2_sel.get(0);
                        p3[i] = (Point)this.target_sel.get(i);
                    }
                    name = this.function_name.getText().trim();
                    if (name.length() == 0) {
                        name = this.field_1.getText() + " " + this.func.getSelectedItem().toString() + " " + this.field_2.getText() + " = " + this.field_3.getText();
                    }
                    f = new Function(sel_func.type, name, p1, p2, p3);
                    this.functions.add(f);
                    break block20;
                } else if (this.source1_sel.size() == 1 && this.source2_sel.size() == 1 && this.target_sel.size() == 1) {
                    p1 = new Point[this.source1_sel.size()];
                    p2 = new Point[this.source2_sel.size()];
                    p3 = new Point[this.target_sel.size()];
                    for (int i = 0; i < this.source1_sel.size(); ++i) {
                        p1[i] = (Point)this.source1_sel.get(i);
                        p2[i] = (Point)this.source2_sel.get(i);
                        p3[i] = (Point)this.target_sel.get(i);
                    }
                    name = this.function_name.getText().trim();
                    if (name.length() == 0) {
                        name = this.field_1.getText() + " " + this.func.getSelectedItem().toString() + " " + this.field_2.getText() + " = " + this.field_3.getText();
                    }
                    f = new Function(sel_func.type, name, p1, p2, p3);
                    this.functions.add(f);
                    break block20;
                } else {
                    JOptionPane.showMessageDialog(this, "\u0397 \u03b5\u03c0\u03b9\u03bb\u03bf\u03b3\u03ae \u03c4\u03c9\u03bd \u03ba\u03b5\u03bb\u03b9\u03ce\u03bd \u03c0\u03c1\u03bf\u03bf\u03c1\u03b9\u03c3\u03bc\u03bf\u03cd \u03b4\u03b5\u03bd \u03b5\u03af\u03bd\u03b1\u03b9 \u03c3\u03c9\u03c3\u03c4\u03ae", "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1", 0);
                    return;
                }
            }
            if (sel_func.type == 5 || sel_func.type == 6) {
                if (this.target_sel.size() != 1) {
                    JOptionPane.showMessageDialog(this, "\u03a4\u03bf \u03ba\u03b5\u03bb\u03af \u03c0\u03c1\u03bf\u03bf\u03c1\u03b9\u03c3\u03bc\u03bf\u03cd \u03c0\u03c1\u03ad\u03c0\u03b5\u03b9 \u03bd\u03b1 \u03b5\u03af\u03bd\u03b1\u03b9 \u03ad\u03bd\u03b1.", "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1", 0);
                    return;
                }
                p1 = new Point[this.source1_sel.size()];
                p2 = new Point[1];
                p3 = new Point[this.target_sel.size()];
                p3[0] = (Point)this.target_sel.get(0);
                for (int i = 0; i < this.source1_sel.size(); ++i) {
                    p1[i] = (Point)this.source1_sel.get(i);
                    p2[0] = new Point(0, 0);
                }
                name = this.function_name.getText().trim();
                if (name.length() == 0) {
                    name = this.field_1.getText() + " " + this.func.getSelectedItem().toString() + " " + this.field_2.getText() + " = " + this.field_3.getText();
                }
                f = new Function(sel_func.type, name, p1, p2, p3);
                this.functions.add(f);
            }
        }
        int i = 0;
        while (i < this.table.getRowCount()) {
            for (int j = 0; j < this.table.getColumnCount(); ++j) {
                this.checkFunctions();
            }
            ++i;
        }
        return;
    }

    private Vector getXYData() {
        int[] x = this.table.getSelectedRows();
        int[] y = this.table.getSelectedColumns();
        if (y.length > 2) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        Hashtable<String, String> h = new Hashtable<String, String>();
        for (int i = 0; i < x.length; ++i) {
            try {
                double d1 = Double.parseDouble(((String)this.table.getValueAt(x[i], y[0])).replace(',', '.'));
                double d2 = Double.parseDouble(((String)this.table.getValueAt(x[i], y[1])).replace(',', '.'));
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (h.get(((String)this.table.getValueAt(x[i], y[0])).replace(',', '.')) != null) {
                return null;
            }
            h.put(((String)this.table.getValueAt(x[i], y[0])).replace(',', '.'), ((String)this.table.getValueAt(x[i], y[0])).replace(',', '.'));
            v.add(((String)this.table.getValueAt(x[i], y[0])).replace(',', '.'));
            v.add(((String)this.table.getValueAt(x[i], y[1])).replace(',', '.'));
        }
        return v;
    }

    private Vector getBarData() {
        int[] x = this.table.getSelectedRows();
        int[] y = this.table.getSelectedColumns();
        if (y.length > 2) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < x.length; ++i) {
            try {
                double d = Double.parseDouble(((String)this.table.getValueAt(x[i], y[1])).replace(',', '.'));
            }
            catch (NumberFormatException e) {
                return null;
            }
            v.add(((String)this.table.getValueAt(x[i], y[0])).replace(',', '.'));
            v.add(((String)this.table.getValueAt(x[i], y[1])).replace(',', '.'));
        }
        return v;
    }

    private Vector getIconBarData() {
        int[] x = this.table.getSelectedRows();
        int[] y = this.table.getSelectedColumns();
        if (y.length > 2) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < x.length; ++i) {
            try {
                int d = Integer.parseInt(((String)this.table.getValueAt(x[i], y[1])).replace(',', '.'));
            }
            catch (NumberFormatException e) {
                return null;
            }
            v.add(((String)this.table.getValueAt(x[i], y[0])).replace(',', '.'));
            v.add(((String)this.table.getValueAt(x[i], y[1])).replace(',', '.'));
        }
        return v;
    }

    public void sortTable(int col_id, boolean isAsc) {
        int[] x = this.table.getSelectedRows();
        int[] y = this.table.getSelectedColumns();
        boolean pos_e = false;
        for (int i = 0; i < x.length; ++i) {
            for (int j = i; j < x.length; ++j) {
                String e1 = ((String)this.table.getValueAt(x[i], col_id)).replace(',', '.');
                String e2 = ((String)this.table.getValueAt(x[j], col_id)).replace(',', '.');
                if (e1.trim().length() == 0 && e2.trim().length() > 0) {
                    this.swap(x, y, i, x[j], col_id);
                    continue;
                }
                if (!(this.compare(e1, e2) == 1 && isAsc || this.compare(e1, e2) == -1 && !isAsc) && this.compare(e1, e2) != 0) continue;
                this.swap(x, y, i, x[j], col_id);
            }
        }
    }

    private void swap(int[] x, int[] y, int i, int e, int col_id) {
        int k;
        Vector<Object> v = new Vector<Object>();
        for (k = 0; k < y.length; ++k) {
            v.add(this.table.getValueAt(x[i], y[k]));
        }
        for (k = 0; k < y.length; ++k) {
            this.table.setValueAt(this.table.getValueAt(e, y[k]), x[i], y[k]);
        }
        for (k = 0; k < y.length; ++k) {
            this.table.setValueAt((String)v.get(k), e, y[k]);
        }
    }

    private int compare(String s1, String s2) {
        try {
            double d1 = Double.parseDouble(s1);
            double d2 = Double.parseDouble(s2);
            if (d1 > d2) {
                return 1;
            }
            if (d1 == d2) {
                return 0;
            }
            return -1;
        }
        catch (NumberFormatException numberFormatException) {
            if (s1.compareTo(s2) > 0) {
                return 1;
            }
            if (s1.compareTo(s2) == 0) {
                return 0;
            }
            return -1;
        }
    }

    public void plot(int type) {
        PlotFrame plotFrame;
        Vector v;
        if (type == 1) {
            v = this.getBarData();
            if (v == null) {
                JOptionPane.showMessageDialog(this, "\u03a4\u03b1 \u03b4\u03b5\u03b4\u03bf\u03bc\u03ad\u03bd\u03b1 \u03c0\u03bf\u03c5 \u03b5\u03c0\u03b9\u03bb\u03ad\u03be\u03b1\u03c4\u03b5 \u03b4\u03b5\u03bd \u03b5\u03af\u03bd\u03b1\u03b9 \u03c3\u03c9\u03c3\u03c4\u03ac.", "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1", 0);
                return;
            }
            plotFrame = new PlotFrame(1, v);
        }
        if (type == 2) {
            v = this.getXYData();
            if (v == null) {
                JOptionPane.showMessageDialog(this, "\u03a4\u03b1 \u03b4\u03b5\u03b4\u03bf\u03bc\u03ad\u03bd\u03b1 \u03c0\u03bf\u03c5 \u03b5\u03c0\u03b9\u03bb\u03ad\u03be\u03b1\u03c4\u03b5 \u03b4\u03b5\u03bd \u03b5\u03af\u03bd\u03b1\u03b9 \u03c3\u03c9\u03c3\u03c4\u03ac.", "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1", 0);
                return;
            }
            plotFrame = new PlotFrame(2, v);
        }
        if (type == 3) {
            v = this.getIconBarData();
            if (v == null) {
                JOptionPane.showMessageDialog(this, "\u03a4\u03b1 \u03b4\u03b5\u03b4\u03bf\u03bc\u03ad\u03bd\u03b1 \u03c0\u03bf\u03c5 \u03b5\u03c0\u03b9\u03bb\u03ad\u03be\u03b1\u03c4\u03b5 \u03b4\u03b5\u03bd \u03b5\u03af\u03bd\u03b1\u03b9 \u03c3\u03c9\u03c3\u03c4\u03ac.", "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1", 0);
                return;
            }
            IconBarWindow iconBarWindow = new IconBarWindow(this.parent, v, this.iconPlotImages);
        }
    }

    public void sort() {
        int[] x = this.table.getSelectedRows();
        int[] y = this.table.getSelectedColumns();
        if (x.length == 0 && y.length == 0) {
            JOptionPane.showMessageDialog(this, "\u03a0\u03c1\u03ad\u03c0\u03b5\u03b9 \u03bd\u03b1 \u03b5\u03c0\u03b9\u03bb\u03ad\u03be\u03b5\u03c4\u03b5 \u03bc\u03b9\u03b1 \u03c0\u03b5\u03c1\u03b9\u03bf\u03c7\u03ae \u03c4\u03bf\u03c5 \u03c0\u03af\u03bd\u03b1\u03ba\u03b1.", "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1", 0);
        }
        int[] col_id = new int[y.length];
        String[] col_names = new String[y.length];
        for (int i = 0; i < y.length; ++i) {
            col_id[i] = y[i];
            col_names[i] = this.table.getColumnName(y[i]);
        }
        SortDialog sortDlg = new SortDialog(this, col_names, col_id);
    }

    public void clear() {
        this.data_counter = 0;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            for (int j = 1; j < this.table.getColumnCount(); ++j) {
                this.table.setValueAt(new String(), i, j);
            }
        }
        this.table.clearSelection();
    }

    public void checkTableSelection() {
        if (this.selectedRow >= 0 && this.selectedCol >= 0) {
            boolean found = false;
            for (int i = 0; i < this.functions.size(); ++i) {
                Function f = (Function)this.functions.get(i);
                Point[] targets = f.target;
                for (int j = 0; j < targets.length; ++j) {
                    if (targets[j].x != this.selectedRow || targets[j].y != this.selectedCol) continue;
                    this.selectedFunction = j;
                    this.status.setText("\u039a\u03b1\u03c4\u03b1\u03c7\u03c9\u03c1\u03b9\u03c3\u03bc\u03ad\u03bd\u03b7 \u03c3\u03c5\u03bd\u03ac\u03c1\u03c4\u03b7\u03c3\u03b7: " + f.name);
                    found = true;
                }
            }
            if (!found) {
                this.selectedFunction = -1;
                this.status.setText("\u0394\u03b5\u03bd \u03c5\u03c0\u03ac\u03c1\u03c7\u03b5\u03b9 \u03ba\u03b1\u03c4\u03b1\u03c7\u03c9\u03c1\u03b9\u03c3\u03bc\u03ad\u03bd\u03b7 \u03c3\u03c5\u03bd\u03ac\u03c1\u03c4\u03b7\u03c3\u03b7.");
            }
        }
    }

    public void clearFunction(int row, int col) {
        this.data_counter = 1;
        for (int i = 0; i < this.functions.size(); ++i) {
            Function f = (Function)this.functions.get(i);
            Point[] targets = f.target;
            for (int j = 0; j < targets.length; ++j) {
                if (targets[j].x != row || targets[j].y != col) continue;
                this.functions.remove(i);
                this.checkFunctions();
            }
        }
    }

    public void PasteFromClipboard() {
        Transferable clipboardContent = this.clipboard.getContents(this);
        if (clipboardContent != null && clipboardContent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String clipboardData = "";
                clipboardData = (String)clipboardContent.getTransferData(DataFlavor.stringFlavor);
                clipboardData.replace('\r', ' ');
                StringTokenizer stoken = new StringTokenizer(clipboardData, "\n");
                if (this.table.getSelectedRowCount() < stoken.countTokens()) {
                    JOptionPane.showMessageDialog(this, "\u03a0\u03c1\u03ad\u03c0\u03b5\u03b9 \u03bd\u03b1 \u03b5\u03c0\u03b9\u03bb\u03ad\u03be\u03b5\u03c4\u03b5 \u03bc\u03b5\u03b3\u03b1\u03bb\u03cd\u03c4\u03b5\u03c1\u03b7 \u03c0\u03b5\u03c1\u03b9\u03bf\u03c7\u03ae \u03c3\u03c4\u03bf\u03bd \u03c0\u03af\u03bd\u03b1\u03ba\u03b1.", "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1", 0);
                    return;
                }
                while (stoken.hasMoreTokens()) {
                    String line = stoken.nextToken();
                    StringTokenizer stoken2 = new StringTokenizer(line, " \t");
                    if (this.table.getSelectedColumnCount() >= stoken2.countTokens()) continue;
                    JOptionPane.showMessageDialog(this, "\u03a0\u03c1\u03ad\u03c0\u03b5\u03b9 \u03bd\u03b1 \u03b5\u03c0\u03b9\u03bb\u03ad\u03be\u03b5\u03c4\u03b5 \u03bc\u03b5\u03b3\u03b1\u03bb\u03cd\u03c4\u03b5\u03c1\u03b7 \u03c0\u03b5\u03c1\u03b9\u03bf\u03c7\u03ae \u03c3\u03c4\u03bf\u03bd \u03c0\u03af\u03bd\u03b1\u03ba\u03b1.", "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1", 0);
                    return;
                }
                stoken = new StringTokenizer(clipboardData, "\n");
                int minX = this.table.getSelectedRows()[0];
                int minY = this.table.getSelectedColumns()[0];
                while (stoken.hasMoreTokens()) {
                    String line = stoken.nextToken();
                    StringTokenizer stoken2 = new StringTokenizer(line, " \t");
                    while (stoken2.hasMoreTokens()) {
                        String str = stoken2.nextToken();
                        this.clearFunction(minX, minY);
                        this.table.setValueAt(str, minX, minY++);
                    }
                    minY = this.table.getSelectedColumns()[0];
                    ++minX;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void CopyToClipboard() {
        String clipboardData = "";
        int[] x = this.table.getSelectedRows();
        int[] y = this.table.getSelectedColumns();
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < y.length; ++j) {
                clipboardData = clipboardData + this.table.getValueAt(x[i], y[j]) + " ";
            }
            clipboardData = clipboardData + "\n";
        }
        StringSelection cdata = new StringSelection(clipboardData);
        this.clipboard.setContents(cdata, this);
    }

    public void CutToClipboard() {
        this.CopyToClipboard();
        this.DeleteTable();
    }

    public void DeleteTable() {
        int[] x = this.table.getSelectedRows();
        int[] y = this.table.getSelectedColumns();
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < y.length; ++j) {
                this.clearFunction(x[i], y[j]);
                this.table.setValueAt(" ", x[i], y[j]);
            }
        }
    }

    private void saveFile(File file) {
        int i;
        String data = "";
        data = data + "***TABLE_START***\n";
        for (i = 0; i < this.table.getRowCount(); ++i) {
            data = data + i + "\t";
            for (int j = 0; j < this.table.getColumnCount(); ++j) {
                String cell = this.table.getValueAt(i, j).toString();
                cell = cell.replace('\t', ' ').trim();
                cell = cell.replace('\n', ' ').trim();
                cell = cell.replace('\r', ' ').trim();
                data = data + cell + " \t";
            }
            data = data + "\n";
        }
        data = data + "***TABLE_END***\n";
        data = data + "***FUNCTION_START***";
        data = data + "\n";
        for (i = 0; i < this.functions.size(); ++i) {
            int j;
            Function f = (Function)this.functions.get(i);
            String name = f.name;
            name = name.replace('\t', ' ').trim();
            name = name.replace('\n', ' ').trim();
            name = name.replace('\r', ' ').trim();
            data = data + name + "\n";
            data = data + f.func_type + "\n";
            Point[] source1 = f.source1;
            Point[] source2 = f.source2;
            Point[] target = f.target;
            for (j = 0; j < source1.length; ++j) {
                data = data + source1[j].x + "," + source1[j].y + " ";
            }
            data = data + "\n";
            for (j = 0; j < source2.length; ++j) {
                data = data + source2[j].x + "," + source2[j].y + " ";
            }
            data = data + "\n";
            for (j = 0; j < target.length; ++j) {
                data = data + target[j].x + "," + target[j].y + " ";
            }
            data = data + "\n";
        }
        data = data + "***FUNCTION_END***";
        try {
            FileWriter out = new FileWriter(file);
            out.write(data);
            out.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1 \u03ba\u03b1\u03c4\u03ac \u03c4\u03b7\u03bd \u03b5\u03b3\u03b3\u03c1\u03b1\u03c6\u03ae \u03c4\u03bf\u03c5 \u03b1\u03c1\u03c7\u03b5\u03af\u03bf\u03c5:\n" + file.getName(), "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1", 0);
        }
    }

    private void openFile(File file) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = "";
            boolean loadTable = false;
            boolean loadFunctions = false;
            while ((line = in.readLine()) != null) {
                if (line.equals("***TABLE_START***")) {
                    loadTable = true;
                    continue;
                }
                if (line.equals("***TABLE_END***")) {
                    loadTable = false;
                    continue;
                }
                if (line.equals("***FUNCTION_START***")) {
                    loadFunctions = true;
                    continue;
                }
                if (line.equals("***FUNCTION_END***")) {
                    loadFunctions = false;
                    continue;
                }
                if (loadTable && !loadFunctions) {
                    StringTokenizer stoken = new StringTokenizer(line, "\t");
                    int row = Integer.parseInt(stoken.nextToken().trim());
                    int col = 0;
                    while (stoken.hasMoreTokens()) {
                        String token = stoken.nextToken().trim();
                        this.table.setValueAt(token, row, col);
                        ++col;
                    }
                }
                if (!loadTable && loadFunctions) {
                    String name = line.trim();
                    int type = Integer.parseInt(in.readLine().trim());
                    String source1_str = in.readLine();
                    StringTokenizer stoken = new StringTokenizer(source1_str, " ");
                    Point[] source1 = new Point[stoken.countTokens()];
                    int pos = 0;
                    while (stoken.hasMoreTokens()) {
                        String point = stoken.nextToken();
                        StringTokenizer stoken2 = new StringTokenizer(point, ",");
                        int x = Integer.parseInt(stoken2.nextToken());
                        int y = Integer.parseInt(stoken2.nextToken());
                        source1[pos++] = new Point(x, y);
                    }
                    String source2_str = in.readLine();
                    stoken = new StringTokenizer(source2_str, " ");
                    Point[] source2 = new Point[stoken.countTokens()];
                    pos = 0;
                    while (stoken.hasMoreTokens()) {
                        String point = stoken.nextToken();
                        StringTokenizer stoken2 = new StringTokenizer(point, ",");
                        int x = Integer.parseInt(stoken2.nextToken());
                        int y = Integer.parseInt(stoken2.nextToken());
                        source2[pos++] = new Point(x, y);
                    }
                    String target_str = in.readLine();
                    stoken = new StringTokenizer(target_str, " ");
                    Point[] target = new Point[stoken.countTokens()];
                    pos = 0;
                    while (stoken.hasMoreTokens()) {
                        String point = stoken.nextToken();
                        StringTokenizer stoken2 = new StringTokenizer(point, ",");
                        int x = Integer.parseInt(stoken2.nextToken());
                        int y = Integer.parseInt(stoken2.nextToken());
                        target[pos++] = new Point(x, y);
                    }
                    this.functions.add(new Function(type, name, source1, source2, target));
                }
                this.checkFunctions();
            }
            in.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1 \u03ba\u03b1\u03c4\u03ac \u03c4\u03bf \u03ac\u03bd\u03bf\u03b9\u03b3\u03bc\u03b1 \u03c4\u03bf\u03c5 \u03b1\u03c1\u03c7\u03b5\u03af\u03bf\u03c5:\n" + file.getName(), "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1", 0);
        }
    }

    public void loadImages(Vector images) {
        this.iconPlotImages = images;
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.status = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel4 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton11 = new JButton();
        this.jButton12 = new JButton();
        this.jButton9 = new JButton();
        this.jButton8 = new JButton();
        this.jButton6 = new JButton();
        this.jButton2 = new JButton();
        this.jButton7 = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.function_name = new JTextField();
        this.jLabel6 = new JLabel();
        this.field_1 = new JButton();
        this.func = new JComboBox();
        this.field_2 = new JButton();
        this.jLabel2 = new JLabel();
        this.field_3 = new JButton();
        this.jLabel3 = new JLabel();
        this.insertFunction = new JButton();
        this.jButton5 = new JButton();
        this.jPanel1 = new JPanel();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton10 = new JButton();
        this.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new FlowLayout(0));
        this.jPanel3.setBorder(new EtchedBorder());
        this.status.setText(" ");
        this.status.setMaximumSize(new Dimension(500, 16));
        this.status.setMinimumSize(new Dimension(500, 16));
        this.status.setPreferredSize(new Dimension(500, 16));
        this.jPanel3.add(this.status);
        this.add((Component)this.jPanel3, "South");
        this.jPanel4.setLayout(new FlowLayout(0));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/new.gif")));
        this.jButton1.setToolTipText("\u039d\u03ad\u03bf (\u039a\u03b1\u03b8\u03b1\u03c1\u03b9\u03c3\u03bc\u03cc\u03c2)");
        this.jButton1.setMargin(new Insets(2, 4, 2, 4));
        this.jButton1.setPreferredSize(new Dimension(32, 29));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpreadSheet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton1);
        this.jButton11.setIcon(new ImageIcon(this.getClass().getResource("/open.gif")));
        this.jButton11.setToolTipText("\u0386\u03bd\u03bf\u03b9\u03b3\u03bc\u03b1");
        this.jButton11.setMargin(new Insets(2, 4, 2, 4));
        this.jButton11.setPreferredSize(new Dimension(32, 29));
        this.jButton11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpreadSheet.this.jButton11ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton11);
        this.jButton12.setIcon(new ImageIcon(this.getClass().getResource("/save.gif")));
        this.jButton12.setToolTipText("\u0391\u03c0\u03bf\u03b8\u03ae\u03ba\u03b5\u03c5\u03c3\u03b7");
        this.jButton12.setMargin(new Insets(2, 4, 2, 4));
        this.jButton12.setPreferredSize(new Dimension(32, 29));
        this.jButton12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpreadSheet.this.jButton12ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton12);
        this.jButton9.setIcon(new ImageIcon(this.getClass().getResource("/cut.gif")));
        this.jButton9.setToolTipText("\u039a\u03cc\u03c8\u03b9\u03bc\u03bf (Control-X)");
        this.jButton9.setMargin(new Insets(2, 4, 2, 4));
        this.jButton9.setPreferredSize(new Dimension(32, 29));
        this.jButton9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpreadSheet.this.jButton9ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton9);
        this.jButton8.setIcon(new ImageIcon(this.getClass().getResource("/copy.gif")));
        this.jButton8.setToolTipText("\u0391\u03bd\u03c4\u03b9\u03b3\u03c1\u03b1\u03c6\u03ae (Control-C)");
        this.jButton8.setMargin(new Insets(2, 4, 2, 4));
        this.jButton8.setPreferredSize(new Dimension(32, 29));
        this.jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpreadSheet.this.jButton8ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton8);
        this.jButton6.setIcon(new ImageIcon(this.getClass().getResource("/paste.gif")));
        this.jButton6.setToolTipText("\u0395\u03c0\u03b9\u03ba\u03cc\u03bb\u03bb\u03b7\u03c3\u03b7 (Control-V)");
        this.jButton6.setMargin(new Insets(2, 4, 2, 4));
        this.jButton6.setPreferredSize(new Dimension(32, 29));
        this.jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpreadSheet.this.jButton6ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton6);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/sort.gif")));
        this.jButton2.setToolTipText("\u03a4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7");
        this.jButton2.setBorder(null);
        this.jButton2.setPreferredSize(new Dimension(100, 29));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpreadSheet.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton2);
        this.jButton7.setIcon(new ImageIcon(this.getClass().getResource("/delete.gif")));
        this.jButton7.setToolTipText("\u0394\u03b9\u03b1\u03b3\u03c1\u03b1\u03c6\u03ae");
        this.jButton7.setBorder(null);
        this.jButton7.setPreferredSize(new Dimension(90, 29));
        this.jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpreadSheet.this.jButton7ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton7);
        this.jTabbedPane1.addTab("\u0395\u03c0\u03b9\u03bb\u03bf\u03b3\u03ad\u03c2", this.jPanel4);
        this.jPanel2.setLayout(new FlowLayout(0));
        this.jLabel1.setText("\u03a4\u03af\u03c4\u03bb\u03bf\u03c2:");
        this.jPanel2.add(this.jLabel1);
        this.function_name.setColumns(8);
        this.jPanel2.add(this.function_name);
        this.jLabel6.setText("     ");
        this.jPanel2.add(this.jLabel6);
        this.field_1.setMargin(new Insets(2, 2, 2, 2));
        this.field_1.setPreferredSize(new Dimension(60, 26));
        this.field_1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpreadSheet.this.field_1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.field_1);
        this.jPanel2.add(this.func);
        this.field_2.setMargin(new Insets(2, 2, 2, 2));
        this.field_2.setPreferredSize(new Dimension(60, 26));
        this.field_2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpreadSheet.this.field_2ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.field_2);
        this.jLabel2.setText("   >   ");
        this.jPanel2.add(this.jLabel2);
        this.field_3.setMargin(new Insets(2, 2, 2, 2));
        this.field_3.setPreferredSize(new Dimension(60, 26));
        this.field_3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpreadSheet.this.field_3ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.field_3);
        this.jLabel3.setText("     ");
        this.jPanel2.add(this.jLabel3);
        this.insertFunction.setBackground(new Color(204, 204, 204));
        this.insertFunction.setIcon(new ImageIcon(this.getClass().getResource("/insert_func.gif")));
        this.insertFunction.setToolTipText("\u0395\u03b9\u03c3\u03b1\u03b3\u03c9\u03b3\u03ae \u03c3\u03c5\u03bd\u03ac\u03c1\u03c4\u03b7\u03c3\u03b7\u03c2");
        this.insertFunction.setBorder(null);
        this.insertFunction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpreadSheet.this.insertFunctionActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.insertFunction);
        this.jButton5.setBackground(new Color(204, 204, 204));
        this.jButton5.setIcon(new ImageIcon(this.getClass().getResource("/delete_func.gif")));
        this.jButton5.setToolTipText("\u0394\u03b9\u03b1\u03b3\u03c1\u03b1\u03c6\u03ae \u03c3\u03c5\u03bd\u03ac\u03c1\u03c4\u03b7\u03c3\u03b7\u03c2");
        this.jButton5.setBorder(null);
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpreadSheet.this.jButton5ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton5);
        this.jTabbedPane1.addTab("\u0395\u03b9\u03c3\u03b1\u03b3\u03c9\u03b3\u03ae \u03c3\u03c5\u03bd\u03ac\u03c1\u03c4\u03b7\u03c3\u03b7\u03c2", this.jPanel2);
        this.jPanel1.setLayout(new FlowLayout(0));
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/bar_graph.gif")));
        this.jButton3.setToolTipText("\u03a1\u03b1\u03b2\u03b4\u03cc\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1");
        this.jButton3.setBorder(null);
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpreadSheet.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton3);
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/xy_graph.gif")));
        this.jButton4.setToolTipText("\u03a7\u03a5 \u0393\u03c1\u03ac\u03c6\u03b7\u03bc\u03b1");
        this.jButton4.setBorder(null);
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpreadSheet.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton4);
        this.jButton10.setIcon(new ImageIcon(this.getClass().getResource("/icon_graph.gif")));
        this.jButton10.setToolTipText("\u0395\u03b9\u03ba\u03bf\u03bd\u03bf\u03b3\u03c1\u03ac\u03c6\u03b7\u03bc\u03b1");
        this.jButton10.setBorder(null);
        this.jButton10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpreadSheet.this.jButton10ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton10);
        this.jTabbedPane1.addTab("\u0394\u03b7\u03bc\u03b9\u03bf\u03c5\u03c1\u03b3\u03af\u03b1 \u03b3\u03c1\u03b1\u03c6\u03ae\u03bc\u03b1\u03c4\u03bf\u03c2", this.jPanel1);
        this.add((Component)this.jTabbedPane1, "North");
    }

    private void jButton12ActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.getName().endsWith(".stat")) {
                    return true;
                }
                return file.isDirectory();
            }

            public String getDescription() {
                return "\u0391\u03c1\u03c7\u03b5\u03af\u03b1 stat";
            }
        });
        fc.setFileSelectionMode(2);
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            if (fc.getSelectedFile().getName().endsWith(".stat")) {
                this.saveFile(fc.getSelectedFile());
            } else {
                this.saveFile(new File(fc.getSelectedFile().getAbsolutePath() + ".stat"));
            }
            return;
        }
    }

    private void jButton11ActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.getName().endsWith(".stat")) {
                    return true;
                }
                return file.isDirectory();
            }

            public String getDescription() {
                return "\u0391\u03c1\u03c7\u03b5\u03af\u03b1 stat";
            }
        });
        fc.setFileSelectionMode(2);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.openFile(file);
            return;
        }
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        this.plot(3);
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        this.CopyToClipboard();
        this.DeleteTable();
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        this.CopyToClipboard();
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        this.DeleteTable();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.PasteFromClipboard();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        if (this.selectedFunction >= 0) {
            Function f = (Function)this.functions.remove(this.selectedFunction);
            Point[] targets = f.target;
            for (int i = 0; i < targets.length; ++i) {
                this.table.setValueAt("", targets[i].x, targets[i].y);
            }
            this.checkFunctions();
        }
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.plot(2);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.plot(1);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.sort();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.clear();
    }

    private void field_3ActionPerformed(ActionEvent evt) {
        if (this.table.getSelectedColumnCount() == 0 && this.table.getSelectedRowCount() == 0) {
            return;
        }
        int[] sel_rows = this.table.getSelectedRows();
        int[] sel_cols = this.table.getSelectedColumns();
        this.target_sel.removeAllElements();
        for (int i = 0; i < sel_rows.length; ++i) {
            for (int j = 0; j < sel_cols.length; ++j) {
                this.target_sel.add(new Point(sel_rows[i], sel_cols[j]));
            }
        }
        String upper_left_corner = this.table.getColumnName(sel_cols[0]) + (sel_rows[0] + 1);
        String bottom_right_corner = this.table.getColumnName(sel_cols[sel_cols.length - 1]) + (sel_rows[sel_rows.length - 1] + 1);
        String label = "";
        label = upper_left_corner.equals(bottom_right_corner) ? upper_left_corner : upper_left_corner + ":" + bottom_right_corner;
        this.field_3.setText(label);
    }

    private void field_2ActionPerformed(ActionEvent evt) {
        if (this.table.getSelectedColumnCount() == 0 && this.table.getSelectedRowCount() == 0) {
            return;
        }
        int[] sel_rows = this.table.getSelectedRows();
        int[] sel_cols = this.table.getSelectedColumns();
        this.source2_sel.removeAllElements();
        for (int i = 0; i < sel_rows.length; ++i) {
            for (int j = 0; j < sel_cols.length; ++j) {
                this.source2_sel.add(new Point(sel_rows[i], sel_cols[j]));
            }
        }
        String upper_left_corner = this.table.getColumnName(sel_cols[0]) + (sel_rows[0] + 1);
        String bottom_right_corner = this.table.getColumnName(sel_cols[sel_cols.length - 1]) + (sel_rows[sel_rows.length - 1] + 1);
        String label = "";
        label = upper_left_corner.equals(bottom_right_corner) ? upper_left_corner : upper_left_corner + ":" + bottom_right_corner;
        this.field_2.setText(label);
    }

    private void field_1ActionPerformed(ActionEvent evt) {
        if (this.table.getSelectedColumnCount() == 0 && this.table.getSelectedRowCount() == 0) {
            return;
        }
        int[] sel_rows = this.table.getSelectedRows();
        int[] sel_cols = this.table.getSelectedColumns();
        this.source1_sel.removeAllElements();
        for (int i = 0; i < sel_rows.length; ++i) {
            for (int j = 0; j < sel_cols.length; ++j) {
                this.source1_sel.add(new Point(sel_rows[i], sel_cols[j]));
            }
        }
        String upper_left_corner = this.table.getColumnName(sel_cols[0]) + (sel_rows[0] + 1);
        String bottom_right_corner = this.table.getColumnName(sel_cols[sel_cols.length - 1]) + (sel_rows[sel_rows.length - 1] + 1);
        String label = "";
        label = upper_left_corner.equals(bottom_right_corner) ? upper_left_corner : upper_left_corner + ":" + bottom_right_corner;
        this.field_1.setText(label);
    }

    private void insertFunctionActionPerformed(ActionEvent evt) {
        this.registerFunction();
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        System.out.println("Lost Clipboard Ownership!");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class myTableRenderer
    extends JLabel
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBorder(hasFocus ? new LineBorder(Color.black, 1) : null);
            this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.setFont(table.getFont());
            this.setText(value.toString());
            this.setOpaque(true);
            this.setHorizontalAlignment(4);
            return this;
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        SpreadSheet parent;
        final String[] columnNames = new String[]{" ", "\u0391", "\u0392", "\u0393", "\u0394", "\u0395", "\u03a3\u03a4"};
        final Object[][] data = new Object[][]{{new Integer(1), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(2), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(3), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(4), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(5), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(6), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(7), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(8), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(9), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(10), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(11), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(12), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(13), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(14), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(15), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(16), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(17), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(18), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(19), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(20), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(21), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(22), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(23), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(24), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(25), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(26), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(27), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(28), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(29), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(30), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(31), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(32), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(33), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(34), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(35), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(36), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(37), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(38), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(39), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(40), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(41), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(42), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(43), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(44), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(45), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(46), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(47), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(48), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(49), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(50), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(51), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(52), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(53), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(54), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(55), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(56), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(57), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(58), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(59), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(60), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(61), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(62), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(63), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(64), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(65), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(66), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(67), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(68), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(69), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(70), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(71), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(72), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(73), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(74), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(75), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(76), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(77), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(78), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(79), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(80), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(81), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(82), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(83), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(84), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(85), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(86), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(87), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(88), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(89), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(90), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(91), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(92), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(93), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(94), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(95), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(96), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(97), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(98), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(99), new String(), new String(), new String(), new String(), new String(), new String()}, {new Integer(100), new String(), new String(), new String(), new String(), new String(), new String()}};

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col >= 1;
        }

        public void setValueAt(Object value, int row, int col) {
            if (this.data[0][col] instanceof Integer && !(value instanceof Integer)) {
                try {
                    this.data[row][col] = new Integer(value.toString());
                    this.fireTableCellUpdated(row, col);
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(SpreadSheet.this, "The \"" + this.getColumnName(col) + "\" column accepts only integer values.");
                }
            } else {
                this.data[row][col] = value;
                this.fireTableCellUpdated(row, col);
            }
            if (!SpreadSheet.this.disabled) {
                this.parent.checkFunctions();
            }
        }

        MyTableModel(SpreadSheet parent) {
            this.parent = parent;
        }
    }

    class FunctionType {
        String name;
        int type;

        FunctionType(int type, String name) {
            this.type = type;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    class Point {
        int x;
        int y;

        Point(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    class Function {
        String name;
        Point[] source1;
        Point[] source2;
        Point[] target;
        int func_type = 0;

        Function(int func_type, String name, Point[] source1, Point[] source2, Point[] target) {
            this.func_type = func_type;
            this.name = name;
            this.source1 = source1;
            this.source2 = source2;
            this.target = target;
        }
    }
}

