/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.data.CategoryDataset;

public class StandardCategoryItemLabelGenerator
implements CategoryItemLabelGenerator,
Cloneable,
Serializable {
    private NumberFormat numberFormat;
    private DateFormat dateFormat;
    private boolean showSeriesNameInToolTips;

    public StandardCategoryItemLabelGenerator() {
        this(NumberFormat.getInstance());
    }

    public StandardCategoryItemLabelGenerator(NumberFormat numberFormat) {
        this(numberFormat, true);
    }

    public StandardCategoryItemLabelGenerator(NumberFormat numberFormat, boolean bl) {
        this.numberFormat = numberFormat;
        this.dateFormat = null;
        this.showSeriesNameInToolTips = bl;
    }

    public StandardCategoryItemLabelGenerator(DateFormat dateFormat) {
        this(dateFormat, true);
    }

    public StandardCategoryItemLabelGenerator(DateFormat dateFormat, boolean bl) {
        this.numberFormat = null;
        this.dateFormat = dateFormat;
        this.showSeriesNameInToolTips = bl;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public String generateToolTip(CategoryDataset categoryDataset, int n, int n2) {
        String string = null;
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            Comparable comparable;
            if (this.showSeriesNameInToolTips && (comparable = categoryDataset.getRowKey(n)) != null) {
                string = comparable.toString() + ", ";
            }
            comparable = categoryDataset.getColumnKey(n2);
            String string2 = comparable.toString();
            String string3 = null;
            if (this.numberFormat != null) {
                string3 = this.numberFormat.format(number);
            } else if (this.dateFormat != null) {
                string3 = this.dateFormat.format(number);
            }
            string = string != null ? string + string2 + " = " + string3 : string2 + " = " + string3;
        }
        return string;
    }

    public String generateItemLabel(CategoryDataset categoryDataset, int n, int n2) {
        String string = null;
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            if (this.numberFormat != null) {
                string = this.numberFormat.format(number);
            } else if (this.dateFormat != null) {
                string = this.dateFormat.format(number);
            }
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof StandardCategoryItemLabelGenerator) {
            StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator = (StandardCategoryItemLabelGenerator)object;
            if (this.dateFormat != null) {
                return this.dateFormat.equals(standardCategoryItemLabelGenerator.dateFormat);
            }
            return this.numberFormat.equals(standardCategoryItemLabelGenerator.numberFormat);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator = (StandardCategoryItemLabelGenerator)super.clone();
        if (this.numberFormat != null) {
            standardCategoryItemLabelGenerator.numberFormat = (NumberFormat)this.numberFormat.clone();
        }
        if (this.dateFormat != null) {
            standardCategoryItemLabelGenerator.dateFormat = (DateFormat)this.dateFormat.clone();
        }
        return standardCategoryItemLabelGenerator;
    }
}

