/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import org.nfunk.jep.JEP;

public class PlayerPanel
extends JPanel
implements ActionListener {
    private PlayersContainer playersContainer;
    private int index;
    private JButton3D but;
    private JTextField tf;

    public PlayerPanel() {
        this.initComponents();
        this.tf.setEditable(false);
        this.tf.setEnabled(false);
        this.but.addActionListener(this);
    }

    public PlayerPanel(PlayersContainer playersContainer) {
        this();
        this.playersContainer = playersContainer;
    }

    public void setIndex(int n) {
        this.index = n;
        this.but.setIcon(new ImageIcon(this.getClass().getResource("/icons/Image" + n + ".gif")));
        this.but.setText("");
    }

    public int getIndex() {
        return this.index;
    }

    public void setActive(boolean bl) {
        this.tf.setEditable(bl);
    }

    public String getText() {
        return this.tf.getText();
    }

    public int getNumOfChars() {
        return this.tf.getText().length();
    }

    public void append(String string) {
        this.tf.setText(this.tf.getText() + string);
        this.tf.setCaretPosition(this.tf.getText().length());
    }

    public void backspace() {
        int n = this.getNumOfChars();
        if (n > 0) {
            this.tf.setText(this.tf.getText().substring(0, n - 1));
        }
        this.tf.setCaretPosition(this.getNumOfChars());
    }

    public boolean isCorrect(double d) {
        String string = this.getText();
        if (string.length() == 0) {
            return false;
        }
        if (this.isOperand(string.charAt(string.length() - 1))) {
            string = string.substring(0, string.length() - 1);
        }
        string = string.replaceAll("x", "*");
        string = string.replaceAll(":", "/");
        JEP jEP = new JEP();
        jEP.parseExpression(string);
        if (jEP.hasError()) {
            return false;
        }
        return jEP.getValue() == d;
    }

    private boolean isOperand(char c) {
        return c == '+' || c == '-' || c == 'x' || c == ':';
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.playersContainer.setActivePlayerPanel(this);
    }

    private void initComponents() {
        this.tf = new JTextField();
        this.but = new JButton3D();
        this.setLayout(new GridBagLayout());
        this.tf.setFont(new Font("Tahoma", 0, 18));
        this.tf.setBorder(new BevelBorder(1));
        this.tf.setDisabledTextColor(Color.black);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.tf, gridBagConstraints);
        this.but.setText("Nos");
        this.but.setFont(new Font("Tahoma", 1, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 15;
        this.add((Component)this.but, gridBagConstraints);
    }
}

