/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class SquareRoot
extends PostfixMathCommand {
    public SquareRoot() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e = stack.pop();
        stack.push(this.sqrt(e));
    }

    public Object sqrt(Object object) throws ParseException {
        if (object instanceof Double) {
            double d = (Double)object;
            if (d < 0.0) {
                return new Complex(d).sqrt();
            }
            return new Double(Math.sqrt(d));
        }
        if (object instanceof Complex) {
            return ((Complex)object).sqrt();
        }
        throw new ParseException("Invalid parameter type");
    }
}

