/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;

public class Lane
extends JPanel
implements ActionListener {
    public static final int MAX_MOVEMENTS = 48;
    private Timer timer;
    private int movement;
    private int movements;
    private JToggleButton speed2TB;
    private ButtonGroup speedBG;
    private JToggleButton speed3TB;
    private JToggleButton speed1TB;
    private ImagePanel laneP;
    private JLabel endL;
    private JLabel startL;
    private JToggleButton speed4TB;
    private JToggleButton speed5TB;

    public Lane() {
        this.initComponents();
        this.laneP.setLayout(null);
        this.laneP.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Lane.this.findMovement();
            }
        });
        this.laneP.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                Component component = Lane.this.laneP.getComponentAt(mouseEvent.getPoint());
                if (component != null && component instanceof Animal) {
                    Lane.this.laneP.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    Lane.this.laneP.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.speed1TB.setMnemonic(1);
        this.speed2TB.setMnemonic(2);
        this.speed3TB.setMnemonic(4);
        this.speed4TB.setMnemonic(8);
        this.speed5TB.setMnemonic(16);
        this.movements = 0;
        this.timer = new Timer(500, this);
        this.timer.setInitialDelay(0);
    }

    public JPanel getLanePanel() {
        return this.laneP;
    }

    public int getAnimalSpeed() {
        int n = this.speedBG.getSelection().getMnemonic();
        return ((Animal)this.laneP.getComponent(0)).getSpeed() * n;
    }

    public Animal getAnimal() {
        return this.laneP.getComponentCount() == 0 ? null : (Animal)this.laneP.getComponent(0);
    }

    public void setAnimal(Animal animal) {
        this.laneP.removeAll();
        this.laneP.add(animal);
        animal.setBounds(0, 1, 48, 48);
        this.laneP.revalidate();
        this.laneP.repaint();
        this.movements = 0;
        this.findMovement();
    }

    public void setCursor(Cursor cursor) {
        this.laneP.setCursor(cursor);
    }

    public float getSpeedModifier() {
        return (float)this.speedBG.getSelection().getMnemonic() / 4.0f;
    }

    private void findMovement() {
        this.movement = (int)((float)(this.laneP.getWidth() - 48) / 48.0f);
    }

    public boolean isEmpty() {
        return this.laneP.getComponentCount() == 0;
    }

    public void move(boolean bl, int n, int n2) {
        if (this.laneP.getComponentCount() == 0) {
            return;
        }
        Component component = this.laneP.getComponent(0);
        Point point = component.getLocation();
        if (!bl) {
            component.setBounds(point.x + this.movement, 1, 48, 48);
        } else {
            component.setBounds((this.laneP.getWidth() - 48) * n / n2, 1, 48, 48);
        }
    }

    public void putAnimalToTheEnd() {
        if (this.laneP.getComponentCount() == 0) {
            return;
        }
        Component component = this.laneP.getComponent(0);
        Point point = component.getLocation();
        component.setBounds(this.laneP.getWidth() - 50, 1, 48, 48);
        this.movements = 48;
    }

    public void putAnimalToTheStart() {
        if (this.laneP.getComponentCount() == 0) {
            return;
        }
        Component component = this.laneP.getComponent(0);
        Point point = component.getLocation();
        component.setBounds(0, 1, 48, 48);
        this.movements = 0;
    }

    public void start() {
        this.timer.setDelay(32000 / this.getAnimalSpeed());
        this.timer.restart();
    }

    public void stop() {
        this.timer.stop();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.movements >= 48) {
            this.timer.stop();
            this.firePropertyChange("finished", null, null);
            return;
        }
        this.move(false, 0, 0);
        ++this.movements;
    }

    private void initComponents() {
        this.speedBG = new ButtonGroup();
        this.startL = new JLabel();
        this.endL = new JLabel();
        this.laneP = new ImagePanel();
        this.speed1TB = new JToggleButton();
        this.speed2TB = new JToggleButton();
        this.speed3TB = new JToggleButton();
        this.speed4TB = new JToggleButton();
        this.speed5TB = new JToggleButton();
        this.setLayout(new GridBagLayout());
        this.startL.setFont(new Font("Tahoma", 1, 10));
        this.startL.setText("\u0391\u03c1\u03c7\u03ae");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.startL, gridBagConstraints);
        this.endL.setFont(new Font("Tahoma", 1, 10));
        this.endL.setText("\u03a4\u03ad\u03bb\u03bf\u03c2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.endL, gridBagConstraints);
        this.laneP.setBackground(Color.gray);
        this.laneP.setBorder(new LineBorder(new Color(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.laneP, gridBagConstraints);
        this.speed1TB.setFont(new Font("Tahoma", 1, 10));
        this.speed1TB.setText("\u03a0\u03bf\u03bb\u03cd \u03b1\u03c1\u03b3\u03ac");
        this.speedBG.add(this.speed1TB);
        this.speed1TB.setBorder(new BevelBorder(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.speed1TB, gridBagConstraints);
        this.speed2TB.setFont(new Font("Tahoma", 1, 10));
        this.speed2TB.setText("\u0391\u03c1\u03b3\u03ac");
        this.speedBG.add(this.speed2TB);
        this.speed2TB.setBorder(new BevelBorder(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.speed2TB, gridBagConstraints);
        this.speed3TB.setFont(new Font("Tahoma", 1, 10));
        this.speed3TB.setSelected(true);
        this.speed3TB.setText("\u039a\u03b1\u03bd\u03bf\u03bd\u03b9\u03ba\u03ac");
        this.speedBG.add(this.speed3TB);
        this.speed3TB.setBorder(new BevelBorder(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.speed3TB, gridBagConstraints);
        this.speed4TB.setFont(new Font("Tahoma", 1, 10));
        this.speed4TB.setText("\u0393\u03c1\u03ae\u03b3\u03bf\u03c1\u03b1");
        this.speedBG.add(this.speed4TB);
        this.speed4TB.setBorder(new BevelBorder(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.speed4TB, gridBagConstraints);
        this.speed5TB.setFont(new Font("Tahoma", 1, 10));
        this.speed5TB.setText("\u03a0\u03bf\u03bb\u03cd \u03b3\u03c1\u03ae\u03b3\u03bf\u03c1\u03b1");
        this.speedBG.add(this.speed5TB);
        this.speed5TB.setBorder(new BevelBorder(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.speed5TB, gridBagConstraints);
    }
}

