/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;

public class ExpressionPrinterVisitor
implements ParserVisitor {
    private Writer writer;

    public void printExpression(Node node) {
        this.printExpression(new PrintWriter(System.out), node);
    }

    public void printExpression(Writer writer, Node node) throws IllegalArgumentException {
        this.writer = writer;
        if (node == null) {
            throw new IllegalArgumentException();
        }
        node.jjtAccept(this, null);
    }

    private void addString(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getString(Node node) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.printExpression(stringWriter, node);
            return stringWriter.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "";
        }
    }

    public Object visit(ASTFunNode aSTFunNode, Object object) {
        this.addString("(");
        if (aSTFunNode.getOpID() == 10) {
            this.addString("~");
        }
        aSTFunNode.jjtGetChild(0).jjtAccept(this, null);
        for (int i = 1; i < aSTFunNode.jjtGetNumChildren(); ++i) {
            this.addString(aSTFunNode.getName());
            aSTFunNode.jjtGetChild(i).jjtAccept(this, null);
        }
        this.addString(")");
        return object;
    }

    public Object visit(ASTVarNode aSTVarNode, Object object) {
        this.addString(aSTVarNode.getName());
        return object;
    }

    public Object visit(ASTConstant aSTConstant, Object object) {
        if (aSTConstant.getValue() instanceof Double && (Double)aSTConstant.getValue() < 0.0) {
            this.addString("(");
            this.addString(aSTConstant.getValue().toString());
            this.addString(")");
        } else {
            this.addString(aSTConstant.getValue().toString());
        }
        return object;
    }

    public Object visit(ASTStart aSTStart, Object object) {
        return object;
    }

    public Object visit(SimpleNode simpleNode, Object object) {
        return object;
    }
}

