/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa.logging;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;

public class LogWriter
extends PrintWriter {
    private int level = 0;
    private boolean enabled = true;
    private boolean newLine = true;
    private final String EOL = System.getProperty("line.separator", "\n");
    private StringTokenizer st;

    public LogWriter(OutputStream outputStream) {
        super(outputStream, true);
    }

    public LogWriter(Writer writer) {
        super(writer);
    }

    public void setLogLevel(int n) {
        this.level = n;
    }

    public void incrLogLevel() {
        ++this.level;
    }

    public void decrLogLevel() {
        --this.level;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public void print(String string) {
        if (!this.enabled) {
            return;
        }
        this.st = new StringTokenizer(string, this.EOL);
        if (this.st.hasMoreElements()) {
            do {
                this.autoIndent();
                super.print(this.st.nextToken());
                if (this.st.hasMoreElements()) {
                    super.println();
                    this.newLine = true;
                    continue;
                }
                this.newLine = false;
            } while (this.newLine);
        }
    }

    public void println(String string) {
        if (!this.enabled) {
            return;
        }
        this.st = new StringTokenizer(string, this.EOL);
        while (this.st.hasMoreTokens()) {
            this.autoIndent();
            super.println(this.st.nextToken());
            this.newLine = true;
        }
    }

    public void println() {
        if (!this.enabled) {
            return;
        }
        super.println();
        this.newLine = true;
    }

    private void autoIndent() {
        if (!this.newLine) {
            return;
        }
        if (this.level < 1) {
            return;
        }
        for (int i = 0; i < this.level; ++i) {
            super.print("    ");
        }
        this.newLine = false;
    }

    public void printTitle(String string) {
        int n = this.level;
        this.level = 0;
        this.println();
        this.print("== ");
        this.print(string);
        StringBuffer stringBuffer = new StringBuffer(" ");
        int n2 = Math.max(1, 60 - string.length());
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append("=");
        }
        this.println(stringBuffer.toString());
        this.println();
        this.level = n;
    }
}

