/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Vector;

public class GridCanvas
extends Canvas
implements Printable {
    public static final int NO_GRID = 0;
    public static final int SQUARE_GRID = 1;
    public static final int TRIANGLE_GRID = 2;
    private int gridSize;
    private int gridMode;
    private boolean doSnap;
    private boolean showLines;
    private boolean fill;
    private boolean shapeClosed;
    private int triangleDy;
    private Image back = null;
    private Image image = null;
    private int width;
    private int height;
    private Color fillColor;
    private Color color;
    private Vector shapes = new Vector();
    private Vector points = new Vector();
    private XShape activeShape;
    private int activeVertex;
    private XPoint activePoint;
    private Line2D saxis;
    private boolean showAxis;

    public GridCanvas(int size, int mode, boolean snapFlag, boolean lineFlag, boolean fillFlag, Image img) {
        if (img != null) {
            this.image = img;
        }
        this.gridSize = size > 0 ? size : 10;
        this.gridMode = mode;
        this.doSnap = snapFlag;
        this.showLines = lineFlag;
        this.fill = fillFlag;
        this.setBackground(Color.WHITE);
        this.color = new Color(Color.black.getRGB());
        this.fillColor = new Color(Color.gray.getRGB());
        float fdy = (float)Math.sqrt(3.0) * (float)this.gridSize / 2.0f;
        this.triangleDy = Math.round(fdy);
        this.saxis = new Line2D.Double(0.0, 0.0, 800.0, 600.0);
        this.showAxis = false;
    }

    public void setGridSize(int grid) {
        this.gridSize = Math.abs(grid);
        float fdy = (float)Math.sqrt(3.0) * (float)this.gridSize / 2.0f;
        this.triangleDy = Math.round(fdy);
        this.forceBackRepaint();
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridMode(int mode) {
        this.gridMode = mode;
        this.forceBackRepaint();
    }

    public int getGridMode() {
        return this.gridMode;
    }

    public void setDoSnap(boolean b) {
        this.doSnap = b;
    }

    public boolean getDoSnap() {
        return this.doSnap;
    }

    public void setShowLines(boolean b) {
        this.showLines = b;
        this.forceBackRepaint();
    }

    public boolean getShowLines() {
        return this.showLines;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = new Color(c.getRGB());
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color c) {
        this.fillColor = new Color(c.getRGB());
    }

    public boolean getFill() {
        return this.fill;
    }

    public void setFill(boolean f) {
        this.fill = f;
    }

    public void showAxis() {
        this.showAxis = true;
        this.forceBackRepaint();
    }

    public void hideAxis() {
        this.showAxis = false;
        this.forceBackRepaint();
    }

    public void setAxis(Point p1, Point p2) {
        this.saxis = new Line2D.Double(p1, p2);
        this.forceBackRepaint();
    }

    public void setShapeClosed(boolean b) {
        this.shapeClosed = b;
    }

    public void setImage(Image img) {
        this.image = img;
        this.forceBackRepaint();
    }

    public Vector getShapeVector() {
        return this.shapes;
    }

    public void setShapeVector(Vector v) {
        this.shapes = v;
    }

    public Vector getPointVector() {
        return this.points;
    }

    public void setPointVector(Vector v) {
        this.points = v;
    }

    private void fixGrid(Graphics bgr) {
        ((Graphics2D)bgr).setStroke(new BasicStroke(1.0f, 2, 0));
        switch (this.gridMode) {
            case 1: {
                int y;
                int x;
                if (this.showLines) {
                    bgr.setColor(Color.lightGray);
                    x = this.gridSize;
                    while (x < this.width) {
                        bgr.drawLine(x, 1, x, this.height - 1);
                        x += this.gridSize;
                    }
                    y = this.gridSize;
                    while (y < this.height) {
                        bgr.drawLine(1, y, this.width - 1, y);
                        y += this.gridSize;
                    }
                }
                bgr.setColor(Color.darkGray);
                x = this.gridSize;
                while (x < this.width) {
                    y = this.gridSize;
                    while (y < this.height) {
                        bgr.fillOval(x, y, 1, 1);
                        y += this.gridSize;
                    }
                    x += this.gridSize;
                }
                break;
            }
            case 2: {
                int y;
                int x;
                if (this.showLines) {
                    bgr.setColor(Color.lightGray);
                    x = this.gridSize;
                    y = 2 * this.triangleDy;
                    while (x < 2 * this.width || y < 2 * this.height) {
                        bgr.drawLine(x, 0, 0, y);
                        int xx = (int)Math.floor((float)this.width / (float)this.gridSize) * this.gridSize;
                        bgr.drawLine(xx - x, 0, xx, y);
                        x += this.gridSize;
                        y += 2 * this.triangleDy;
                    }
                    y = this.triangleDy;
                    while (y < this.height) {
                        bgr.drawLine(1, y, this.width, y);
                        y += this.triangleDy;
                    }
                }
                bgr.setColor(Color.darkGray);
                x = this.gridSize;
                while (x < this.width) {
                    y = 2 * this.triangleDy;
                    while (y < this.height) {
                        bgr.fillOval(x, y, 1, 1);
                        y += 2 * this.triangleDy;
                    }
                    x += this.gridSize;
                }
                int x2 = this.gridSize / 2;
                while (x2 < this.width) {
                    int y2 = this.triangleDy;
                    while (y2 < this.height) {
                        bgr.fillOval(x2, y2, 1, 1);
                        y2 += 2 * this.triangleDy;
                    }
                    x2 += this.gridSize;
                }
                break;
            }
        }
    }

    private void fixBack() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.back = this.createImage(this.width, this.height);
        Graphics bgr = this.back.getGraphics();
        bgr.clearRect(0, 0, this.width, this.height);
        if (this.image != null) {
            int x = this.width / 2 - this.image.getWidth(null) / 2;
            int y = this.height / 2 - this.image.getHeight(null) / 2;
            bgr.drawImage(this.image, x, y, null);
        }
        this.drawAllShapes(bgr);
        this.fixGrid(bgr);
        if (this.showAxis) {
            Graphics2D g2 = (Graphics2D)bgr;
            float[] dash = new float[]{5.0f, 5.0f};
            g2.setColor(Color.black);
            g2.setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, dash, 0.0f));
            g2.draw(this.saxis);
            g2.setColor(Color.white);
            g2.setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, dash, 5.0f));
            g2.draw(this.saxis);
            g2.setStroke(new BasicStroke(1.0f, 2, 0));
        }
        bgr.setColor(Color.black);
        bgr.drawRect(0, 0, this.width - 1, this.height - 1);
    }

    public void clear() {
        this.shapes.clear();
        this.points.clear();
        this.back = null;
        this.repaint();
    }

    public void paint(Graphics g) {
        if (this.back == null) {
            this.fixBack();
        }
        g.drawImage(this.back, 0, 0, null);
    }

    public void forceBackRepaint() {
        this.back = null;
        this.repaint();
    }

    private int snap(int x) {
        float f = x;
        return Math.round(f /= (float)this.gridSize) * this.gridSize;
    }

    private Point snapTriangle(Point pnt) {
        Point ret = new Point(0, 0);
        float f = pnt.y;
        int r = Math.round(f /= (float)this.triangleDy);
        ret.y = r * this.triangleDy;
        if (r % 2 == 0) {
            ret.x = this.snap(pnt.x);
        } else {
            ret.x = this.snap(pnt.x);
            ret.x = pnt.x > ret.x ? (ret.x += this.gridSize / 2) : (ret.x -= this.gridSize / 2);
        }
        return ret;
    }

    public Point snap(Point pnt) {
        Point snaped = new Point();
        if (this.gridSize == 0 || !this.doSnap) {
            return pnt;
        }
        switch (this.gridMode) {
            case 1: {
                snaped.x = this.snap(pnt.x);
                snaped.y = this.snap(pnt.y);
                break;
            }
            case 2: {
                snaped = this.snapTriangle(pnt);
            }
        }
        return snaped;
    }

    public void drawShape(Shape s) {
        Image tmpimg = this.createImage(this.getWidth(), this.getHeight());
        Graphics tmpgr = tmpimg.getGraphics();
        this.paint(tmpgr);
        Graphics g = this.getGraphics();
        Graphics2D g2 = (Graphics2D)tmpgr;
        g2.setStroke(new BasicStroke(3.0f, 2, 0));
        g2.setColor(this.color);
        if (this.fill && this.shapeClosed) {
            g2.setColor(this.fillColor);
            g2.fill(s);
        }
        g2.setColor(this.color);
        g2.draw(s);
        boolean b = false;
        float[] coord = new float[6];
        PathIterator pi = s.getPathIterator(null);
        int startX = 0;
        int startY = 0;
        int type = pi.currentSegment(coord);
        if (type == 0) {
            startX = (int)coord[0];
            startY = (int)coord[1];
        }
        int vx = 0;
        int vy = 0;
        while (!pi.isDone()) {
            type = pi.currentSegment(coord);
            switch (type) {
                case 1: {
                    vx = (int)coord[0];
                    vy = (int)coord[1];
                    break;
                }
                case 4: {
                    b = true;
                }
            }
            pi.next();
        }
        if (this.shapeClosed && !b) {
            float[] dash = new float[]{5.0f, 5.0f};
            g2.setColor(Color.black);
            g2.setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, dash, 0.0f));
            g2.draw(new Line2D.Float(startX, startY, vx, vy));
            g2.setColor(Color.white);
            g2.setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, dash, 5.0f));
            g2.draw(new Line2D.Float(startX, startY, vx, vy));
        }
        this.fixGrid(g2);
        g.drawImage(tmpimg, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    public void backDrawShape(Shape s) {
        XShape xs = new XShape(s, this.color, this.fill, this.fillColor, this.shapeClosed);
        this.shapes.add(xs);
        Graphics2D g2 = (Graphics2D)this.back.getGraphics();
        if (this.fill && this.shapeClosed) {
            g2.setColor(this.fillColor);
            g2.fill(s);
        }
        g2.setColor(this.color);
        g2.setStroke(new BasicStroke(3.0f, 2, 0));
        g2.draw(s);
        this.fixGrid(g2);
        this.paint(this.getGraphics());
    }

    public void addPoint(int x, int y) {
        this.points.add(new XPoint(x, y, this.color));
        Graphics2D g2 = (Graphics2D)this.back.getGraphics();
        g2.setColor(this.color);
        g2.fillOval(x - 3, y - 3, 7, 7);
        this.paint(this.getGraphics());
    }

    private void drawAllShapes(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int i = 0;
        while (i < this.shapes.size()) {
            XShape s = (XShape)this.shapes.elementAt(i);
            g2.setStroke(new BasicStroke(3.0f, 2, 0));
            if (s.fill && s.closed) {
                g2.setColor(s.fillColor);
                g2.fill(s.shape);
            }
            g2.setColor(s.color);
            g2.draw(s.shape);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.points.size()) {
            XPoint p = (XPoint)this.points.elementAt(i2);
            g2.setColor(p.color);
            g2.fillOval(p.x - 3, p.y - 3, 7, 7);
            ++i2;
        }
    }

    public void drawDashedLine(int x1, int y1, int x2, int y2) {
        this.paint(this.getGraphics());
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        float[] dash = new float[]{5.0f, 5.0f};
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, dash, 0.0f));
        g2.draw(new Line2D.Float(x1, y1, x2, y2));
        g2.setColor(Color.white);
        g2.setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, dash, 5.0f));
        g2.draw(new Line2D.Float(x1, y1, x2, y2));
    }

    public void drawDashedAngle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.paint(this.getGraphics());
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        float[] dash = new float[]{5.0f, 5.0f};
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, dash, 0.0f));
        g2.draw(new Line2D.Float(x1, y1, x2, y2));
        g2.draw(new Line2D.Float(x1, y1, x3, y3));
        g2.setColor(Color.white);
        g2.setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, dash, 5.0f));
        g2.draw(new Line2D.Float(x1, y1, x2, y2));
        g2.draw(new Line2D.Float(x1, y1, x3, y3));
    }

    public void drawActiveShape(boolean highlight) {
        Image tmpimg = this.createImage(this.getWidth(), this.getHeight());
        Graphics tmpgr = tmpimg.getGraphics();
        this.paint(tmpgr);
        Graphics2D g2 = (Graphics2D)tmpgr;
        g2.setStroke(new BasicStroke(3.0f, 2, 0));
        g2.setColor(this.activeShape.color);
        if (this.activeShape.fill && this.activeShape.closed) {
            g2.fill(this.activeShape.shape);
        }
        if (highlight) {
            if (this.activeShape.color.getRGB() != Color.cyan.getRGB()) {
                g2.setColor(Color.cyan);
            } else {
                g2.setColor(Color.magenta);
            }
            g2.draw(this.activeShape.shape);
            if (this.activeShape.color.getRGB() != Color.cyan.getRGB()) {
                g2.setColor(Color.magenta);
            } else {
                g2.setColor(Color.cyan);
            }
            float[] coord = new float[6];
            if (this.activeShape.shape.getPathIterator(null).currentSegment(coord) == 0) {
                g2.fillOval((int)coord[0] - 3, (int)coord[1] - 3, 7, 7);
            }
        } else {
            g2.draw(this.activeShape.shape);
        }
        this.getGraphics().drawImage(tmpimg, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    public void copyActiveShape() {
        XShape xs = new XShape(this.activeShape.shape, this.activeShape.color, this.activeShape.fill, this.activeShape.fillColor, this.activeShape.closed);
        this.shapes.add(xs);
        this.activeShape = xs;
    }

    public void moveActiveShape(int dx, int dy) {
        AffineTransform at = new AffineTransform();
        at.setToTranslation(dx, dy);
        GeneralPath gp = new GeneralPath(this.activeShape.shape);
        this.activeShape.shape = gp.createTransformedShape(at);
        this.drawActiveShape(true);
    }

    public void repaintActiveShape() {
        this.activeShape.color = this.color;
        this.activeShape.fill = this.fill;
        if (this.fill) {
            this.activeShape.fillColor = this.fillColor;
        }
        this.drawActiveShape(false);
    }

    public double resizeActiveShape(int dx, int dy) {
        double sx;
        int pivotX = 0;
        int pivotY = 0;
        float[] coord = new float[6];
        PathIterator pi = this.activeShape.shape.getPathIterator(null);
        if (pi.currentSegment(coord) == 0) {
            pivotX = (int)coord[0];
            pivotY = (int)coord[1];
        }
        if ((sx = 1.0 + (double)dx * 0.01) != 0.0) {
            AffineTransform at = new AffineTransform();
            GeneralPath gp = new GeneralPath(this.activeShape.shape);
            at.setToTranslation(-pivotX, -pivotY);
            gp.transform(at);
            at.setToScale(sx, sx);
            gp.transform(at);
            at.setToTranslation(pivotX, pivotY);
            this.activeShape.shape = gp.createTransformedShape(at);
            this.drawActiveShape(true);
        }
        return sx;
    }

    public double rotateActiveShape(int deg, int dir) {
        int pivotX = 0;
        int pivotY = 0;
        float[] coord = new float[6];
        PathIterator pi = this.activeShape.shape.getPathIterator(null);
        if (pi.currentSegment(coord) == 0) {
            pivotX = (int)coord[0];
            pivotY = (int)coord[1];
        }
        double theta = 0.0;
        if (dir != 0) {
            theta = (double)dir * Math.PI * (double)deg / 180.0;
            AffineTransform at = new AffineTransform();
            at.setToRotation(theta, pivotX, pivotY);
            GeneralPath gp = new GeneralPath(this.activeShape.shape);
            this.activeShape.shape = gp.createTransformedShape(at);
        }
        this.drawActiveShape(true);
        return theta;
    }

    public double rotateActiveShape(Point oldpnt, Point newpnt, int dir) {
        int dx = newpnt.x - oldpnt.x;
        int dy = newpnt.y - oldpnt.y;
        int pivotX = 0;
        int pivotY = 0;
        float[] coord = new float[6];
        PathIterator pi = this.activeShape.shape.getPathIterator(null);
        if (pi.currentSegment(coord) == 0) {
            pivotX = (int)coord[0];
            pivotY = (int)coord[1];
        }
        if (dir == 0) {
            Line2D.Float line = new Line2D.Float(pivotX, pivotY, oldpnt.x, oldpnt.y);
            dir = -line.relativeCCW(newpnt.x, newpnt.y);
        }
        double theta = 0.0;
        if (dir != 0) {
            theta = (double)dir * Math.PI * Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0)) / 360.0;
            AffineTransform at = new AffineTransform();
            at.setToRotation(theta, pivotX, pivotY);
            GeneralPath gp = new GeneralPath(this.activeShape.shape);
            this.activeShape.shape = gp.createTransformedShape(at);
        }
        this.drawActiveShape(true);
        return theta;
    }

    public void mirrorActiveShape() {
        Object invat = null;
        Point p1 = new Point((int)this.saxis.getX1(), (int)this.saxis.getY1());
        Point p2 = new Point((int)this.saxis.getX2(), (int)this.saxis.getY2());
        Point p3 = new Point((int)this.saxis.getX1() + 500, (int)this.saxis.getY1());
        double angle = this.measureAngle(p1, p2, p3);
        GeneralPath gp = new GeneralPath(this.activeShape.shape);
        AffineTransform at = new AffineTransform();
        at.setToTranslation(-this.saxis.getX1(), -this.saxis.getY1());
        gp.transform(at);
        at.setToRotation(angle *= (double)(-this.saxis.relativeCCW(p3)), 0.0, 0.0);
        gp.transform(at);
        at.setTransform(1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
        gp.transform(at);
        at.setToRotation(-angle);
        gp.transform(at);
        at.setToTranslation(this.saxis.getX1(), this.saxis.getY1());
        this.activeShape.shape = gp.createTransformedShape(at);
    }

    public void deleteActiveShape() {
        this.shapes.remove(this.activeShape);
        this.back = null;
        this.repaint();
    }

    public void activeShapeMoveTo(int x, int y) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(x, y);
        this.activeShape = new XShape(gp, this.color, this.fill, this.fillColor);
    }

    public void activeShapeLineTo(int x, int y) {
        GeneralPath gp = new GeneralPath(this.activeShape.shape);
        gp.lineTo(x, y);
        this.activeShape.shape = gp;
        this.drawShape(this.activeShape.shape);
    }

    public void activeShapeClose() {
        if (this.shapeClosed) {
            GeneralPath gp = new GeneralPath(this.activeShape.shape);
            gp.closePath();
            this.activeShape.shape = gp;
        }
        this.activeShape.closed = this.shapeClosed;
        this.backDrawShape(this.activeShape.shape);
    }

    public void activeShapeFinish() {
        this.activeShape.closed = false;
        this.backDrawShape(this.activeShape.shape);
    }

    public void activeShapeDrawLineTo(int x, int y) {
        GeneralPath gp = new GeneralPath(this.activeShape.shape);
        gp.lineTo(x, y);
        this.drawShape(gp);
    }

    public double calcActiveShapePerimeter() {
        if (this.activeShape != null) {
            double perim = this.activeShape.calculatePerimeter(this.gridMode);
            return perim /= (double)this.gridSize;
        }
        return 0.0;
    }

    public double calcActiveShapeArea() {
        if (this.activeShape != null) {
            double area = this.activeShape.calculateArea();
            area = this.gridMode == 2 ? (area /= (double)(this.gridSize * this.triangleDy / 2)) : (area /= Math.pow(this.gridSize, 2.0));
            return area;
        }
        return 0.0;
    }

    public void addTriangle(int x, int y) {
        int yy = this.gridMode == 1 ? this.gridSize : this.triangleDy;
        GeneralPath gp = new GeneralPath();
        this.shapeClosed = true;
        gp.moveTo(x, y);
        Point p = this.snap(new Point(x + 4 * this.gridSize, y));
        gp.lineTo(p.x, p.y);
        p = this.snap(new Point(x + 2 * this.gridSize, y - 4 * yy));
        gp.lineTo(p.x, p.y);
        gp.closePath();
        this.backDrawShape(gp);
    }

    public int addUTriangle(Point p) {
        GeneralPath gp = new GeneralPath();
        this.shapeClosed = true;
        Point sp = this.snap(p);
        if (sp.x != p.x) {
            float a = (float)(p.y - sp.y) / (float)(p.x - sp.x);
            if (a <= 0.0f && a > -1.0f) {
                if (p.x - sp.x > 0) {
                    gp.moveTo(sp.x, sp.y);
                    Point pnt = this.snap(new Point(sp.x + this.gridSize, sp.y));
                    gp.lineTo(pnt.x, pnt.y);
                    pnt = this.snap(new Point(sp.x + this.gridSize / 2, sp.y - this.triangleDy));
                    gp.lineTo(pnt.x, pnt.y);
                    gp.closePath();
                } else {
                    gp.moveTo(sp.x, sp.y);
                    Point pnt = this.snap(new Point(sp.x - this.gridSize, sp.y));
                    gp.lineTo(pnt.x, pnt.y);
                    pnt = this.snap(new Point(sp.x - this.gridSize / 2, sp.y + this.triangleDy));
                    gp.lineTo(pnt.x, pnt.y);
                    gp.closePath();
                }
                this.backDrawShape(gp);
                return 0;
            }
            if (a > 0.0f && a < 1.0f) {
                if (p.x - sp.x > 0) {
                    gp.moveTo(sp.x, sp.y);
                    Point pnt = this.snap(new Point(sp.x + this.gridSize, sp.y));
                    gp.lineTo(pnt.x, pnt.y);
                    pnt = this.snap(new Point(sp.x + this.gridSize / 2, sp.y + this.triangleDy));
                    gp.lineTo(pnt.x, pnt.y);
                    gp.closePath();
                } else {
                    gp.moveTo(sp.x, sp.y);
                    Point pnt = this.snap(new Point(sp.x - this.gridSize, sp.y));
                    gp.lineTo(pnt.x, pnt.y);
                    pnt = this.snap(new Point(sp.x - this.gridSize / 2, sp.y - this.triangleDy));
                    gp.lineTo(pnt.x, pnt.y);
                    gp.closePath();
                }
                this.backDrawShape(gp);
                return 0;
            }
        }
        if (p.y - sp.y > 0) {
            gp.moveTo(sp.x, sp.y);
            Point pnt = this.snap(new Point(sp.x + this.gridSize / 2, sp.y + this.triangleDy));
            gp.lineTo(pnt.x, pnt.y);
            pnt = this.snap(new Point(sp.x - this.gridSize / 2, sp.y + this.triangleDy));
            gp.lineTo(pnt.x, pnt.y);
            gp.closePath();
        } else {
            gp.moveTo(sp.x, sp.y);
            Point pnt = this.snap(new Point(sp.x + this.gridSize / 2, sp.y - this.triangleDy));
            gp.lineTo(pnt.x, pnt.y);
            pnt = this.snap(new Point(sp.x - this.gridSize / 2, sp.y - this.triangleDy));
            gp.lineTo(pnt.x, pnt.y);
            gp.closePath();
        }
        this.backDrawShape(gp);
        return 0;
    }

    public void addSquare(int x, int y) {
        int yy = this.gridMode == 2 ? 4 * this.triangleDy : 4 * this.gridSize;
        GeneralPath gp = new GeneralPath();
        this.shapeClosed = true;
        gp.moveTo(x, y);
        Point p = this.snap(new Point(x + 4 * this.gridSize, y));
        gp.lineTo(p.x, p.y);
        p = this.snap(new Point(x + 4 * this.gridSize, y - yy));
        gp.lineTo(p.x, p.y);
        p = this.snap(new Point(x, y - yy));
        gp.lineTo(p.x, p.y);
        gp.closePath();
        this.backDrawShape(gp);
    }

    public void addUSquare(Point p) {
        GeneralPath gp = new GeneralPath();
        this.shapeClosed = true;
        Point sp = this.snap(p);
        if (p.x > sp.x) {
            if (p.y > sp.y) {
                gp.moveTo(sp.x, sp.y);
                Point pnt = this.snap(new Point(sp.x + this.gridSize, sp.y));
                gp.lineTo(pnt.x, pnt.y);
                pnt = this.snap(new Point(sp.x + this.gridSize, sp.y + this.gridSize));
                gp.lineTo(pnt.x, pnt.y);
                pnt = this.snap(new Point(sp.x, sp.y + this.gridSize));
                gp.lineTo(pnt.x, pnt.y);
                gp.closePath();
            } else {
                gp.moveTo(sp.x, sp.y);
                Point pnt = this.snap(new Point(sp.x + this.gridSize, sp.y));
                gp.lineTo(pnt.x, pnt.y);
                pnt = this.snap(new Point(sp.x + this.gridSize, sp.y - this.gridSize));
                gp.lineTo(pnt.x, pnt.y);
                pnt = this.snap(new Point(sp.x, sp.y - this.gridSize));
                gp.lineTo(pnt.x, pnt.y);
                gp.closePath();
            }
        } else if (p.y > sp.y) {
            gp.moveTo(sp.x, sp.y);
            Point pnt = this.snap(new Point(sp.x - this.gridSize, sp.y));
            gp.lineTo(pnt.x, pnt.y);
            pnt = this.snap(new Point(sp.x - this.gridSize, sp.y + this.gridSize));
            gp.lineTo(pnt.x, pnt.y);
            pnt = this.snap(new Point(sp.x, sp.y + this.gridSize));
            gp.lineTo(pnt.x, pnt.y);
            gp.closePath();
        } else {
            gp.moveTo(sp.x, sp.y);
            Point pnt = this.snap(new Point(sp.x - this.gridSize, sp.y));
            gp.lineTo(pnt.x, pnt.y);
            pnt = this.snap(new Point(sp.x - this.gridSize, sp.y - this.gridSize));
            gp.lineTo(pnt.x, pnt.y);
            pnt = this.snap(new Point(sp.x, sp.y - this.gridSize));
            gp.lineTo(pnt.x, pnt.y);
            gp.closePath();
        }
        this.backDrawShape(gp);
    }

    public void addDiamond(int x, int y) {
        int yy = this.gridMode == 1 ? 2 * this.gridSize : 2 * this.triangleDy;
        GeneralPath gp = new GeneralPath();
        this.shapeClosed = true;
        gp.moveTo(x, y);
        Point p = this.snap(new Point(x + 4 * this.gridSize, y));
        gp.lineTo(p.x, p.y);
        p = this.snap(new Point(x + 2 * this.gridSize, y - 2 * yy));
        gp.lineTo(p.x, p.y);
        p = this.snap(new Point(x - 2 * this.gridSize, y - 2 * yy));
        gp.lineTo(p.x, p.y);
        gp.closePath();
        this.backDrawShape(gp);
    }

    public void addTrapezoid(int x, int y) {
        int yy = this.gridMode == 1 ? 2 * this.gridSize : 2 * this.triangleDy;
        GeneralPath gp = new GeneralPath();
        this.shapeClosed = true;
        gp.moveTo(x, y);
        Point p = this.snap(new Point(x + 2 * this.gridSize, y));
        gp.lineTo(p.x, p.y);
        p = this.snap(new Point(x + 4 * this.gridSize, y - 2 * yy));
        gp.lineTo(p.x, p.y);
        p = this.snap(new Point(x - 2 * this.gridSize, y - 2 * yy));
        gp.lineTo(p.x, p.y);
        gp.closePath();
        this.backDrawShape(gp);
    }

    public void addCircle(int x, int y) {
        GeneralPath gp = new GeneralPath();
        this.shapeClosed = true;
        gp.moveTo(x + 2 * this.gridSize, y);
        float step = 0.10471976f;
        int i = 1;
        while (i < 60) {
            gp.lineTo((float)x + (float)(2 * this.gridSize) * (float)Math.cos((float)i * step), (float)y + (float)(2 * this.gridSize) * (float)Math.sin((float)i * step));
            ++i;
        }
        gp.closePath();
        this.backDrawShape(gp);
    }

    public void addHexagon(int x, int y) {
        int yy = this.gridMode == 1 ? 2 * this.gridSize : 2 * this.triangleDy;
        GeneralPath gp = new GeneralPath();
        this.shapeClosed = true;
        gp.moveTo(x, y);
        Point p = this.snap(new Point(x + 2 * this.gridSize, y));
        gp.lineTo(p.x, p.y);
        p = this.snap(new Point(x + 3 * this.gridSize, y - yy));
        gp.lineTo(p.x, p.y);
        p = this.snap(new Point(x + 2 * this.gridSize, y - 2 * yy));
        gp.lineTo(p.x, p.y);
        p = this.snap(new Point(x, y - 2 * yy));
        gp.lineTo(p.x, p.y);
        p = this.snap(new Point(x - this.gridSize, y - yy));
        gp.lineTo(p.x, p.y);
        gp.closePath();
        this.backDrawShape(gp);
    }

    public boolean checkShapeSelection(Point pnt) {
        int x = pnt.x;
        int y = pnt.y;
        this.paint(this.getGraphics());
        int i = this.shapes.size();
        while (i > 0) {
            XShape s = (XShape)this.shapes.get(i - 1);
            if (s.hitsShapeOutline(x, y) || s.isClosed() && s.fill && s.shape.contains(x, y)) {
                this.activeShape = s;
                Graphics2D g2 = (Graphics2D)this.getGraphics();
                g2.setStroke(new BasicStroke(3.0f, 1, 0));
                if (s.color.getRGB() != Color.cyan.getRGB()) {
                    g2.setColor(Color.cyan);
                } else {
                    g2.setColor(Color.magenta);
                }
                g2.draw(this.activeShape.shape);
                if (s.color.getRGB() != Color.cyan.getRGB()) {
                    g2.setColor(Color.magenta);
                } else {
                    g2.setColor(Color.cyan);
                }
                float[] coord = new float[6];
                if (s.shape.getPathIterator(null).currentSegment(coord) == 0) {
                    g2.fillOval((int)coord[0] - 3, (int)coord[1] - 3, 7, 7);
                }
                return true;
            }
            --i;
        }
        return false;
    }

    public boolean checkVertexSelection(Point pnt) {
        Point vertex;
        int index;
        int x = pnt.x;
        int y = pnt.y;
        if (this.checkShapeSelection(pnt) && (index = this.activeShape.hitsShapeVertex(x, y, vertex = new Point())) > -1) {
            Graphics2D g2 = (Graphics2D)this.getGraphics();
            this.activeVertex = index;
            g2.setColor(Color.magenta);
            g2.fillOval(vertex.x - 5, vertex.y - 5, 11, 11);
            g2.setColor(Color.cyan);
            g2.fillOval(vertex.x - 3, vertex.y - 3, 7, 7);
            g2.setColor(Color.magenta);
            g2.fillOval(vertex.x - 1, vertex.y - 1, 3, 3);
            return true;
        }
        return false;
    }

    public boolean checkPointSelection(Point pnt) {
        this.paint(this.getGraphics());
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        int i = 0;
        while (i < this.points.size()) {
            XPoint xp = (XPoint)this.points.get(i);
            if (xp.sameCoord(pnt, 3)) {
                this.activePoint = xp;
                if (xp.color.getRGB() != Color.cyan.getRGB()) {
                    g2.setColor(Color.cyan);
                } else {
                    g2.setColor(Color.magenta);
                }
                g2.fillOval(xp.x - 3, xp.y - 3, 7, 7);
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XShape findShapeToCut(int x1, int y1, int x2, int y2) {
        if (Math.abs(x1 - x2) >= Math.abs(y1 - y2)) {
            if (x1 == x2) return null;
            double a = (double)(y2 - y1) / (double)(x2 - x1);
            double b = (double)y2 * (double)x1 / (double)(x1 - x2) - (double)y1 * (double)x2 / (double)(x1 - x2);
            double x = x1;
            while (x != (double)x2) {
                double y = a * x + b;
                int i = this.shapes.size();
                while (i > 0) {
                    XShape s = (XShape)this.shapes.get(i - 1);
                    if (s.isClosed() && s.shape.intersects(x, y, 1.0, 1.0) && !s.shape.intersects(x1, y1, 1.0, 1.0) && !s.shape.intersects(x2, y2, 1.0, 1.0)) {
                        Graphics2D g2 = (Graphics2D)this.getGraphics();
                        this.paint(g2);
                        g2.setColor(Color.cyan);
                        g2.draw(s.shape);
                        return s;
                    }
                    --i;
                }
                x += (double)((x2 - x1) / Math.abs(x2 - x1));
            }
            return null;
        } else {
            if (y1 == y2) return null;
            double a = (double)(x2 - x1) / (double)(y2 - y1);
            double b = (double)x2 * (double)y1 / (double)(y1 - y2) - (double)x1 * (double)y2 / (double)(y1 - y2);
            double y = y1;
            while (y != (double)y2) {
                double x = a * y + b;
                int i = this.shapes.size();
                while (i > 0) {
                    XShape s = (XShape)this.shapes.get(i - 1);
                    if (s.isClosed() && s.shape.intersects(x, y, 1.0, 1.0) && !s.shape.intersects(x1, y1, 1.0, 1.0) && !s.shape.intersects(x2, y2, 1.0, 1.0)) {
                        Graphics2D g2 = (Graphics2D)this.getGraphics();
                        this.paint(g2);
                        g2.setColor(Color.cyan);
                        g2.draw(s.shape);
                        return s;
                    }
                    --i;
                }
                y += (double)((y2 - y1) / Math.abs(y2 - y1));
            }
        }
        return null;
    }

    public void cutShape(int x1, int y1, int x2, int y2) {
        XShape xs = this.findShapeToCut(x1, y1, x2, y2);
        if (xs != null) {
            Vector newShapes = new Vector();
            if (xs.cutShape(x1, y1, x2, y2, newShapes) > 0) {
                int i = 0;
                while (i < newShapes.size()) {
                    XShape newxs = (XShape)newShapes.get(i);
                    this.shapes.add(newxs);
                    ++i;
                }
                this.shapes.remove(xs);
            }
            this.back = null;
            this.repaint();
        }
    }

    public void activeShapeAddVertex(Point p) {
        this.activeVertex = this.activeShape.addVertex(p.x, p.y);
    }

    public void dragActiveVertex(Point p) {
        this.activeShape.moveVertex(this.activeVertex, p.x, p.y);
        this.drawActiveShape(true);
    }

    public void deleteActivePoint() {
        this.points.remove(this.activePoint);
        this.forceBackRepaint();
    }

    public void moveActivePoint(int x, int y) {
        this.paint(this.getGraphics());
        this.activePoint.x = x;
        this.activePoint.y = y;
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        g2.setColor(this.activePoint.color);
        g2.fillOval(x - 3, y - 3, 7, 7);
    }

    public double measureDistance(Point p1, Point p2) {
        double dist = this.gridMode == 2 ? Math.sqrt(Math.pow((double)p1.x - (double)p2.x, 2.0) + 1.038055 * Math.pow((double)p1.y - (double)p2.y, 2.0)) : Math.sqrt(Math.pow((double)p1.x - (double)p2.x, 2.0) + Math.pow((double)p1.y - (double)p2.y, 2.0));
        return dist / (double)this.gridSize;
    }

    public double measureAngle(Point p1, Point p2, Point p3) {
        double g = (p2.x - p1.x) * (p3.x - p1.x) + (p2.y - p1.y) * (p3.y - p1.y);
        double d1 = Math.sqrt(Math.pow((double)p1.x - (double)p2.x, 2.0) + Math.pow((double)p1.y - (double)p2.y, 2.0));
        double d2 = Math.sqrt(Math.pow((double)p1.x - (double)p3.x, 2.0) + Math.pow((double)p1.y - (double)p3.y, 2.0));
        double angle = Math.acos(g / (d1 * d2));
        return angle;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int param) throws PrinterException {
        if (param >= 1) {
            return 1;
        }
        this.paint(graphics);
        graphics.translate((int)pageFormat.getImageableX() + 72, (int)pageFormat.getImageableY() + 72);
        return 0;
    }

    static {
        NO_GRID = 0;
        SQUARE_GRID = 1;
        TRIANGLE_GRID = 2;
    }
}

