/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EquationPanelB
extends JPanel {
    private EquationApplet applet;
    public Equation equation = new Equation();
    private byte operation;
    private JToggleButton butSub;
    private JPanel arrowPanel;
    private JToggleButton butAdd;
    private JToggleButton butDiv;
    private JTextField txtValA;
    private ButtonGroup groupOperators;
    private JTextField txtValResult;
    private JButton butCheck;
    private JToggleButton butMul;
    private OvalPanel valB;

    public EquationPanelB(EquationApplet applet) {
        this.applet = applet;
        this.operation = 1;
        this.initComponents();
        this.arrowPanel.add((Component)new ArrowCanvasL(), "Center");
    }

    public void clear() {
        this.equation.clear();
        this.txtValA.setText("0");
        this.valB.setText("0");
        this.txtValResult.setText("0");
    }

    private void initComponents() {
        this.groupOperators = new ButtonGroup();
        this.txtValA = new JTextField();
        this.butAdd = new JToggleButton();
        this.butSub = new JToggleButton();
        this.butMul = new JToggleButton();
        this.butDiv = new JToggleButton();
        this.txtValResult = new JTextField();
        this.butCheck = new JButton();
        this.arrowPanel = new JPanel();
        this.valB = new OvalPanel();
        this.setLayout(null);
        this.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.txtValA.setBackground(new Color(0, 255, 0));
        this.txtValA.setFont(new Font("Dialog", 1, 14));
        this.txtValA.setHorizontalAlignment(0);
        this.txtValA.setText("0");
        this.add(this.txtValA);
        this.txtValA.setBounds(20, 40, 70, 60);
        this.butAdd.setFont(new Font("Dialog", 1, 14));
        this.butAdd.setSelected(true);
        this.butAdd.setText("+");
        this.groupOperators.add(this.butAdd);
        this.butAdd.setMargin(new Insets(2, 2, 2, 2));
        this.butAdd.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                EquationPanelB.this.butAddStateChanged(evt);
            }
        });
        this.add(this.butAdd);
        this.butAdd.setBounds(120, 60, 20, 20);
        this.butSub.setFont(new Font("Dialog", 1, 14));
        this.butSub.setText("-");
        this.groupOperators.add(this.butSub);
        this.butSub.setMargin(new Insets(2, 2, 2, 2));
        this.butSub.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                EquationPanelB.this.butSubStateChanged(evt);
            }
        });
        this.add(this.butSub);
        this.butSub.setBounds(140, 60, 20, 20);
        this.butMul.setFont(new Font("Dialog", 1, 14));
        this.butMul.setText("X");
        this.groupOperators.add(this.butMul);
        this.butMul.setMargin(new Insets(2, 2, 2, 2));
        this.butMul.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                EquationPanelB.this.butMulStateChanged(evt);
            }
        });
        this.add(this.butMul);
        this.butMul.setBounds(160, 60, 20, 20);
        this.butDiv.setFont(new Font("Dialog", 1, 14));
        this.butDiv.setText(":");
        this.groupOperators.add(this.butDiv);
        this.butDiv.setMargin(new Insets(2, 2, 2, 2));
        this.butDiv.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                EquationPanelB.this.butDivStateChanged(evt);
            }
        });
        this.add(this.butDiv);
        this.butDiv.setBounds(180, 60, 20, 20);
        this.txtValResult.setBackground(new Color(0, 102, 255));
        this.txtValResult.setFont(new Font("Dialog", 1, 14));
        this.txtValResult.setHorizontalAlignment(0);
        this.txtValResult.setText("0");
        this.add(this.txtValResult);
        this.txtValResult.setBounds(230, 40, 70, 60);
        this.butCheck.setText("\u0388\u03bb\u03b5\u03b3\u03c7\u03bf\u03c2");
        this.butCheck.setMargin(new Insets(2, 2, 2, 2));
        this.butCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EquationPanelB.this.butCheckActionPerformed(evt);
            }
        });
        this.add(this.butCheck);
        this.butCheck.setBounds(120, 120, 90, 26);
        this.arrowPanel.setLayout(new BorderLayout());
        this.arrowPanel.setBackground(new Color(204, 204, 204));
        this.arrowPanel.setMinimumSize(new Dimension(100, 20));
        this.arrowPanel.setPreferredSize(new Dimension(100, 20));
        this.add(this.arrowPanel);
        this.arrowPanel.setBounds(100, 80, 120, 20);
        this.valB.setBColor(new Color(204, 204, 204));
        this.valB.setFColor(new Color(255, 0, 0));
        this.add(this.valB);
        this.valB.setBounds(100, 10, 120, 50);
    }

    private void butCheckActionPerformed(ActionEvent evt) {
        try {
            String[] str;
            String s = this.txtValA.getText();
            s = s.replace(',', '.');
            if (s.matches(" *[+,-]?[0-9]+(.[0-9]+)? */ *[+,-]?[0-9]+(.[0-9]+)? *")) {
                str = s.split("/");
                this.equation.setA(new Double(str[0]) / new Double(str[1]));
            } else {
                this.equation.setA(new Double(s));
            }
            this.txtValA.setText(s);
            s = this.valB.getText();
            s = s.replace(',', '.');
            if (s.matches(" *[+,-]?[0-9]+(.[0-9]+)? */ *[+,-]?[0-9]+(.[0-9]+)? *")) {
                str = s.split("/");
                this.equation.setB(new Double(str[0]) / new Double(str[1]));
            } else {
                this.equation.setB(new Double(s));
            }
            this.valB.setText(s);
            s = this.txtValResult.getText();
            s = s.replace(',', '.');
            if (s.matches(" *[+,-]?[0-9]+(.[0-9]+)? */ *[+,-]?[0-9]+(.[0-9]+)? *")) {
                str = s.split("/");
                this.equation.setR(new Double(str[0]) / new Double(str[1]));
            } else {
                this.equation.setR(new Double(s));
            }
            this.txtValResult.setText(s);
            this.applet.showCheckMessage(this.equation.isCorrect(this.operation));
        }
        catch (NumberFormatException e) {
            this.applet.showMessage("\u039b\u03ac\u03b8\u03bf\u03c2 \u03b1\u03c1\u03b9\u03b8\u03bc\u03bf\u03af");
        }
        this.applet.incCounter();
    }

    private void butDivStateChanged(ChangeEvent evt) {
        if (this.butDiv.isSelected()) {
            this.operation = (byte)4;
        }
    }

    private void butMulStateChanged(ChangeEvent evt) {
        if (this.butMul.isSelected()) {
            this.operation = (byte)3;
        }
    }

    private void butSubStateChanged(ChangeEvent evt) {
        if (this.butSub.isSelected()) {
            this.operation = (byte)2;
        }
    }

    private void butAddStateChanged(ChangeEvent evt) {
        if (this.butAdd.isSelected()) {
            this.operation = 1;
        }
    }
}

