/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JComponent;

public class TextIcon
extends JComponent
implements Icon {
    protected int yGap = 5;
    protected Font defaultFont = new Font("Tahoma", 1, 12);
    protected String[] lines;
    protected FontMetrics metrics;
    protected boolean leftJustify;
    protected boolean shadow;
    protected Color color = Color.black;

    public TextIcon(String[] stringArray) {
        this(stringArray, null, false, null, false);
    }

    public TextIcon(String[] stringArray, Font font) {
        this(stringArray, font, false, null, false);
    }

    public TextIcon(String[] stringArray, boolean bl) {
        this(stringArray, null, bl, null, false);
    }

    public TextIcon(String[] stringArray, boolean bl, boolean bl2) {
        this(stringArray, null, bl, null, bl2);
    }

    public TextIcon(String[] stringArray, boolean bl, Color color) {
        this(stringArray, null, bl, color, false);
    }

    public TextIcon(String[] stringArray, Font font, boolean bl, Color color, boolean bl2) {
        if (font != null) {
            this.defaultFont = font;
        }
        if (color != null) {
            this.color = color;
        }
        int n = stringArray.length;
        this.lines = new String[n];
        for (int i = 0; i < n; ++i) {
            this.lines[i] = stringArray[i];
        }
        this.leftJustify = bl;
        this.shadow = bl2;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3 = this.getIconHeight();
        int n4 = this.getIconWidth();
        graphics.setFont(this.defaultFont);
        for (int i = 0; i < this.lines.length; ++i) {
            this.metrics = graphics.getFontMetrics();
            int n5 = n2 + this.metrics.getHeight();
            int n6 = this.metrics.getHeight();
            int n7 = this.metrics.stringWidth(this.lines[i]);
            int n8 = this.leftJustify ? 10 : n + (n4 - n7) / 2;
            int n9 = n5 + n6 * i;
            if (this.shadow) {
                graphics.setColor(Color.gray);
                graphics.drawString(this.lines[i], n8 + 1, n9 + 1);
            }
            graphics.setColor(this.color);
            graphics.drawString(this.lines[i], n8, n9);
        }
    }

    public int getIconWidth() {
        int n = 0;
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.defaultFont);
        for (int i = 0; i < this.lines.length; ++i) {
            n = Math.max(n, fontMetrics.stringWidth(this.lines[i]));
        }
        return n;
    }

    public int getIconHeight() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.defaultFont);
        return (fontMetrics.getHeight() + this.yGap) * this.lines.length;
    }

    public void setText(String[] stringArray) {
        int n = stringArray.length;
        this.lines = new String[n];
        for (int i = 0; i < n; ++i) {
            this.lines[i] = stringArray[i];
        }
    }

    public String[] getText() {
        return this.lines;
    }
}

