/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa;

import com.singularsys.aa.EquationParser;
import com.singularsys.aa.Expression;
import com.singularsys.aa.ExpressionPrinterVisitor;
import com.singularsys.aa.Solution;
import com.singularsys.aa.SystemSolver;
import com.singularsys.aa.UntypifiedExpr;
import com.singularsys.aa.logging.Logger;
import com.singularsys.aa.manipulation.Canonizer;
import com.singularsys.aa.manipulation.Simplifier;
import com.singularsys.aa.manipulation.Sorter;
import com.singularsys.aa.manipulation.Substituter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.nfunk.jep.Node;

public class EquationSystem {
    private Vector equations = new Vector();
    private static final boolean debug = false;
    private Vector allVars = new Vector();

    public void addEquation(String string) throws Exception {
        UntypifiedExpr untypifiedExpr = EquationParser.getExpression(string);
        this.addEquation(untypifiedExpr);
    }

    public void addEquation(Expression expression) {
        this.equations.addElement(expression);
        this.addVariables(expression);
    }

    public Expression getEquation(int n) {
        if (n >= 0 && n < this.equations.size()) {
            return (Expression)this.equations.elementAt(n);
        }
        return null;
    }

    public int getNumEquations() {
        return this.equations.size();
    }

    public Solution solve() throws Exception {
        return new SystemSolver().solve(this);
    }

    public void simplify() {
        Simplifier simplifier = new Simplifier();
        Sorter sorter = new Sorter();
        Canonizer canonizer = new Canonizer();
        ExpressionPrinterVisitor expressionPrinterVisitor = new ExpressionPrinterVisitor();
        for (int i = 0; i < this.equations.size(); ++i) {
            UntypifiedExpr untypifiedExpr = (UntypifiedExpr)this.equations.elementAt(i);
            try {
                Node node = simplifier.simplify(untypifiedExpr.getTopNode());
                sorter.sortTree(node);
                node = canonizer.canonize(node);
                Logger.println("After canonize:      " + expressionPrinterVisitor.getString(node));
                untypifiedExpr.setTopNode(node);
                continue;
            }
            catch (Exception exception) {
                Logger.print(exception.toString());
            }
        }
    }

    private void addVariables(Expression expression) {
        Vector vector = expression.getVariables();
        for (int i = 0; i < vector.size(); ++i) {
            if (this.allVars.contains(vector.elementAt(i))) continue;
            this.allVars.addElement(vector.elementAt(i));
        }
    }

    public Vector getVariables() {
        return this.allVars;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.equations.size(); ++i) {
            if (i > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(((Expression)this.equations.elementAt(i)).toString());
        }
        return stringBuffer.toString();
    }

    public Object[] getValues(Hashtable hashtable) throws Exception {
        Object[] objectArray = new Object[this.equations.size()];
        for (int i = 0; i < this.equations.size(); ++i) {
            Expression expression = (Expression)this.equations.elementAt(i);
            objectArray[i] = expression.getValue(hashtable);
        }
        return objectArray;
    }

    public EquationSystem removeSubset(int[] nArray) {
        int n;
        EquationSystem equationSystem = new EquationSystem();
        for (n = 0; n < nArray.length; ++n) {
            equationSystem.addEquation(this.getEquation(nArray[n]));
        }
        for (n = 0; n < equationSystem.getNumEquations(); ++n) {
            this.equations.removeElement(equationSystem.getEquation(n));
        }
        return equationSystem;
    }

    public void substitute(Solution solution) {
        Substituter substituter = new Substituter();
        Enumeration enumeration = solution.getVariableNames();
        Enumeration enumeration2 = solution.getValues();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object e = enumeration2.nextElement();
            this.allVars.removeElement(string);
            for (int i = 0; i < this.equations.size(); ++i) {
                ((UntypifiedExpr)this.getEquation(i)).substitute(string, e, substituter);
            }
        }
    }
}

