/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa;

import com.singularsys.aa.EquationSystem;
import com.singularsys.aa.Solution;
import com.singularsys.aa.SolverListener;
import com.singularsys.aa.ThreadControl;
import com.singularsys.aa.logging.LogWriter;
import com.singularsys.aa.logging.Logger;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class SolverThread
extends Thread {
    private final String eqText;
    private final SolverListener listener;
    private final int threadIndex;
    private final LogWriter logWriter;
    private final StringWriter sw;
    private String errorText;
    private Solution solSet;

    public SolverThread(String string, SolverListener solverListener, String string2, int n) {
        super(string);
        this.eqText = string2;
        this.listener = solverListener;
        this.threadIndex = n;
        this.sw = new StringWriter();
        this.logWriter = new LogWriter(this.sw);
        this.solSet = null;
        this.errorText = "";
    }

    public void run() {
        Object object;
        Date date = new Date();
        Date date2 = null;
        Date date3 = null;
        try {
            object = this.parseInput(this.eqText);
            date2 = new Date();
            if (object != null) {
                this.solSet = ((EquationSystem)object).solve();
            }
            if (this.solSet == null) {
                throw new Exception("solSet is null");
            }
        }
        catch (Exception exception) {
            this.errorText = exception.getMessage();
        }
        Logger.setLogLevel(0);
        date3 = new Date();
        object = new DecimalFormat("#0.000");
        if (date2 != null) {
            Logger.println("Time to parse (sec): " + ((NumberFormat)object).format(this.getSecBetween(date, date2)));
            Logger.println("Time to solve (sec): " + ((NumberFormat)object).format(this.getSecBetween(date2, date3)));
        }
        Logger.println("Total (sec):         " + ((NumberFormat)object).format(this.getSecBetween(date, date3)));
        if (!ThreadControl.mustStop(this.threadIndex)) {
            this.listener.updateSolution(this.solSet, this.errorText, this.sw.toString());
        }
        ThreadControl.notifyTerminated(this.threadIndex);
    }

    private EquationSystem parseInput(String string) throws Exception {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        EquationSystem equationSystem = new EquationSystem();
        boolean bl = false;
        int n = 1;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n2 = string3.indexOf(61);
            if (n2 == -1 || string3.indexOf(61, n2 + 1) != -1) continue;
            try {
                equationSystem.addEquation(string3);
            }
            catch (Exception exception) {
                bl = true;
                string2 = string2 + exception.getMessage() + " in equation " + n + "\n";
            }
            ++n;
        }
        if (bl) {
            throw new Exception(string2);
        }
        return equationSystem;
    }

    public int getThreadIndex() {
        return this.threadIndex;
    }

    public LogWriter getLogWriter() {
        return this.logWriter;
    }

    private float getSecBetween(Date date, Date date2) {
        return (float)(date2.getTime() - date.getTime()) / 1000.0f;
    }
}

