/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa;

import com.singularsys.aa.SolverListener;
import com.singularsys.aa.SolverThread;

public class ThreadControl {
    private static ThreadControl instance = null;
    private static int currentThread = 0;
    private static final int MAX_THREADS = 128;
    private static final int MAX_INDEX = 127;
    private static boolean[] isRunning = new boolean[128];

    public ThreadControl() {
        for (int i = 0; i < 128; ++i) {
            ThreadControl.isRunning[i] = false;
        }
    }

    public static synchronized ThreadControl getInstance() {
        if (instance == null) {
            instance = new ThreadControl();
        }
        return instance;
    }

    public static synchronized void startNewThread(SolverListener solverListener, String string) throws Exception {
        int n = 0;
        ThreadControl.getInstance();
        do {
            if (++currentThread > 127) {
                currentThread = 0;
            }
            if (n++ <= 127) continue;
            throw new Exception("Failed to start new thread");
        } while (isRunning[currentThread]);
        ThreadControl.isRunning[ThreadControl.currentThread] = true;
        SolverThread solverThread = new SolverThread("ST-" + currentThread, solverListener, string, currentThread);
        solverThread.start();
    }

    public static boolean mustStop(int n) {
        return n != currentThread;
    }

    public static void mustStop() throws Exception {
        SolverThread solverThread;
        int n;
        if (Thread.currentThread() instanceof SolverThread && ThreadControl.mustStop(n = (solverThread = (SolverThread)Thread.currentThread()).getThreadIndex())) {
            throw new Exception(solverThread.getName() + " must stop. So it's stopping.");
        }
    }

    public static synchronized void notifyTerminated(int n) {
        ThreadControl.getInstance();
        if (!isRunning[n]) {
            System.out.println("ThreadControl.notifyTerminated() runningArray[] error");
        }
        ThreadControl.isRunning[n] = false;
    }

    private static void printIsRunning() {
        for (int i = 0; i < 127; ++i) {
            System.out.print(isRunning[i] ? "R" : ".");
        }
        System.out.println();
    }
}

