/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa.newton;

import Jama.Matrix;
import com.singularsys.aa.EquationSystem;
import com.singularsys.aa.Solution;
import com.singularsys.aa.ThreadControl;
import com.singularsys.aa.logging.Logger;
import java.io.PrintWriter;
import java.util.Hashtable;

public class NewtonSolver {
    private static final double initialGuess = 1.0E-8;
    private static final double TOLX = 1.0E-15;
    private static final double TOLF = 1.0E-15;
    private static final int NTRIALS = 100;
    private Hashtable varValues = new Hashtable();
    private String[] varNames;

    public Solution solveSystem(EquationSystem equationSystem) throws Exception {
        int n;
        int n2 = equationSystem.getNumEquations();
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = 1.0E-8;
        }
        this.varNames = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.varNames[n] = (String)equationSystem.getVariables().elementAt(n);
        }
        this.mnewt(100, dArray, n2, 1.0E-15, 1.0E-15, equationSystem);
        Solution solution = new Solution();
        for (int i = 0; i < n2; ++i) {
            Logger.println(this.varNames[i] + " = " + dArray[i]);
            solution.addSolution(this.varNames[i], new Double(dArray[i]));
        }
        return solution;
    }

    private void mnewt(int n, double[] dArray, int n2, double d, double d2, EquationSystem equationSystem) throws Exception {
        int n3;
        Matrix matrix = new Matrix(n2, 1);
        double[] dArray2 = new double[n2];
        Matrix matrix2 = new Matrix(n2, n2);
        for (n3 = 0; n3 < n; ++n3) {
            int n4;
            Logger.println("Trial #" + n3);
            this.usrfun(dArray, n2, dArray2, matrix2, equationSystem);
            Logger.println("Jacobian Matrix");
            matrix2.print((PrintWriter)Logger.getLogWriter(), 3, 1);
            double d3 = 0.0;
            for (n4 = 0; n4 < n2; ++n4) {
                d3 += Math.abs(dArray2[n4]);
            }
            if (d3 <= d2) break;
            for (n4 = 0; n4 < n2; ++n4) {
                matrix.set(n4, 0, -dArray2[n4]);
            }
            try {
                Matrix matrix3;
                matrix = matrix3 = matrix2.solve(matrix);
            }
            catch (Exception exception) {
                Logger.println(exception.toString());
            }
            double d4 = 0.0;
            Logger.println("-- Current Solution:");
            for (n4 = 0; n4 < n2; ++n4) {
                d4 += Math.abs(matrix.get(n4, 0));
                int n5 = n4;
                dArray[n5] = dArray[n5] + matrix.get(n4, 0);
                Logger.println("     " + this.varNames[n4] + " = " + dArray[n4]);
            }
            Logger.println("--");
            if (d4 <= d) break;
            ThreadControl.mustStop();
        }
        if (n3 == n) {
            throw new Exception("Maximum number of iterations reached");
        }
        Logger.println("Number of iterations required: " + n3);
    }

    private void usrfun(double[] dArray, int n, double[] dArray2, Matrix matrix, EquationSystem equationSystem) throws Exception {
        this.findValues(n, dArray, dArray2, equationSystem);
        this.fdJacobian(n, dArray, dArray2, matrix, equationSystem);
    }

    private void fdJacobian(int n, double[] dArray, double[] dArray2, Matrix matrix, EquationSystem equationSystem) throws Exception {
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            double d2 = 1.0E-4 * Math.abs(d);
            if (d2 == 0.0) {
                d2 = 1.0E-4;
            }
            dArray[i] = d + d2;
            d2 = dArray[i] - d;
            this.findValues(n, dArray, dArray3, equationSystem);
            dArray[i] = d;
            for (int j = 0; j < n; ++j) {
                matrix.set(j, i, (dArray3[j] - dArray2[j]) / d2);
            }
        }
    }

    private void findValues(int n, double[] dArray, double[] dArray2, EquationSystem equationSystem) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.varValues.put(this.varNames[i], new Double(dArray[i]));
        }
        Object[] objectArray = equationSystem.getValues(this.varValues);
        for (int i = 0; i < n; ++i) {
            if (!(objectArray[i] instanceof Double)) {
                throw new Exception("Equation " + i + " did not evaluate to a double value");
            }
            dArray2[i] = (Double)objectArray[i];
        }
    }
}

