/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa.polynomial;

import com.singularsys.aa.SimpleExpr;
import com.singularsys.aa.polynomial.PolySimplifier;
import com.singularsys.aa.polynomial.PolynomialTerm;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PolynomialExpr
extends SimpleExpr {
    private int nVar;
    private Vector terms;
    private PolynomialTerm curTerm;

    public PolynomialExpr(Vector vector) {
        this.variables = vector;
        this.nVar = this.variables.size();
        this.terms = new Vector();
    }

    public void makeNewTerm() {
        this.curTerm = new PolynomialTerm(this.nVar);
        this.terms.addElement(this.curTerm);
    }

    public void multiplyCoefficientWith(double d) {
        double d2 = (Double)this.curTerm.getCoefficient();
        if (this.curTerm != null) {
            this.curTerm.setCoefficient(new Double(d2 * d));
        }
    }

    public void addToExponent(String string, double d) {
        int n = this.variables.indexOf(string);
        double d2 = (Double)this.curTerm.getExponent(n);
        if (this.curTerm != null) {
            this.curTerm.setExponent(n, new Double(d2 + d));
        }
    }

    public String toString() {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.terms.elements();
        while (enumeration.hasMoreElements()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\n");
            }
            PolynomialTerm polynomialTerm = (PolynomialTerm)enumeration.nextElement();
            stringBuffer.append(polynomialTerm.getCoefficient() + " | ");
            for (int i = 0; i < this.nVar; ++i) {
                stringBuffer.append(" " + polynomialTerm.getExponent(i));
            }
        }
        return stringBuffer.toString();
    }

    public Vector getTerms() {
        return this.terms;
    }

    public void simplify() {
        PolySimplifier.simplify(this);
    }

    public Object getValue(Hashtable hashtable) {
        double d = 0.0;
        for (int i = 0; i < this.terms.size(); ++i) {
            PolynomialTerm polynomialTerm = (PolynomialTerm)this.terms.elementAt(i);
            d += polynomialTerm.getValue(this.variables, hashtable);
        }
        return new Double(d);
    }
}

