/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa.testing;

import com.singularsys.aa.EquationSystem;
import com.singularsys.aa.Expression;
import com.singularsys.aa.Solution;
import com.singularsys.aa.SystemSolver;
import com.singularsys.aa.logging.Logger;
import java.util.Vector;

public class Subdivision {
    public static void main(String[] stringArray) {
        boolean[][] blArrayArray = new boolean[][]{{false, true, false, false}, {true, true, false, true}, {false, false, true, true}, {false, false, true, true}};
        Subdivision.subdivide(blArrayArray);
    }

    public static Solution solveWithDividing(SystemSolver systemSolver, EquationSystem equationSystem) throws Exception {
        int[] nArray;
        Solution solution = new Solution();
        boolean[][] blArray = Subdivision.getVarMatrix(equationSystem);
        Subdivision.printVarMatrix(blArray);
        for (int i = blArray.length; i > 0; i -= nArray.length) {
            nArray = Subdivision.findSmallestSubset(blArray);
            Logger.print("Solving equations in rows: ");
            Subdivision.printArray(nArray);
            Logger.println();
            EquationSystem equationSystem2 = equationSystem.removeSubset(nArray);
            solution.append(systemSolver.solveNoSubdivision(equationSystem2));
            equationSystem.substitute(solution);
            blArray = Subdivision.elimVarsAndEq(blArray, nArray);
            Subdivision.printVarMatrix(blArray);
        }
        return solution;
    }

    private static boolean[][] getVarMatrix(EquationSystem equationSystem) throws Exception {
        Vector vector = equationSystem.getVariables();
        int n = equationSystem.getNumEquations();
        if (vector.size() != n) {
            throw new Exception("getVarMatrix(): Number of equations and unknowns not equal.");
        }
        boolean[][] blArray = new boolean[n][n];
        for (int i = 0; i < n; ++i) {
            int n2;
            Expression expression = equationSystem.getEquation(i);
            Vector vector2 = expression.getVariables();
            int n3 = vector2.size();
            for (n2 = 0; n2 < n; ++n2) {
                blArray[i][n2] = false;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                blArray[i][vector.indexOf(vector2.elementAt((int)n2))] = true;
            }
        }
        return blArray;
    }

    private static void subdivide(boolean[][] blArray) {
        int[] nArray;
        Subdivision.printVarMatrix(blArray);
        for (int i = blArray.length; i > 0; i -= nArray.length) {
            nArray = Subdivision.findSmallestSubset(blArray);
            Logger.print("Solving equations in rows: ");
            Subdivision.printArray(nArray);
            Logger.println();
            blArray = Subdivision.elimVarsAndEq(blArray, nArray);
            Subdivision.printVarMatrix(blArray);
        }
    }

    private static int[] findSmallestSubset(boolean[][] blArray) {
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                int[] nArray = Subdivision.findRows(i + 1, blArray);
                return nArray;
            }
            catch (Exception exception) {
                Logger.println(exception.toString());
                continue;
            }
        }
        return null;
    }

    private static int[] findRows(int n, boolean[][] blArray) throws Exception {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        do {
            if (Subdivision.countVars(blArray, nArray) != n) continue;
            return nArray;
        } while (Subdivision.nextSubset(nArray, n - 1, blArray.length - 1));
        throw new Exception("No valid row combination found for nRows = " + n);
    }

    private static boolean nextSubset(int[] nArray, int n, int n2) {
        if (nArray[n] == n2) {
            if (n == 0) {
                return false;
            }
            return Subdivision.nextSubset(nArray, n - 1, n2 - 1);
        }
        int n3 = n;
        nArray[n3] = nArray[n3] + 1;
        return true;
    }

    private static int countVars(boolean[][] blArray, int[] nArray) {
        int n = 0;
        block0: for (int i = 0; i < blArray.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                if (!blArray[nArray[j]][i]) continue;
                ++n;
                continue block0;
            }
        }
        return n;
    }

    private static boolean[][] elimVarsAndEq(boolean[][] blArray, int[] nArray) {
        int n = blArray.length;
        int n2 = n - nArray.length;
        boolean[][] blArray2 = new boolean[n2][n2];
        boolean[] blArray3 = Subdivision.getSkipVars(blArray, nArray);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            n5 = 0;
            if (i == nArray[n3]) {
                n3 = Math.min(n3 + 1, nArray.length - 1);
                continue;
            }
            for (int j = 0; j < n; ++j) {
                if (blArray3[j]) continue;
                blArray2[n4][n5] = blArray[i][j];
                ++n5;
            }
            ++n4;
        }
        return blArray2;
    }

    private static boolean[] getSkipVars(boolean[][] blArray, int[] nArray) {
        boolean[] blArray2 = new boolean[blArray.length];
        block0: for (int i = 0; i < blArray.length; ++i) {
            blArray2[i] = false;
            for (int j = 0; j < nArray.length; ++j) {
                if (!blArray[nArray[j]][i]) continue;
                blArray2[i] = true;
                continue block0;
            }
        }
        return blArray2;
    }

    private static void printArray(int[] nArray) {
        Logger.print("{");
        for (int i = 0; i < nArray.length; ++i) {
            Logger.print(" " + nArray[i]);
        }
        Logger.print("}");
    }

    private static void printVarMatrix(boolean[][] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            for (int j = 0; j < blArray[i].length; ++j) {
                Logger.print(blArray[i][j] ? " X" : " _");
            }
            Logger.println();
        }
    }
}

