/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.function.PostfixMathCommandI;

public class EvaluatorVisitor
implements ParserVisitor {
    private Stack stack = new Stack();
    private Vector errorList = null;
    private SymbolTable symTab = null;
    private static final boolean debug = false;

    private void addToErrorList(String string) {
        if (this.errorList != null) {
            this.errorList.addElement(string);
        }
    }

    public Object getValue(Node node, Vector vector, SymbolTable symbolTable) throws Exception {
        if (node == null) {
            throw new IllegalArgumentException("topNode parameter is null");
        }
        this.errorList = vector;
        this.symTab = symbolTable;
        this.stack.removeAllElements();
        node.jjtAccept(this, null);
        if (this.errorList != null && this.errorList.size() != 0) {
            throw new Exception("EvaluatorVisitor.getValue(): Error(s) during evaluation");
        }
        if (this.stack.size() != 1) {
            throw new Exception("EvaluatorVisitor.getValue(): Stack size is not 1");
        }
        return this.stack.pop();
    }

    public Object visit(SimpleNode simpleNode, Object object) {
        return object;
    }

    public Object visit(ASTStart aSTStart, Object object) {
        return object;
    }

    public Object visit(ASTFunNode aSTFunNode, Object object) {
        if (aSTFunNode == null) {
            return null;
        }
        object = aSTFunNode.childrenAccept(this, object);
        PostfixMathCommandI postfixMathCommandI = aSTFunNode.getPFMC();
        if (postfixMathCommandI == null) {
            this.addToErrorList("No function class associated with " + aSTFunNode.getName());
            return object;
        }
        if (postfixMathCommandI.getNumberOfParameters() == -1) {
            postfixMathCommandI.setCurNumberOfParameters(aSTFunNode.jjtGetNumChildren());
        }
        try {
            postfixMathCommandI.run(this.stack);
        }
        catch (ParseException parseException) {
            this.addToErrorList(parseException.getMessage());
        }
        return object;
    }

    public Object visit(ASTVarNode aSTVarNode, Object object) {
        String string = "Could not evaluate " + aSTVarNode.getName() + ": ";
        if (this.symTab == null) {
            string = string + "the symbol table is null";
            this.addToErrorList(string);
            return object;
        }
        Object v = this.symTab.get(aSTVarNode.getName());
        if (v == null) {
            string = string + "the variable was not found in the symbol table";
            this.addToErrorList(string);
        } else {
            this.stack.push(v);
        }
        return object;
    }

    public Object visit(ASTConstant aSTConstant, Object object) {
        this.stack.push(aSTConstant.getValue());
        return object;
    }
}

