/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Subtract
extends PostfixMathCommand {
    public Subtract() {
        this.numberOfParameters = 2;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e = stack.pop();
        Object e2 = stack.pop();
        stack.push(this.sub(e2, e));
    }

    public Object sub(Object object, Object object2) throws ParseException {
        if (object instanceof Number) {
            if (object2 instanceof Number) {
                return this.sub((Number)object, (Number)object2);
            }
            if (object2 instanceof Complex) {
                return this.sub((Number)object, (Complex)object2);
            }
        } else if (object instanceof Complex) {
            if (object2 instanceof Number) {
                return this.sub((Complex)object, (Number)object2);
            }
            if (object2 instanceof Complex) {
                return this.sub((Complex)object, (Complex)object2);
            }
        }
        throw new ParseException("Invalid parameter type");
    }

    public Double sub(Number number, Number number2) {
        return new Double(number.doubleValue() - number2.doubleValue());
    }

    public Complex sub(Complex complex, Complex complex2) {
        return new Complex(complex.re() - complex2.re(), complex.im() - complex2.im());
    }

    public Complex sub(Complex complex, Number number) {
        return new Complex(complex.re() - number.doubleValue(), complex.im());
    }

    public Complex sub(Number number, Complex complex) {
        return new Complex(number.doubleValue() - complex.re(), -complex.im());
    }
}

