/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.io.StringReader;
import java.util.Vector;
import org.nfunk.jep.EvaluatorVisitor;
import org.nfunk.jep.FunctionTable;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Parser;
import org.nfunk.jep.ParserDumpVisitor;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.function.Abs;
import org.nfunk.jep.function.Angle;
import org.nfunk.jep.function.ArcCosine;
import org.nfunk.jep.function.ArcCosineH;
import org.nfunk.jep.function.ArcSine;
import org.nfunk.jep.function.ArcSineH;
import org.nfunk.jep.function.ArcTanH;
import org.nfunk.jep.function.ArcTangent;
import org.nfunk.jep.function.Cosine;
import org.nfunk.jep.function.CosineH;
import org.nfunk.jep.function.Imaginary;
import org.nfunk.jep.function.Logarithm;
import org.nfunk.jep.function.Modulus;
import org.nfunk.jep.function.NaturalLogarithm;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.Random;
import org.nfunk.jep.function.Real;
import org.nfunk.jep.function.Sine;
import org.nfunk.jep.function.SineH;
import org.nfunk.jep.function.SquareRoot;
import org.nfunk.jep.function.Sum;
import org.nfunk.jep.function.TanH;
import org.nfunk.jep.function.Tangent;
import org.nfunk.jep.type.Complex;

public class JEP {
    private boolean debug = false;
    private boolean traverse = false;
    protected boolean allowUndeclared = false;
    protected boolean implicitMul = false;
    protected SymbolTable symTab;
    protected FunctionTable funTab;
    protected Vector errorList;
    private Parser parser;
    private Node topNode = null;
    private EvaluatorVisitor ev;

    public JEP() {
        this.initSymTab();
        this.initFunTab();
        this.errorList = new Vector();
        this.ev = new EvaluatorVisitor();
        this.parser = new Parser(new StringReader(""));
        this.parseExpression("");
    }

    public void initSymTab() {
        this.symTab = new SymbolTable();
    }

    public void initFunTab() {
        this.funTab = new FunctionTable();
    }

    public void addStandardFunctions() {
        this.funTab.put("sin", new Sine());
        this.funTab.put("cos", new Cosine());
        this.funTab.put("tan", new Tangent());
        this.funTab.put("asin", new ArcSine());
        this.funTab.put("acos", new ArcCosine());
        this.funTab.put("atan", new ArcTangent());
        this.funTab.put("sinh", new SineH());
        this.funTab.put("cosh", new CosineH());
        this.funTab.put("tanh", new TanH());
        this.funTab.put("asinh", new ArcSineH());
        this.funTab.put("acosh", new ArcCosineH());
        this.funTab.put("atanh", new ArcTanH());
        this.funTab.put("log", new Logarithm());
        this.funTab.put("ln", new NaturalLogarithm());
        this.funTab.put("sqrt", new SquareRoot());
        this.funTab.put("angle", new Angle());
        this.funTab.put("abs", new Abs());
        this.funTab.put("mod", new Modulus());
        this.funTab.put("sum", new Sum());
        this.funTab.put("rand", new Random());
    }

    public void addStandardConstants() {
        this.symTab.put("pi", new Double(Math.PI));
        this.symTab.put("e", new Double(Math.E));
    }

    public void addComplex() {
        this.symTab.put("i", new Complex(0.0, 1.0));
        this.funTab.put("re", new Real());
        this.funTab.put("im", new Imaginary());
    }

    public void addFunction(String string, PostfixMathCommandI postfixMathCommandI) {
        this.funTab.put(string, postfixMathCommandI);
    }

    public Double addVariable(String string, double d) {
        Double d2 = new Double(d);
        this.symTab.put(string, d2);
        return d2;
    }

    public Complex addComplexVariable(String string, double d, double d2) {
        Complex complex = new Complex(d, d2);
        this.symTab.put(string, complex);
        return complex;
    }

    public void addVariableAsObject(String string, Object object) {
        this.symTab.put(string, object);
    }

    public Object removeVariable(String string) {
        return this.symTab.remove(string);
    }

    public Object removeFunction(String string) {
        return this.funTab.remove(string);
    }

    public void setTraverse(boolean bl) {
        this.traverse = bl;
    }

    public void setImplicitMul(boolean bl) {
        this.implicitMul = bl;
    }

    public void setAllowUndeclared(boolean bl) {
        this.allowUndeclared = bl;
    }

    public void parseExpression(String string) {
        StringReader stringReader = new StringReader(string);
        try {
            this.errorList.removeAllElements();
            this.topNode = this.parser.parseStream(stringReader, this);
        }
        catch (Throwable throwable) {
            this.topNode = null;
            if (throwable instanceof ParseException) {
                this.errorList.addElement(((ParseException)throwable).getErrorInfo());
            }
            if (this.debug) {
                System.out.println(throwable.getMessage());
                throwable.printStackTrace();
            }
            this.errorList.addElement("Syntax error");
        }
        if (this.traverse && !this.hasError()) {
            ParserDumpVisitor parserDumpVisitor = new ParserDumpVisitor();
            this.topNode.jjtAccept(parserDumpVisitor, null);
        }
    }

    public double getValue() {
        Object object = this.getValueAsObject();
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Complex) {
            return ((Complex)object).re();
        }
        return 0.0;
    }

    public Complex getComplexValue() {
        Object object = this.getValueAsObject();
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return new Complex((Double)object, 0.0);
        }
        if (object instanceof Complex) {
            return (Complex)object;
        }
        return null;
    }

    public Object getValueAsObject() {
        if (this.topNode != null && !this.hasError()) {
            Object object;
            try {
                object = this.ev.getValue(this.topNode, this.errorList, this.symTab);
            }
            catch (Exception exception) {
                if (this.debug) {
                    System.out.println(exception);
                }
                return null;
            }
            return object;
        }
        return null;
    }

    public boolean hasError() {
        return !this.errorList.isEmpty();
    }

    public String getErrorInfo() {
        if (this.hasError()) {
            String string = "";
            int n = 0;
            while (n < this.errorList.size()) {
                string = string + this.errorList.elementAt(n) + "\n";
                ++n;
            }
            return string;
        }
        return null;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public SymbolTable getSymbolTable() {
        return this.symTab;
    }
}

