/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Power
extends PostfixMathCommand {
    public Power() {
        this.numberOfParameters = 2;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e = stack.pop();
        Object e2 = stack.pop();
        stack.push(this.power(e2, e));
    }

    public Object power(Object object, Object object2) throws ParseException {
        if (object instanceof Double) {
            if (object2 instanceof Double) {
                return this.power((Double)object, (Double)object2);
            }
            if (object2 instanceof Complex) {
                return this.power((Double)object, (Complex)object2);
            }
        } else if (object instanceof Complex) {
            if (object2 instanceof Double) {
                return this.power((Complex)object, (Double)object2);
            }
            if (object2 instanceof Complex) {
                return this.power((Complex)object, (Complex)object2);
            }
        }
        throw new ParseException("Invalid parameter type");
    }

    public Object power(Double d, Double d2) {
        if (d < 0.0 && d2 != (double)d2.intValue()) {
            Complex complex = new Complex(d, 0.0);
            return complex.power(d2);
        }
        return new Double(Math.pow(d, d2));
    }

    public Object power(Complex complex, Complex complex2) {
        Complex complex3 = complex.power(complex2);
        if (complex3.im() == 0.0) {
            return new Double(complex3.re());
        }
        return complex3;
    }

    public Object power(Complex complex, Double d) {
        Complex complex2 = complex.power(d);
        if (complex2.im() == 0.0) {
            return new Double(complex2.re());
        }
        return complex2;
    }

    public Object power(Double d, Complex complex) {
        Complex complex2 = new Complex(d, 0.0);
        Complex complex3 = complex2.power(complex);
        if (complex3.im() == 0.0) {
            return new Double(complex3.re());
        }
        return complex3;
    }
}

