/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JPanel;

class MainPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    Color[] bar_colors = new Color[10];
    int VisibleBar = 10;
    int selectedBar = 0;
    int maxWidth = this.getWidth();
    int maxHeight = this.getHeight();
    int[][] bars = new int[10][5];
    Vector selSections;
    boolean showNum = true;
    boolean split_line_selected = false;
    int split_line_x = 0;

    public MainPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        int i = 0;
        while (i < 10) {
            this.bars[i][0] = 40;
            this.bars[i][1] = i == 0 ? 20 : this.bars[i - 1][1] + 40;
            this.bars[i][2] = 450;
            this.bars[i][3] = 20;
            this.bars[i][4] = 0;
            ++i;
        }
        this.bar_colors[0] = Color.magenta;
        this.bar_colors[1] = Color.green;
        this.bar_colors[2] = new Color(255, 51, 51);
        this.bar_colors[3] = new Color(179, 126, 244);
        this.bar_colors[4] = new Color(153, 153, 0);
        this.bar_colors[5] = new Color(153, 153, 153);
        this.bar_colors[6] = Color.cyan;
        this.bar_colors[7] = new Color(113, 147, 86);
        this.bar_colors[8] = new Color(153, 0, 51);
        this.bar_colors[9] = new Color(102, 0, 102);
        this.selSections = new Vector();
        this.setBackground(new Color(102, 102, 255));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int i = 0;
        while (i < this.VisibleBar) {
            g.setColor(Color.yellow);
            g.fillRect(this.bars[i][0], this.bars[i][1], this.bars[i][2], this.bars[i][3]);
            g.setColor(Color.black);
            g.drawRect(this.bars[i][0], this.bars[i][1], this.bars[i][2], this.bars[i][3]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.VisibleBar) {
            g.drawOval(this.bars[i2][0] - 20, this.bars[i2][1] + 5, 10, 10);
            ++i2;
        }
        g.setColor(Color.red);
        g.fillOval(this.bars[this.selectedBar][0] - 20, this.bars[this.selectedBar][1] + 5, 10, 10);
        g.setColor(Color.black);
        g.drawRect(this.bars[this.selectedBar][0] - 5, this.bars[this.selectedBar][1] - 5, this.bars[this.selectedBar][2] + 10, this.bars[this.selectedBar][3] + 10);
        int i3 = 0;
        while (i3 < this.selSections.size()) {
            int[] s = (int[])this.selSections.get(i3);
            if (this.VisibleBar > s[0]) {
                g.setColor(this.bar_colors[s[2]]);
                g.fillRect(s[3], s[4], s[5], s[6]);
            }
            ++i3;
        }
        g.setColor(Color.black);
        int i4 = 0;
        while (i4 < this.VisibleBar) {
            int j = 0;
            while (j < this.bars[i4][4]) {
                g.drawLine(this.bars[i4][0] + j * this.bars[i4][2] / this.bars[i4][4], this.bars[i4][1], this.bars[i4][0] + j * this.bars[i4][2] / this.bars[i4][4], this.bars[i4][1] + this.bars[i4][3]);
                ++j;
            }
            ++i4;
        }
        if (this.showNum) {
            g.setColor(Color.white);
            g.setFont(new Font("Dialog", 1, 12));
            int i5 = 0;
            while (i5 < this.VisibleBar) {
                int counter = 0;
                int j = 0;
                while (j < this.selSections.size()) {
                    int[] s = (int[])this.selSections.get(j);
                    if (s[0] == i5) {
                        ++counter;
                    }
                    ++j;
                }
                if (this.bars[i5][4] > 0) {
                    g.drawString(String.valueOf(counter) + " / " + String.valueOf(this.bars[i5][4]), 500, this.bars[i5][1] + 15);
                }
                ++i5;
            }
        }
        if (this.split_line_selected) {
            g.setColor(Color.black);
            g.drawLine(this.split_line_x, 0, this.split_line_x, 400);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        int i = 0;
        while (i < this.VisibleBar) {
            if (x > this.bars[i][0] - 20 && x < this.bars[i][0] - 20 + 10 && y > this.bars[i][1] + 5 && y < this.bars[i][1] + 5 + 10) {
                this.selectedBar = i;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.VisibleBar) {
            int j = 0;
            while (j < this.bars[i2][4]) {
                if (x > this.bars[i2][0] + j * this.bars[i2][2] / this.bars[i2][4] + 4 && x < this.bars[i2][0] + (j + 1) * this.bars[i2][2] / this.bars[i2][4] - 4 && y > this.bars[i2][1] && y < this.bars[i2][1] + this.bars[i2][3]) {
                    int[] s;
                    boolean found = false;
                    int k = 0;
                    while (k < this.selSections.size()) {
                        s = (int[])this.selSections.get(k);
                        if (s[0] == i2 && s[1] == j) {
                            this.selSections.removeElementAt(k);
                            found = true;
                        }
                        ++k;
                    }
                    if (!found) {
                        s = new int[]{i2, j, i2, this.bars[i2][0] + j * this.bars[i2][2] / this.bars[i2][4], this.bars[i2][1] + 1, this.bars[i2][2] / this.bars[i2][4] + 1, this.bars[i2][3] - 1};
                        this.selSections.add(s);
                    }
                }
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.VisibleBar) {
            int j = 0;
            while (j < this.bars[i3][4]) {
                if (x > this.bars[i3][0] + j * this.bars[i3][2] / this.bars[i3][4] - 4 && x < this.bars[i3][0] + j * this.bars[i3][2] / this.bars[i3][4] + 4 && y > this.bars[i3][1] && y < this.bars[i3][1] + this.bars[i3][3]) {
                    this.split_line_selected = true;
                    this.split_line_x = this.bars[i3][0] + j * this.bars[i3][2] / this.bars[i3][4];
                }
                ++j;
            }
            ++i3;
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.split_line_selected = false;
        this.split_line_x = 0;
        this.repaint();
    }

    public void setVisibleNum(int num) {
        this.VisibleBar = num;
        this.repaint();
    }

    public void incVisibleNum() {
        if (this.VisibleBar < 10) {
            ++this.VisibleBar;
        }
        this.repaint();
    }

    public void decVisibleNum() {
        if (this.VisibleBar > 1) {
            --this.VisibleBar;
        }
        if (this.selectedBar >= this.VisibleBar) {
            --this.selectedBar;
        }
        this.repaint();
    }

    public void setBarSections(int num) {
        this.bars[this.selectedBar][4] = num;
        int i = 0;
        while (i < this.selSections.size()) {
            int[] s = (int[])this.selSections.get(i);
            if (s[0] == this.selectedBar) {
                this.selSections.removeElementAt(i);
                --i;
            }
            ++i;
        }
        this.repaint();
    }

    public void resetBars() {
        int i = 0;
        while (i < this.bars.length) {
            this.bars[i][4] = 0;
            ++i;
        }
        this.selSections.removeAllElements();
        this.selectedBar = 0;
        this.repaint();
    }

    public void setShowNum(boolean show) {
        this.showNum = show;
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        int i = 0;
        while (i < this.VisibleBar) {
            int j = 0;
            while (j < this.bars[i][4]) {
                if (x > this.bars[i][0] + j * this.bars[i][2] / this.bars[i][4] - 4 && x < this.bars[i][0] + j * this.bars[i][2] / this.bars[i][4] + 4 && y > this.bars[i][1] && y < this.bars[i][1] + this.bars[i][3]) {
                    this.setCursor(new Cursor(12));
                    return;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.VisibleBar) {
            if (x > this.bars[i2][0] - 20 && x < this.bars[i2][0] - 20 + 10 && y > this.bars[i2][1] + 5 && y < this.bars[i2][1] + 5 + 10) {
                this.setCursor(new Cursor(12));
                return;
            }
            ++i2;
        }
        this.setCursor(new Cursor(0));
    }
}

