/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class ScalesPanel
extends JPanel {
    private static final BasicStroke stroke = new BasicStroke(4.0f, 1, 1);
    private static final int MARGIN = 50;
    private static final int BOXWIDTH = 180;
    private static final int BOXHEIGHT = 150;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int NONE = 3;

    public ScalesPanel() {
        this.setLayout(null);
        this.setBorder(new BevelBorder(0));
        SidePanel sidePanel = new SidePanel();
        SidePanel sidePanel2 = new SidePanel();
        this.add(sidePanel);
        this.add(sidePanel2);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ScalesPanel.this.rearrangeSides();
            }
        });
        sidePanel.addContainerListener(new ContainerAdapter(){

            public void componentAdded(ContainerEvent containerEvent) {
                ScalesPanel.this.rearrangeSides();
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                ScalesPanel.this.rearrangeSides();
            }
        });
        sidePanel2.addContainerListener(new ContainerAdapter(){

            public void componentAdded(ContainerEvent containerEvent) {
                ScalesPanel.this.rearrangeSides();
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                ScalesPanel.this.rearrangeSides();
            }
        });
    }

    public void rearrangeSides() {
        if (this.getComponentCount() != 2) {
            return;
        }
        int n = this.getLean();
        SidePanel sidePanel = (SidePanel)this.getComponent(0);
        SidePanel sidePanel2 = (SidePanel)this.getComponent(1);
        if (n == 1) {
            sidePanel.setBounds(50, this.getHeight() - 50 - 150, 180, 150);
            sidePanel2.setBounds(this.getWidth() - 50 - 180, 50, 180, 150);
        } else if (n == 2) {
            sidePanel.setBounds(50, 50, 180, 150);
            sidePanel2.setBounds(this.getWidth() - 50 - 180, this.getHeight() - 50 - 150, 180, 150);
        } else {
            sidePanel.setBounds(50, (this.getHeight() - 150) / 2, 180, 150);
            sidePanel2.setBounds(this.getWidth() - 50 - 180, (this.getHeight() - 150) / 2, 180, 150);
        }
        this.repaint();
    }

    public int getLean() {
        float f = ((SidePanel)this.getComponent(0)).getWeight();
        float f2 = ((SidePanel)this.getComponent(1)).getWeight();
        System.out.println(f + " -- " + f2);
        if (f > f2) {
            return 1;
        }
        if (f < f2) {
            return 2;
        }
        return 3;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(stroke);
        if (this.getComponentCount() != 2) {
            return;
        }
        int n = this.getComponent((int)0).getLocation().y + this.getComponent(0).getHeight();
        int n2 = this.getComponent((int)1).getLocation().y + this.getComponent(1).getHeight();
        int n3 = this.getComponent((int)0).getLocation().x + this.getComponent(0).getWidth() / 2;
        int n4 = this.getComponent((int)1).getLocation().x + this.getComponent(1).getWidth() / 2;
        graphics2D.drawLine(n3, n + 20, n4, n2 + 20);
        graphics2D.drawLine(n3, n + 20, n3, n);
        graphics2D.drawLine(n4, n2 + 20, n4, n2);
        int[] nArray = new int[]{this.getWidth() / 2 - 30, this.getWidth() / 2, this.getWidth() / 2 + 30};
        int[] nArray2 = new int[]{this.getHeight() - 25, (n + 20 + (n2 + 20)) / 2, this.getHeight() - 25};
        graphics2D.fillPolygon(nArray, nArray2, 3);
    }
}

