/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Item
extends JPanel {
    private JTextField tf;
    private JLabel icon;
    private ImageIcon smallPic;
    private ImageIcon bigPic;
    private String iconName;
    private float weight;
    private Cursor cursor;

    public Item(String string, float f, boolean bl) {
        this.iconName = string;
        this.weight = f;
        this.smallPic = new ImageIcon(this.getClass().getResource("/icons/TN" + string));
        this.bigPic = new ImageIcon(this.getClass().getResource("/icons/" + string));
        this.cursor = Toolkit.getDefaultToolkit().createCustomCursor(this.smallPic.getImage(), new Point(15, 15), string);
        this.icon = new JLabel();
        this.icon.setIcon(bl ? this.bigPic : this.smallPic);
        this.tf = new JTextField();
        this.tf.setFont(new Font("Tahoma", 0, 14));
        this.tf.setDocument(new PositiveFloatNumberDoc());
        this.tf.setHorizontalAlignment(0);
        this.tf.setText(String.valueOf(f).endsWith(".0") ? String.valueOf((int)f) : String.valueOf(f));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.icon);
        this.add(this.tf);
        this.tf.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                try {
                    Item.this.setWeight(Float.parseFloat(Item.this.tf.getText().replace(',', '.')));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    Item.this.setWeight(0.0f);
                }
            }
        });
    }

    public Item(Item item) {
        this(item.getIconName(), item.getWeight(), item.isBig());
    }

    public String getIconName() {
        return this.iconName;
    }

    public ImageIcon getIcon() {
        return (ImageIcon)this.icon.getIcon();
    }

    public void setIcon(ImageIcon imageIcon) {
        this.icon.setIcon(imageIcon);
    }

    public boolean isBig() {
        return this.getIcon() == this.bigPic;
    }

    public void setIsBig(boolean bl) {
        this.icon.setIcon(bl ? this.bigPic : this.smallPic);
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float f) {
        this.weight = f;
    }

    public Cursor getCustomCursor() {
        return this.cursor;
    }

    public void showWeight(boolean bl) {
        this.tf.setVisible(bl);
    }

    public String toString() {
        return this.iconName;
    }
}

