/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa;

import com.singularsys.aa.EquationSystem;
import com.singularsys.aa.Solution;
import com.singularsys.aa.ThreadControl;
import com.singularsys.aa.linear.LinearSolver;
import com.singularsys.aa.logging.Logger;
import com.singularsys.aa.newton.NewtonSolver;
import com.singularsys.aa.testing.Subdivision;

public class SystemSolver {
    public Solution solve(EquationSystem equationSystem) throws Exception {
        this.checkNumberOfEquations(equationSystem);
        Solution solution = Subdivision.solveWithDividing(this, equationSystem);
        return solution;
    }

    public Solution solveNoSubdivision(EquationSystem equationSystem) throws Exception {
        Logger.incrLogLevel();
        this.checkNumberOfEquations(equationSystem);
        this.simplifySystem(equationSystem);
        Solution solution = this.findOneSolution(equationSystem);
        ThreadControl.mustStop();
        Logger.decrLogLevel();
        Logger.printTitle("Complete!");
        return solution;
    }

    private void checkNumberOfEquations(EquationSystem equationSystem) throws Exception {
        int n = equationSystem.getVariables().size();
        int n2 = equationSystem.getNumEquations();
        if (n2 <= 0) {
            throw new Exception("No equations to solve");
        }
        if (n != n2) {
            throw new Exception(n + " unknowns, " + n2 + " equations.");
        }
    }

    private void simplifySystem(EquationSystem equationSystem) {
        Logger.printTitle("Original Equation System");
        Logger.println(equationSystem.toString());
        Logger.printTitle("Simplifying System");
        equationSystem.simplify();
        Logger.printTitle("Simplified System");
        Logger.println(equationSystem.toString());
    }

    private Solution findOneSolution(EquationSystem equationSystem) throws Exception {
        Solution solution;
        try {
            Logger.printTitle("Trying LinearSolver");
            LinearSolver linearSolver = new LinearSolver();
            solution = linearSolver.solveSystem(equationSystem);
        }
        catch (Exception exception) {
            Logger.println("LinearSolver failed/interrupted");
            Logger.println(exception.toString());
            ThreadControl.mustStop();
            Logger.printTitle("Trying NewtonSolver");
            try {
                NewtonSolver newtonSolver = new NewtonSolver();
                solution = newtonSolver.solveSystem(equationSystem);
            }
            catch (Exception exception2) {
                Logger.println("NewtonSolver failed/interrupted");
                Logger.println(exception2.toString());
                throw new Exception("Could not solve equation system");
            }
        }
        return solution;
    }
}

