/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa.gui.swing;

import com.singularsys.aa.Solution;
import com.singularsys.aa.SolverListener;
import com.singularsys.aa.ThreadControl;
import com.singularsys.aa.gui.swing.AboutDialog;
import com.singularsys.aa.gui.swing.LogFrame;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MainFrame
extends JFrame
implements ClipboardOwner {
    private Clipboard clipboard;
    private Image icon;
    private LogFrame logFrame;
    private JMenuItem aboutItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenu editMenu;
    private JLabel eqLabel;
    private JPanel eqPanel;
    private JScrollPane eqScrollPane;
    private JTextArea eqTextArea;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuBar jMenuBar1;
    private JSeparator jSeparator1;
    private JMenuItem logwindowMenuItem;
    private JMenuItem openMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem savasMenuItem;
    private JLabel solLabel;
    private JPanel solPanel;
    private JScrollPane solScrollPane;
    private JTextArea solTextArea;
    private JSplitPane splitPane;
    private JMenu viewMenu;

    public MainFrame() {
        this.init();
    }

    public MainFrame(String string) {
        this.init();
        this.loadFile(string);
    }

    private void init() {
        this.logFrame = new LogFrame();
        this.logFrame.hide();
        this.initIcon();
        this.initComponents();
        this.clipboard = this.getToolkit().getSystemClipboard();
        this.documentChanged();
        this.setSize(500, 300);
    }

    private void initIcon() {
        this.icon = null;
        String string = "/com/singularsys/aa/gui/images/icon.gif";
        try {
            MediaTracker mediaTracker = new MediaTracker(this);
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                System.out.println("Could not load " + string);
                return;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[10000];
            int n = bufferedInputStream.read(byArray, 0, 10000);
            this.icon = Toolkit.getDefaultToolkit().createImage(byArray);
            mediaTracker.addImage(this.icon, 0);
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.eqPanel = new JPanel();
        this.eqLabel = new JLabel();
        this.eqScrollPane = new JScrollPane();
        this.eqTextArea = new JTextArea();
        this.solPanel = new JPanel();
        this.solLabel = new JLabel();
        this.solScrollPane = new JScrollPane();
        this.solTextArea = new JTextArea();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.savasMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.logwindowMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutItem = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("AutoAbacus");
        this.setIconImage(this.icon);
        this.setName("Frame");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.exitForm(windowEvent);
            }
        });
        this.splitPane.setDividerLocation(250);
        this.splitPane.setDividerSize(8);
        this.eqPanel.setLayout(new GridBagLayout());
        this.eqLabel.setText("Equations");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.eqPanel.add((Component)this.eqLabel, gridBagConstraints);
        this.eqTextArea.setTabSize(4);
        this.eqTextArea.setMargin(new Insets(8, 8, 8, 8));
        this.eqTextArea.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                MainFrame.this.documentChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MainFrame.this.documentChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                MainFrame.this.documentChanged();
            }
        });
        this.eqScrollPane.setViewportView(this.eqTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.eqPanel.add((Component)this.eqScrollPane, gridBagConstraints);
        this.splitPane.setLeftComponent(this.eqPanel);
        this.solPanel.setLayout(new GridBagLayout());
        this.solLabel.setText("Solutions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.solPanel.add((Component)this.solLabel, gridBagConstraints);
        this.solTextArea.setEditable(false);
        this.solTextArea.setMargin(new Insets(8, 8, 8, 8));
        this.solTextArea.setOpaque(false);
        this.solScrollPane.setViewportView(this.solTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.solPanel.add((Component)this.solScrollPane, gridBagConstraints);
        this.splitPane.setRightComponent(this.solPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.splitPane, gridBagConstraints);
        this.fileMenu.setMnemonic('f');
        this.fileMenu.setText("File");
        this.fileMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.fileMenuActionPerformed(actionEvent);
            }
        });
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.setMnemonic('o');
        this.openMenuItem.setText("Open...");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.openMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.savasMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.savasMenuItem.setMnemonic('s');
        this.savasMenuItem.setText("Save As...");
        this.savasMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.savasMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.savasMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.exitMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.jMenuBar1.add(this.fileMenu);
        this.editMenu.setMnemonic('e');
        this.editMenu.setText("Edit");
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cutMenuItem.setMnemonic('t');
        this.cutMenuItem.setText("Cut");
        this.cutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.cutMenuItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyMenuItem.setMnemonic('c');
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.copyMenuItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.pasteMenuItem.setMnemonic('p');
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.pasteMenuItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.pasteMenuItem);
        this.jMenuBar1.add(this.editMenu);
        this.viewMenu.setMnemonic('v');
        this.viewMenu.setText("View");
        this.logwindowMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.logwindowMenuItem.setMnemonic('l');
        this.logwindowMenuItem.setText("Show Log Window");
        this.logwindowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.logwindowMenuItemActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.logwindowMenuItem);
        this.jMenuBar1.add(this.viewMenu);
        this.helpMenu.setMnemonic('h');
        this.helpMenu.setText("Help");
        this.aboutItem.setMnemonic('a');
        this.aboutItem.setText("About");
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.aboutItemActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void aboutItemActionPerformed(ActionEvent actionEvent) {
        new AboutDialog((Frame)this, true).show();
    }

    private void logwindowMenuItemActionPerformed(ActionEvent actionEvent) {
        this.logFrame.setLocation(this.getLocation().x + this.getWidth(), this.getLocation().y);
        this.logFrame.show();
    }

    private void exitMenuItemActionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    private void pasteMenuItemActionPerformed(ActionEvent actionEvent) {
        Transferable transferable = this.clipboard.getContents(this);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.eqTextArea.replaceRange(string, this.eqTextArea.getSelectionStart(), this.eqTextArea.getSelectionEnd());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void copyMenuItemActionPerformed(ActionEvent actionEvent) {
        String string = this.eqTextArea.getSelectedText();
        if (string.length() > 0) {
            StringSelection stringSelection = new StringSelection(string);
            this.clipboard.setContents(stringSelection, this);
        }
    }

    private void cutMenuItemActionPerformed(ActionEvent actionEvent) {
        String string = this.eqTextArea.getSelectedText();
        if (string != null && string.length() > 0) {
            StringSelection stringSelection = new StringSelection(string);
            this.clipboard.setContents(stringSelection, this);
            this.eqTextArea.replaceRange("", this.eqTextArea.getSelectionStart(), this.eqTextArea.getSelectionEnd());
        }
    }

    private void savasMenuItemActionPerformed(ActionEvent actionEvent) {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save", 1);
        String string = System.getProperty("line.separator");
        fileDialog.show();
        try {
            FileWriter fileWriter = new FileWriter(fileDialog.getDirectory() + fileDialog.getFile());
            String string2 = this.eqTextArea.getText();
            for (int i = 0; i < string2.length(); ++i) {
                String string3 = "";
                while (i < string2.length() && string2.charAt(i) != '\n') {
                    string3 = string3 + string2.charAt(i);
                    ++i;
                }
                fileWriter.write(string3 + string);
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            System.err.println("Error saving to \"" + fileDialog.getDirectory() + fileDialog.getFile() + "\"");
        }
    }

    private void openMenuItemActionPerformed(ActionEvent actionEvent) {
        FileDialog fileDialog = new FileDialog((Frame)this, "Open", 0);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            this.loadFile(fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    private void fileMenuActionPerformed(ActionEvent actionEvent) {
    }

    private void closeActionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (stringArray.length > 0) {
            new MainFrame(stringArray[0]).show();
        } else {
            new MainFrame().show();
        }
    }

    private void loadFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while (bufferedReader.ready()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(bufferedReader.readLine());
            }
            this.eqTextArea.setText(stringBuffer.toString());
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Error while opening \"" + string + "\"");
        }
    }

    private void documentChanged() {
        this.solTextArea.setText("Calculations in progress...");
        SolverListener solverListener = new SolverListener(){

            public void updateSolution(Solution solution, String string, String string2) {
                MainFrame.this.updateSol(solution, string, string2);
            }
        };
        try {
            ThreadControl.startNewThread(solverListener, this.eqTextArea.getText());
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public void updateSol(final Solution solution, final String string, final String string2) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (solution == null) {
                    MainFrame.this.solTextArea.setText("No solutions found\n\n" + string);
                    MainFrame.this.logFrame.setLogText(string2);
                } else {
                    MainFrame.this.solTextArea.setText(solution.toString());
                    MainFrame.this.logFrame.setLogText(string2);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

