/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa.junit;

import com.singularsys.aa.EquationSystem;
import com.singularsys.aa.Solution;
import com.singularsys.aa.junit.SolvingTest;
import java.io.FileReader;
import java.io.Reader;
import org.apache.crimson.parser.XMLReaderImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class InputParser
extends DefaultHandler {
    private boolean inDocument;
    private boolean inEqVal;
    private boolean inValue;
    private static final String eqValElement = "eqVal";
    private static final String eqElement = "eq";
    private static final String eqAttr = "eq";
    private static final String valueElement = "value";
    private static final String varAttr = "var";
    private EquationSystem curEquations;
    private Solution curSolution;
    private String curVar;
    private XMLReader xr = new XMLReaderImpl();
    private SolvingTest solvingTest;

    public static void main(String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            FileReader fileReader = new FileReader(stringArray[i]);
            new InputParser(null).parseInput(fileReader);
        }
    }

    public InputParser(SolvingTest solvingTest) {
        this.xr.setContentHandler(this);
        this.xr.setErrorHandler(this);
        this.resetState();
        this.solvingTest = solvingTest;
    }

    public void parseInput(Reader reader) {
        this.resetState();
        try {
            this.xr.parse(new InputSource(reader));
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void resetState() {
        this.inDocument = false;
        this.inEqVal = false;
        this.inValue = false;
    }

    private void sendNewSystem() {
        if (this.solvingTest != null) {
            this.solvingTest.checkSystem(this.curEquations, this.curSolution);
        }
    }

    public void startDocument() {
        this.inDocument = true;
    }

    public void endDocument() {
        this.inDocument = false;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string2.equals(eqValElement) && this.inDocument) {
            this.inEqVal = true;
            this.curEquations = new EquationSystem();
            this.curSolution = new Solution();
        }
        if (string2.equals("eq") && this.inEqVal) {
            String string4 = attributes.getValue("eq");
            try {
                this.curEquations.addEquation(string4);
            }
            catch (Exception exception) {
                System.out.println("Error while adding equation " + string4);
                exception.printStackTrace();
            }
        }
        if (string2.equals(valueElement) && this.inEqVal) {
            this.inValue = true;
            this.curVar = attributes.getValue(varAttr);
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (string2.equals(eqValElement)) {
            this.inEqVal = false;
            this.sendNewSystem();
        }
        if (string2.equals(valueElement)) {
            this.inValue = false;
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.inValue) {
            Double d = new Double(new String(cArray, n, n2));
            this.curSolution.addSolution(this.curVar, d);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        System.out.println("Warning: " + sAXParseException.toString());
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        System.out.println("Error: " + sAXParseException.toString());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.out.println("Fatal Error: " + sAXParseException.toString());
        throw sAXParseException;
    }
}

