/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa.linear;

import com.singularsys.aa.linear.LinearExpr;
import com.singularsys.aa.logging.Logger;
import com.singularsys.aa.polynomial.PolynomialExpr;
import com.singularsys.aa.polynomial.PolynomialTerm;
import java.util.Vector;

public class LinearCoefficientExtractor {
    private static final double EXP_TOL = 1.0E-20;

    public static LinearExpr getLinearExpr(PolynomialExpr polynomialExpr) throws IllegalArgumentException {
        Vector vector = polynomialExpr.getTerms();
        LinearExpr linearExpr = new LinearExpr();
        int n = 0;
        int n2 = 0;
        Vector vector2 = polynomialExpr.getVariables();
        boolean[] blArray = new boolean[vector2.size()];
        boolean bl = false;
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        for (n = 0; n < vector.size(); ++n) {
            PolynomialTerm polynomialTerm = (PolynomialTerm)vector.elementAt(n);
            Object object = polynomialTerm.getCoefficient();
            n2 = LinearCoefficientExtractor.getVarIndex(polynomialTerm);
            if (n2 < 0) {
                if (bl) {
                    throw new IllegalArgumentException();
                }
                bl = true;
                Logger.print("" + object);
                linearExpr.setConstant(object);
                continue;
            }
            if (blArray[n2]) {
                throw new IllegalArgumentException();
            }
            blArray[n2] = true;
            Logger.print(" + " + object + vector2.elementAt(n2));
            linearExpr.addCoefficient((String)vector2.elementAt(n2), object);
        }
        Logger.println();
        return linearExpr;
    }

    private static int getVarIndex(PolynomialTerm polynomialTerm) throws IllegalArgumentException {
        int n = -1;
        boolean bl = false;
        for (int i = 0; i < polynomialTerm.getNumberOfVariables(); ++i) {
            if (LinearCoefficientExtractor.equal(polynomialTerm.getExponent(i), 0.0)) continue;
            if (LinearCoefficientExtractor.equal(polynomialTerm.getExponent(i), 1.0)) {
                if (bl) {
                    throw new IllegalArgumentException();
                }
                bl = true;
                n = i;
                continue;
            }
            throw new IllegalArgumentException();
        }
        return n;
    }

    private static boolean equal(Object object, double d) {
        double d2 = (Double)object;
        return !(d2 < d - 1.0E-20) && !(d2 > d + 1.0E-20);
    }
}

