/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa.polynomial;

import com.singularsys.aa.UntypifiedExpr;
import com.singularsys.aa.manipulation.TreeUtil;
import com.singularsys.aa.polynomial.PolynomialExpr;
import java.util.Vector;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;

public class PolyExtractor {
    public static void extractFromTree(UntypifiedExpr untypifiedExpr, PolynomialExpr polynomialExpr) throws IllegalArgumentException {
        Node node = untypifiedExpr.getTopNode();
        Vector vector = untypifiedExpr.getVariables();
        int n = vector.size();
        if (TreeUtil.getNodeId(node) != 8) {
            throw new IllegalArgumentException();
        }
        PolyExtractor.processPlus(polynomialExpr, (ASTFunNode)node);
    }

    private static void processPlus(PolynomialExpr polynomialExpr, ASTFunNode aSTFunNode) throws IllegalArgumentException {
        for (int i = 0; i < aSTFunNode.jjtGetNumChildren(); ++i) {
            Node node = aSTFunNode.jjtGetChild(i);
            polynomialExpr.makeNewTerm();
            if (node instanceof ASTConstant) {
                PolyExtractor.processConstant(polynomialExpr, (ASTConstant)node);
                continue;
            }
            if (TreeUtil.getNodeId(node) == 11) {
                PolyExtractor.processMul(polynomialExpr, (ASTFunNode)node);
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    private static void processConstant(PolynomialExpr polynomialExpr, ASTConstant aSTConstant) throws IllegalArgumentException {
        Object object = aSTConstant.getValue();
        if (!(object instanceof Double)) {
            throw new IllegalArgumentException();
        }
        polynomialExpr.multiplyCoefficientWith((Double)object);
    }

    private static void processMul(PolynomialExpr polynomialExpr, ASTFunNode aSTFunNode) throws IllegalArgumentException {
        for (int i = 0; i < aSTFunNode.jjtGetNumChildren(); ++i) {
            Node node = aSTFunNode.jjtGetChild(i);
            if (node instanceof ASTConstant) {
                Object object = ((ASTConstant)node).getValue();
                if (object instanceof Double) {
                    polynomialExpr.multiplyCoefficientWith((Double)object);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            if (TreeUtil.getNodeId(node) == 15) {
                PolyExtractor.processPow(polynomialExpr, (ASTFunNode)node);
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    private static void processPow(PolynomialExpr polynomialExpr, ASTFunNode aSTFunNode) throws IllegalArgumentException {
        Object object;
        if (aSTFunNode.jjtGetNumChildren() != 2) {
            throw new IllegalArgumentException();
        }
        if (!(aSTFunNode.jjtGetChild(0) instanceof ASTVarNode)) {
            throw new IllegalArgumentException();
        }
        String string = ((ASTVarNode)aSTFunNode.jjtGetChild(0)).getName();
        if (aSTFunNode.jjtGetChild(1) instanceof ASTConstant) {
            object = ((ASTConstant)aSTFunNode.jjtGetChild(1)).getValue();
            if (!(object instanceof Double)) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalArgumentException();
        }
        polynomialExpr.addToExponent(string, (Double)object);
    }
}

