/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.aa.testing;

import com.singularsys.aa.ExpressionPrinterVisitor;
import com.singularsys.aa.manipulation.Simplifier;
import com.singularsys.aa.manipulation.Sorter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;

class Console {
    private String prompt = "JEP > ";
    private BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

    public static void main(String[] stringArray) throws IOException {
        Console console = new Console();
        console.run(stringArray);
    }

    public void run(String[] stringArray) throws IOException {
        String string = "";
        JEP jEP = new JEP();
        jEP.setAllowUndeclared(true);
        jEP.setImplicitMul(true);
        if (stringArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(" " + stringArray[i]);
            }
            this.processCommand(stringBuffer.toString(), jEP);
        } else {
            System.out.println("JEP - Enter q to quit");
            System.out.print(this.prompt);
            while ((string = this.getCommand()) != null) {
                this.processCommand(string, jEP);
                System.out.print(this.prompt);
            }
        }
    }

    private String getCommand() throws IOException {
        if (this.br == null) {
            return null;
        }
        String string = this.br.readLine();
        if (string == null) {
            return null;
        }
        if (string.equals("q") || string.equals("quit") || string.equals("exit")) {
            return null;
        }
        return string;
    }

    private void processCommand(String string, JEP jEP) {
        jEP.parseExpression(string);
        if (jEP.hasError()) {
            System.out.println(jEP.getErrorInfo());
        } else {
            Object object = jEP.getValueAsObject();
            if (jEP.hasError()) {
                System.out.println(jEP.getErrorInfo());
            } else {
                System.out.println(object);
            }
            try {
                Node node = new Simplifier().simplify(jEP.getTopNode());
                System.out.println("After simplification: ");
                new ExpressionPrinterVisitor().printExpression(node);
                new Sorter().sortTree(node);
                System.out.println("After sorting:");
                new ExpressionPrinterVisitor().printExpression(node);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

