/*
 * Decompiled with CFR 0.152.
 */
public class MultiplicationOperator {
    public static final byte NONE = 0;
    public static final byte FACTOR_A = 1;
    public static final byte FACTOR_B = 2;
    public static final byte PRODUCT = 3;
    public static final byte UNITS = 4;
    public static final byte DECS = 4;
    private int factorA = 0;
    private int factorB = 0;
    private int product = 0;
    private int units = 0;
    private int decs = 0;
    private ByteHistoryQueue history = new ByteHistoryQueue(3);

    public void clear() {
        this.factorA = 0;
        this.factorB = 0;
        this.product = 0;
        this.units = 0;
        this.decs = 0;
    }

    public void setFactorA(int f) {
        this.factorA = f;
        this.history.put((byte)1);
    }

    public void setFactorB(int f) {
        this.factorB = f;
        this.history.put((byte)2);
    }

    public void setProduct(int p) {
        this.product = p;
        this.history.put((byte)3);
    }

    public void setUnits(int u) {
        this.units = u;
        this.history.put((byte)4);
    }

    public void setDecs(int d) {
        this.decs = d;
        this.history.put((byte)4);
    }

    public int getFactorA() {
        return this.factorA;
    }

    public int getFactorB() {
        return this.factorB;
    }

    public int getProduct() {
        return this.product;
    }

    public int getUnits() {
        return this.units;
    }

    public int getDecs() {
        return this.decs;
    }

    public byte calculate() {
        byte ret = 0;
        return ret;
    }

    public boolean isCorect() {
        if (this.factorA * this.factorB != this.product) {
            return false;
        }
        return this.units + this.decs == this.factorB;
    }

    public void copy(MultiplicationOperator op) {
        this.factorA = op.getFactorA();
        this.factorB = op.getFactorB();
        this.product = op.getProduct();
        this.units = op.getUnits();
        this.decs = op.getDecs();
    }

    static {
        NONE = 0;
        FACTOR_A = 1;
        FACTOR_B = (byte)2;
        PRODUCT = (byte)3;
        UNITS = (byte)4;
        DECS = (byte)4;
    }
}

