/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;

class XShape
implements Serializable {
    private static final double[] COMP2 = new double[]{XShape.compination(2, 0), XShape.compination(2, 1), XShape.compination(2, 2)};
    private static final double[] COMP3 = new double[]{XShape.compination(3, 0), XShape.compination(3, 1), XShape.compination(3, 2), XShape.compination(3, 3)};
    private static final double[] BERN0125 = new double[]{XShape.bernstein(3, 0, 0.125), XShape.bernstein(3, 1, 0.125), XShape.bernstein(3, 2, 0.125), XShape.bernstein(3, 3, 0.125)};
    private static final double[] BERN0250 = new double[]{XShape.bernstein(3, 0, 0.25), XShape.bernstein(3, 1, 0.25), XShape.bernstein(3, 2, 0.25), XShape.bernstein(3, 3, 0.25)};
    private static final double[] BERN0375 = new double[]{XShape.bernstein(3, 0, 0.375), XShape.bernstein(3, 1, 0.375), XShape.bernstein(3, 2, 0.375), XShape.bernstein(3, 3, 0.375)};
    private static final double[] BERN0500 = new double[]{XShape.bernstein(3, 0, 0.5), XShape.bernstein(3, 1, 0.5), XShape.bernstein(3, 2, 0.5), XShape.bernstein(3, 3, 0.5)};
    private static final double[] BERN0625 = new double[]{XShape.bernstein(3, 0, 0.625), XShape.bernstein(3, 1, 0.625), XShape.bernstein(3, 2, 0.625), XShape.bernstein(3, 3, 0.625)};
    private static final double[] BERN0750 = new double[]{XShape.bernstein(3, 0, 0.75), XShape.bernstein(3, 1, 0.75), XShape.bernstein(3, 2, 0.75), XShape.bernstein(3, 3, 0.75)};
    private static final double[] BERN0875 = new double[]{XShape.bernstein(3, 0, 0.875), XShape.bernstein(3, 1, 0.875), XShape.bernstein(3, 2, 0.875), XShape.bernstein(3, 3, 0.875)};
    public Shape shape;
    public Color color;
    public Color fillColor;
    public boolean fill;
    public boolean closed;

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream p = new ObjectOutputStream(out);
        Vector<Point> pnt = new Vector<Point>();
        PathIterator pi = this.shape.getPathIterator(null);
        float[] coord = new float[6];
        boolean b = false;
        int j = 0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(coord)) {
                case 0: {
                    pnt.add(new Point((int)coord[0], (int)coord[1]));
                    b = true;
                    break;
                }
                case 1: {
                    pnt.add(new Point((int)coord[0], (int)coord[1]));
                }
            }
            pi.next();
            ++j;
        }
        p.writeObject(this.color);
        p.writeObject(new Boolean(this.fill));
        p.writeObject(this.fillColor);
        p.writeObject(new Boolean(this.closed));
        Integer len = new Integer(pnt.size());
        p.writeObject(len);
        int i = 0;
        while (i < pnt.size()) {
            p.writeObject(pnt.get(i));
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream p = new ObjectInputStream(in);
        this.color = (Color)p.readObject();
        this.fill = (Boolean)p.readObject();
        this.fillColor = (Color)p.readObject();
        this.closed = (Boolean)p.readObject();
        GeneralPath gp = new GeneralPath();
        Integer len = (Integer)p.readObject();
        boolean b = false;
        int i = 0;
        while (i < len) {
            Point pnt = (Point)p.readObject();
            if (i > 0) {
                gp.lineTo(pnt.x, pnt.y);
            } else {
                gp.moveTo(pnt.x, pnt.y);
                b = true;
            }
            ++i;
        }
        if (this.closed && len > 0) {
            gp.closePath();
        }
        this.shape = gp.createTransformedShape(null);
    }

    XShape(Shape shape, Color color, boolean fill, Color fillColor) {
        this.shape = shape;
        this.color = new Color(color.getRGB());
        this.fill = fill;
        this.fillColor = fillColor;
    }

    XShape(Shape shape, Color color, boolean fill, Color fillColor, boolean closed) {
        this.shape = shape;
        this.color = new Color(color.getRGB());
        this.fill = fill;
        this.fillColor = fillColor;
        this.closed = closed;
    }

    public void setClosed(boolean c) {
        this.closed = c;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    private static boolean samePoints(int x1, int y1, int x2, int y2, int d) {
        int x = Math.abs(x1 - x2);
        int y = Math.abs(y1 - y2);
        return x <= d && y <= d;
    }

    private static boolean insideRect(int x1, int y1, int x2, int y2, int px, int py, int d) {
        int t;
        if (x1 > x2) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y1 > y2) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        return px >= x1 - d && px <= x2 + d && py >= y1 - d && py <= y2 + d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean onLine(int x1, int y1, int x2, int y2, int px, int py, int d) {
        if (!XShape.insideRect(x1, y1, x2, y2, px, py, d)) {
            return false;
        }
        if (Math.abs(x1 - x2) >= Math.abs(y1 - y2)) {
            if (x1 == x2) return true;
            double a = (double)(y2 - y1) / (double)(x2 - x1);
            double b = (double)y2 * (double)x1 / (double)(x1 - x2) - (double)y1 * (double)x2 / (double)(x1 - x2);
            double y = a * (double)px + b;
            if (!(Math.abs((double)py - y) <= (double)d)) return false;
            return true;
        }
        if (y1 == y2) return true;
        double a = (double)(x2 - x1) / (double)(y2 - y1);
        double b = (double)x2 * (double)y1 / (double)(y1 - y2) - (double)x1 * (double)y2 / (double)(y1 - y2);
        double x = a * (double)py + b;
        if (!(Math.abs((double)px - x) <= (double)d)) return false;
        return true;
    }

    public static boolean onCubicCurve(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int px, int py, int d) {
        int xx1 = (int)(BERN0125[0] * (double)x1 + BERN0125[1] * (double)x2 + BERN0125[2] * (double)x3 + BERN0125[3] * (double)x4);
        int yy1 = (int)(BERN0125[0] * (double)y1 + BERN0125[1] * (double)y2 + BERN0125[2] * (double)y3 + BERN0125[3] * (double)y4);
        if (XShape.onLine(x1, y1, xx1, yy1, px, py, d)) {
            return true;
        }
        int xx2 = (int)(BERN0250[0] * (double)x1 + BERN0250[1] * (double)x2 + BERN0250[2] * (double)x3 + BERN0250[3] * (double)x4);
        int yy2 = (int)(BERN0250[0] * (double)y1 + BERN0250[1] * (double)y2 + BERN0250[2] * (double)y3 + BERN0250[3] * (double)y4);
        if (XShape.onLine(xx1, yy1, xx2, yy2, px, py, d)) {
            return true;
        }
        int xx3 = (int)(BERN0375[0] * (double)x1 + BERN0375[1] * (double)x2 + BERN0375[2] * (double)x3 + BERN0375[3] * (double)x4);
        int yy3 = (int)(BERN0375[0] * (double)y1 + BERN0375[1] * (double)y2 + BERN0375[2] * (double)y3 + BERN0375[3] * (double)y4);
        if (XShape.onLine(xx2, yy2, xx3, yy3, px, py, d)) {
            return true;
        }
        int xx4 = (int)(BERN0500[0] * (double)x1 + BERN0500[1] * (double)x2 + BERN0500[2] * (double)x3 + BERN0500[3] * (double)x4);
        int yy4 = (int)(BERN0500[0] * (double)y1 + BERN0500[1] * (double)y2 + BERN0500[2] * (double)y3 + BERN0500[3] * (double)y4);
        if (XShape.onLine(xx3, yy3, xx4, yy4, px, py, d)) {
            return true;
        }
        int xx5 = (int)(BERN0625[0] * (double)x1 + BERN0625[1] * (double)x2 + BERN0625[2] * (double)x3 + BERN0625[3] * (double)x4);
        int yy5 = (int)(BERN0625[0] * (double)y1 + BERN0625[1] * (double)y2 + BERN0625[2] * (double)y3 + BERN0625[3] * (double)y4);
        if (XShape.onLine(xx4, yy4, xx5, yy5, px, py, d)) {
            return true;
        }
        int xx6 = (int)(BERN0750[0] * (double)x1 + BERN0750[1] * (double)x2 + BERN0750[2] * (double)x3 + BERN0750[3] * (double)x4);
        int yy6 = (int)(BERN0750[0] * (double)y1 + BERN0750[1] * (double)y2 + BERN0750[2] * (double)y3 + BERN0750[3] * (double)y4);
        if (XShape.onLine(xx5, yy5, xx6, yy6, px, py, d)) {
            return true;
        }
        int xx7 = (int)(BERN0875[0] * (double)x1 + BERN0875[1] * (double)x2 + BERN0875[2] * (double)x3 + BERN0875[3] * (double)x4);
        int yy7 = (int)(BERN0875[0] * (double)y1 + BERN0875[1] * (double)y2 + BERN0875[2] * (double)y3 + BERN0875[3] * (double)y4);
        if (XShape.onLine(xx6, yy6, xx7, yy7, px, py, d)) {
            return true;
        }
        return XShape.onLine(xx7, yy7, x4, y4, px, py, d);
    }

    public static boolean onQuadCurve(int x1, int y1, int x2, int y2, int x3, int y3, int px, int py) {
        return false;
    }

    private static int paragontiko(int n) {
        int p = 1;
        int i = 2;
        while (i <= n) {
            p *= i;
            ++i;
        }
        return p;
    }

    private static double compination(int n, int m) {
        if (n >= m) {
            return XShape.paragontiko(n) / (XShape.paragontiko(m) * XShape.paragontiko(n - m));
        }
        return 0.0;
    }

    private static double bernstein(int n, int m, double t) {
        if (n == 3 && m >= 0 && m <= 3) {
            return COMP3[m] * Math.pow(t, m) * Math.pow(1.0 - t, 3 - m);
        }
        if (n == 2 && m >= 0 && m <= 2) {
            return COMP2[m] * Math.pow(t, m) * Math.pow(1.0 - t, 2 - m);
        }
        return 0.0;
    }

    public int hitsShapeVertex(int x, int y, Point vertex) {
        int index = 0;
        float[] coord = new float[6];
        PathIterator pi = this.shape.getPathIterator(null);
        while (!pi.isDone()) {
            switch (pi.currentSegment(coord)) {
                case 0: 
                case 1: {
                    if (!XShape.samePoints(x, y, (int)coord[0], (int)coord[1], 3)) break;
                    vertex.x = (int)coord[0];
                    vertex.y = (int)coord[1];
                    return index;
                }
            }
            pi.next();
            ++index;
        }
        return -1;
    }

    public boolean hitsShapeOutline(int x, int y) {
        float[] coord = new float[6];
        PathIterator pi = this.shape.getPathIterator(null);
        int startX = 0;
        int startY = 0;
        int type = pi.currentSegment(coord);
        if (type == 0) {
            startX = (int)coord[0];
            startY = (int)coord[1];
        }
        int vx = 0;
        int vy = 0;
        while (!pi.isDone()) {
            type = pi.currentSegment(coord);
            switch (type) {
                case 0: {
                    vx = (int)coord[0];
                    vy = (int)coord[1];
                    if (!XShape.samePoints(x, y, vx, vy, 3)) break;
                    return true;
                }
                case 1: {
                    if (XShape.onLine(vx, vy, (int)coord[0], (int)coord[1], x, y, 3)) {
                        return true;
                    }
                    vx = (int)coord[0];
                    vy = (int)coord[1];
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (XShape.onCubicCurve(vx, vy, (int)coord[0], (int)coord[1], (int)coord[2], (int)coord[3], (int)coord[4], (int)coord[5], x, y, 3)) {
                        return true;
                    }
                    vx = (int)coord[4];
                    vy = (int)coord[5];
                    break;
                }
                case 4: {
                    if (XShape.onLine(vx, vy, startX, startY, x, y, 3)) {
                        return true;
                    }
                    vx = (int)coord[0];
                    vy = (int)coord[1];
                }
            }
            pi.next();
        }
        return false;
    }

    private Point findLineIntersection(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        if (!Line2D.linesIntersect(x1, y1, x2, y2, x3, y3, x4, y4)) {
            return null;
        }
        if (x1 - x2 == 0 && x3 - x4 == 0) {
            return null;
        }
        if (x1 == x2) {
            double a2 = (double)(y4 - y3) / (double)(x4 - x3);
            double b2 = (double)y4 * (double)x3 / (double)(x3 - x4) - (double)y3 * (double)x4 / (double)(x3 - x4);
            int x = x1;
            int y = (int)Math.round(a2 * (double)x1 + b2);
            return new Point(x, y);
        }
        double a1 = (double)(y2 - y1) / (double)(x2 - x1);
        double b1 = (double)y2 * (double)x1 / (double)(x1 - x2) - (double)y1 * (double)x2 / (double)(x1 - x2);
        if (x3 == x4) {
            a1 = (double)(y2 - y1) / (double)(x2 - x1);
            b1 = (double)y2 * (double)x1 / (double)(x1 - x2) - (double)y1 * (double)x2 / (double)(x1 - x2);
            int x = x3;
            int y = (int)Math.round(a1 * (double)x3 + b1);
            return new Point(x, y);
        }
        double a2 = (double)(y4 - y3) / (double)(x4 - x3);
        double b2 = (double)y4 * (double)x3 / (double)(x3 - x4) - (double)y3 * (double)x4 / (double)(x3 - x4);
        if (a1 == a2) {
            return null;
        }
        int x = (int)Math.round((b2 - b1) / (a1 - a2));
        int y = (int)Math.round(a1 * (b2 - b1) / (a1 - a2) + b1);
        return new Point(x, y);
    }

    private Point findLineIntersectionX(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        Point p = this.findLineIntersection(x1, y1, x2, y2, x3, y3, x4, y4);
        if (p == null) {
            return null;
        }
        if (p.x == x4 && p.y == y4) {
            return null;
        }
        return p;
    }

    private int findCubicCurveIntersection(CubicCurve2D curve, int x1, int y1, int x2, int y2, int[] intersectPnt) {
        block8: {
            int ret;
            double[] pnt;
            double step;
            block7: {
                step = 0.5 / Math.sqrt(Math.pow(curve.getX1() - curve.getX2(), 2.0) + Math.pow(curve.getY1() - curve.getY2(), 2.0));
                pnt = new double[]{curve.getX1(), curve.getY1(), curve.getCtrlX1(), curve.getCtrlY1(), curve.getCtrlX2(), curve.getCtrlY2(), curve.getX2(), curve.getY2()};
                ret = 0;
                if (!Line2D.linesIntersect(x1, y1, x2, y2, pnt[0], pnt[1], pnt[6], pnt[7])) break block7;
                double t = 0.0;
                while (t <= 1.0) {
                    int y;
                    int x = (int)Math.round(XShape.bernstein(3, 0, t) * pnt[0] + XShape.bernstein(3, 1, t) * pnt[2] + XShape.bernstein(3, 2, t) * pnt[4] + XShape.bernstein(3, 3, t) * pnt[6]);
                    if (XShape.onLine(x1, y1, x2, y2, x, y = (int)Math.round(XShape.bernstein(3, 0, t) * pnt[1] + XShape.bernstein(3, 1, t) * pnt[3] + XShape.bernstein(3, 2, t) * pnt[5] + XShape.bernstein(3, 3, t) * pnt[7]), 1)) {
                        intersectPnt[0] = x;
                        intersectPnt[1] = y;
                        return 1;
                    }
                    t += step;
                }
                break block8;
            }
            double t = 0.0;
            while (t <= 1.0 && ret == 0) {
                int y;
                int x = (int)Math.round(XShape.bernstein(3, 0, t) * pnt[0] + XShape.bernstein(3, 1, t) * pnt[2] + XShape.bernstein(3, 2, t) * pnt[4] + XShape.bernstein(3, 3, t) * pnt[6]);
                if (XShape.onLine(x1, y1, x2, y2, x, y = (int)Math.round(XShape.bernstein(3, 0, t) * pnt[1] + XShape.bernstein(3, 1, t) * pnt[3] + XShape.bernstein(3, 2, t) * pnt[5] + XShape.bernstein(3, 3, t) * pnt[7]), 1)) {
                    intersectPnt[0] = x;
                    intersectPnt[1] = y;
                    ++ret;
                }
                t += step;
            }
            if (ret == 0) break block8;
            double t2 = 1.0;
            while (t2 >= 0.0) {
                int y;
                int x = (int)Math.round(XShape.bernstein(3, 0, t2) * pnt[0] + XShape.bernstein(3, 1, t2) * pnt[2] + XShape.bernstein(3, 2, t2) * pnt[4] + XShape.bernstein(3, 3, t2) * pnt[6]);
                if (XShape.onLine(x1, y1, x2, y2, x, y = (int)Math.round(XShape.bernstein(3, 0, t2) * pnt[1] + XShape.bernstein(3, 1, t2) * pnt[3] + XShape.bernstein(3, 2, t2) * pnt[5] + XShape.bernstein(3, 3, t2) * pnt[7]), 1)) {
                    if (x == intersectPnt[0] && y == intersectPnt[1]) {
                        return 1;
                    }
                    intersectPnt[2] = x;
                    intersectPnt[3] = y;
                    return 2;
                }
                t2 -= step;
            }
        }
        return 0;
    }

    private static Point findCurveCenter(CubicCurve2D curve) {
        double x01 = curve.getCtrlX1() - curve.getX1();
        double y01 = curve.getCtrlY1() - curve.getY1();
        double x03 = curve.getX2() - curve.getX1();
        double y03 = curve.getY2() - curve.getY1();
        double phi = Math.acos((x01 * x03 + y01 * y03) / Math.sqrt((Math.pow(x01, 2.0) + Math.pow(y01, 2.0)) * (Math.pow(x03, 2.0) + Math.pow(y03, 2.0))));
        double r = Math.sqrt(Math.pow(x03, 2.0) + Math.pow(y03, 2.0)) / (2.0 * Math.sin(phi));
        if (y01 == 0.0) {
            double cx = curve.getX1();
            double cy1 = curve.getY1() - r;
            double cy2 = curve.getY1() + r;
            Line2D.Double line = new Line2D.Double(curve.getX1(), curve.getY1(), curve.getX2(), curve.getY2());
            if (line.relativeCCW(cx, cy1) * line.relativeCCW(curve.getCtrlX1(), curve.getCtrlY1()) < 0) {
                return new Point((int)Math.round(cx), (int)Math.round(cy1));
            }
            return new Point((int)Math.round(cx), (int)Math.round(cy2));
        }
        if (x01 == 0.0) {
            double cy = curve.getY1();
            double cx1 = curve.getX1() - r;
            double cx2 = curve.getX1() + r;
            Line2D.Double line = new Line2D.Double(curve.getX1(), curve.getY1(), curve.getX2(), curve.getY2());
            if (line.relativeCCW(cx1, cy) * line.relativeCCW(curve.getCtrlX1(), curve.getCtrlY1()) < 0) {
                return new Point((int)Math.round(cx1), (int)Math.round(cy));
            }
            return new Point((int)Math.round(cx2), (int)Math.round(cy));
        }
        double a1 = y01 / x01;
        double a = -1.0 / a1;
        double b = curve.getY1() - a * curve.getX1();
        double A = Math.pow(a, 2.0) + 1.0;
        double B = 2.0 * a * b - 2.0 * a * curve.getY1() - 2.0 * curve.getX1();
        double C = Math.pow(b - curve.getY1(), 2.0) + Math.pow(curve.getX1(), 2.0) - Math.pow(r, 2.0);
        double D = Math.pow(B, 2.0) - 4.0 * A * C;
        double cx1 = (-B + Math.sqrt(D)) / (2.0 * A);
        double cx2 = (-B - Math.sqrt(D)) / (2.0 * A);
        double cy1 = a * cx1 + b;
        double cy2 = a * cx2 + b;
        Line2D.Double line = new Line2D.Double(curve.getX1(), curve.getY1(), curve.getX2(), curve.getY2());
        if (line.relativeCCW(cx1, cy1) * line.relativeCCW(curve.getCtrlX1(), curve.getCtrlY1()) < 0) {
            return new Point((int)Math.round(cx1), (int)Math.round(cy1));
        }
        return new Point((int)Math.round(cx2), (int)Math.round(cy2));
    }

    private static void divCubicCurve(CubicCurve2D curve, int x, int y, int centerX, int centerY, GeneralPath c1, GeneralPath c2) {
        double x1 = curve.getX1();
        double y1 = curve.getY1();
        double x2 = curve.getX2();
        double y2 = curve.getY2();
        if (x == (int)Math.round(curve.getX1()) && y == (int)Math.round(curve.getY1())) {
            c1 = new GeneralPath();
            c1.moveTo((float)x1, (float)y1);
            c2 = new GeneralPath(curve);
        }
        if (x == (int)Math.round(curve.getX2()) && y == (int)Math.round(curve.getY2())) {
            c1 = new GeneralPath(curve);
            c2 = new GeneralPath();
            c2.moveTo((float)x2, (float)y2);
        }
        double r = Math.sqrt(Math.pow(x1 - (double)centerX, 2.0) + Math.pow(y1 - (double)centerY, 2.0));
        Line2D.Double lineC0 = new Line2D.Double(centerX, centerY, (double)centerX + r + 10.0, centerY);
        Line2D.Double line12 = new Line2D.Double(x1, y1, x2, y2);
        double start = (double)centerX == x1 ? (double)(lineC0.relativeCCW(x1, y1) * 90) : ((double)centerY == y1 ? (double)(lineC0.relativeCCW(x1, y1) * 180) : (lineC0.relativeCCW(x1, y1) > 0 ? Math.toDegrees(Math.atan((y1 - (double)centerY) / (x1 - (double)centerX))) : Math.toDegrees(Math.atan((y1 - (double)centerY) / (x1 - (double)centerX)))));
        double mid = centerX == x ? (double)(lineC0.relativeCCW(x, y) * 90) : (centerY == y ? (double)(lineC0.relativeCCW(x, y) * 180) : (lineC0.relativeCCW(x, y) > 0 ? Math.toDegrees(Math.atan((y - centerY) / (x - centerX))) : -Math.toDegrees(Math.atan((y - centerY) / (x - centerX)))));
        double end = (double)centerX == x2 ? (double)(lineC0.relativeCCW(x2, y2) * 90) : ((double)centerY == y2 ? (double)(lineC0.relativeCCW(x2, y2) * 180) : (lineC0.relativeCCW(x2, y2) > 0 ? Math.toDegrees(Math.atan((y2 - (double)centerY) / (x2 - (double)centerX))) : Math.toDegrees(Math.atan((y2 - (double)centerY) / (x2 - (double)centerX))) - 180.0));
        double ext = mid + (double)line12.relativeCCW(centerX, centerY) * start;
        Arc2D.Double arc1 = new Arc2D.Double(centerX, centerY, r, r, start, ext, 0);
        c1 = new GeneralPath(arc1);
        ext = end + (double)line12.relativeCCW(centerX, centerY) * mid;
        Arc2D.Double arc2 = new Arc2D.Double(centerX, centerY, r, r, mid, ext, 0);
        c2 = new GeneralPath(arc2);
    }

    private void cutShapeOnes(int x1, int y1, int x2, int y2, GeneralPath gp1, GeneralPath gp2) {
        PathIterator pi = this.shape.getPathIterator(null);
        int vx = 0;
        int vy = 0;
        int startX = 0;
        int startY = 0;
        float[] coord = new float[6];
        if (pi.currentSegment(coord) == 0) {
            startX = (int)coord[0];
            startY = (int)coord[1];
        }
        int intersect = 0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(coord)) {
                case 0: {
                    vx = (int)coord[0];
                    vy = (int)coord[1];
                    gp1.reset();
                    gp1.moveTo(vx, vy);
                    break;
                }
                case 1: {
                    Point pnt = this.findLineIntersectionX(x1, y1, x2, y2, vx, vy, (int)coord[0], (int)coord[1]);
                    if (pnt != null) {
                        if (++intersect == 1) {
                            if (vx != pnt.x || vy != pnt.y) {
                                gp1.lineTo(pnt.x, pnt.y);
                            }
                            gp2.reset();
                            gp2.moveTo(pnt.x, pnt.y);
                            gp2.lineTo((int)coord[0], (int)coord[1]);
                            vx = (int)coord[0];
                            vy = (int)coord[1];
                            break;
                        }
                        gp1.lineTo(pnt.x, pnt.y);
                        gp1.lineTo((int)coord[0], (int)coord[1]);
                        if (intersect == 2) {
                            if (vx != pnt.x || vy != pnt.y) {
                                gp2.lineTo(pnt.x, pnt.y);
                            }
                            gp2.closePath();
                        }
                        vx = (int)coord[0];
                        vy = (int)coord[1];
                        break;
                    }
                    vx = (int)coord[0];
                    vy = (int)coord[1];
                    if (intersect == 1) {
                        gp2.lineTo(vx, vy);
                        break;
                    }
                    gp1.lineTo(vx, vy);
                    break;
                }
                case 4: {
                    Point pnt = this.findLineIntersectionX(x1, y1, x2, y2, vx, vy, startX, startY);
                    if (pnt != null) {
                        gp1.lineTo(pnt.x, pnt.y);
                        gp1.closePath();
                        if (++intersect != 2) break;
                        if (vx != pnt.x || vy != pnt.y) {
                            gp2.lineTo(pnt.x, pnt.y);
                        }
                        gp2.closePath();
                        break;
                    }
                    gp1.closePath();
                    break;
                }
                case 3: {
                    CubicCurve2D.Float curve = new CubicCurve2D.Float(vx, vy, coord[0], coord[1], coord[2], coord[3], coord[4], coord[5]);
                    int[] p = new int[4];
                    int res = this.findCubicCurveIntersection(curve, x1, y1, x2, y2, p);
                    if (res > 0) {
                        Point center = XShape.findCurveCenter(curve);
                        GeneralPath c1 = new GeneralPath();
                        GeneralPath c2 = new GeneralPath();
                        XShape.divCubicCurve(curve, p[0], p[1], center.x, center.y, c1, c2);
                        if (++intersect == 1) {
                            gp1.append((Shape)c1.clone(), true);
                            gp2.reset();
                            gp2.moveTo(p[0], p[1]);
                            gp2.append((Shape)c2.clone(), true);
                            vx = (int)coord[4];
                            vy = (int)coord[5];
                            break;
                        }
                        gp1.lineTo(p[0], p[1]);
                        gp1.append((Shape)c2.clone(), true);
                        gp2.append((Shape)c1.clone(), true);
                        gp2.closePath();
                        vx = (int)coord[4];
                        vy = (int)coord[5];
                        break;
                    }
                    vx = (int)coord[4];
                    vy = (int)coord[5];
                    if (intersect == 1) {
                        gp2.append((Shape)curve.clone(), true);
                        break;
                    }
                    gp1.append((Shape)curve.clone(), true);
                    break;
                }
            }
            pi.next();
        }
    }

    private static void cutS(XShape xs, Vector points, Vector newShapes) {
        if (points.size() < 2) {
            newShapes.add(xs);
        } else {
            Point p2;
            GeneralPath gp1 = new GeneralPath();
            GeneralPath gp2 = new GeneralPath();
            Point p1 = (Point)points.get(0);
            if (points.size() > 4) {
                p2 = new Point((((Point)points.get((int)2)).x + ((Point)points.get((int)3)).x) / 2, (((Point)points.get((int)2)).y + ((Point)points.get((int)3)).y) / 2);
                points.add(3, p2);
            } else {
                p2 = (Point)points.get(3);
            }
            xs.cutShapeOnes(p1.x, p1.y, p2.x, p2.y, gp1, gp2);
            points.removeElementAt(0);
            points.removeElementAt(0);
            points.removeElementAt(0);
            XShape xs1 = new XShape(gp1, xs.color, xs.fill, xs.fillColor, xs.closed);
            XShape xs2 = new XShape(gp2, xs.color, xs.fill, xs.fillColor, xs.closed);
            Vector v1 = (Vector)points.clone();
            Vector v2 = (Vector)points.clone();
            XShape.cutS(xs1, v1, newShapes);
            XShape.cutS(xs2, v2, newShapes);
        }
    }

    public int cutShape(int x1, int y1, int x2, int y2, Vector newShapes) {
        if (!this.closed) {
            return 0;
        }
        PathIterator pi = this.shape.getPathIterator(null);
        int vx = 0;
        int vy = 0;
        int startX = 0;
        int startY = 0;
        float[] coord = new float[6];
        Vector<Object> intersections = new Vector<Object>();
        if (pi.currentSegment(coord) == 0) {
            startX = (int)coord[0];
            startY = (int)coord[1];
        }
        int intersect = 0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(coord)) {
                case 0: {
                    vx = (int)coord[0];
                    vy = (int)coord[1];
                    break;
                }
                case 1: {
                    Point pnt = this.findLineIntersection(x1, y1, x2, y2, vx, vy, (int)coord[0], (int)coord[1]);
                    if (pnt != null) {
                        ++intersect;
                        intersections.add(pnt);
                    }
                    vx = (int)coord[0];
                    vy = (int)coord[1];
                    break;
                }
                case 4: {
                    Point pnt = this.findLineIntersection(x1, y1, x2, y2, vx, vy, startX, startY);
                    if (pnt != null) {
                        ++intersect;
                        intersections.add(pnt);
                    }
                    vx = (int)coord[0];
                    vy = (int)coord[1];
                    break;
                }
                case 3: {
                    CubicCurve2D.Float curve = new CubicCurve2D.Float(vx, vy, coord[0], coord[1], coord[2], coord[3], coord[4], coord[5]);
                    int[] p = new int[4];
                    int res = this.findCubicCurveIntersection(curve, x1, y1, x2, y2, p);
                    if (res > 0) {
                        intersect += res;
                        intersections.add(new Point(p[0], p[1]));
                        if (res == 2) {
                            intersections.add(new Point(p[2], p[3]));
                        }
                    }
                    vx = (int)coord[4];
                    vy = (int)coord[5];
                }
            }
            pi.next();
        }
        Vector lines = new Vector();
        Object[] intersectArr = intersections.toArray();
        Arrays.sort(intersectArr, new DistComp(x1, y1));
        Object p1 = null;
        Object p2 = null;
        XShape xs = new XShape(this.shape, this.color, this.fill, this.fillColor, this.closed);
        intersections.clear();
        int intersectNew = 0;
        Point2D p = null;
        int i = 0;
        while (i < intersect) {
            if (i % 2 == 0) {
                p = new Point(((Point)intersectArr[i]).x, ((Point)intersectArr[i]).y);
                if (i + 1 == intersect && intersectNew % 2 != 0) {
                    intersections.add(p);
                    ++intersectNew;
                }
            } else if (p.distance((Point)intersectArr[i]) == 0.0) {
                Point m;
                boolean add1 = false;
                boolean add2 = false;
                if (i + 1 < intersect && this.shape.contains(m = new Point((((Point)intersectArr[i]).x + ((Point)intersectArr[i + 1]).x) / 2, (((Point)intersectArr[i]).y + ((Point)intersectArr[i + 1]).y) / 2))) {
                    add1 = true;
                }
                if (i > 1 && this.shape.contains(m = new Point((((Point)intersectArr[i - 2]).x + ((Point)intersectArr[i]).x) / 2, (((Point)intersectArr[i - 2]).y + ((Point)intersectArr[i]).y) / 2))) {
                    add2 = true;
                }
                if (add1 && !add2 || !add1 && add2) {
                    intersections.add(p);
                    ++intersectNew;
                }
            } else {
                intersections.add(p);
                intersections.add(intersectArr[i]);
                intersectNew += 2;
            }
            ++i;
        }
        intersectNew = intersections.size();
        if (intersectNew % 2 != 0 || intersectNew == 0) {
            return 0;
        }
        if (intersectNew == 2) {
            GeneralPath gp1 = new GeneralPath();
            GeneralPath gp2 = new GeneralPath();
            xs.cutShapeOnes(x1, y1, x2, y2, gp1, gp2);
            newShapes.add(new XShape(gp1, this.color, this.fill, this.fillColor, this.closed));
            newShapes.add(new XShape(gp2, this.color, this.fill, this.fillColor, this.closed));
            return 2;
        }
        intersections.add(new Point(x2, y2));
        intersections.add(0, new Point(x1, y1));
        XShape.cutS(xs, intersections, newShapes);
        return intersect;
    }

    public int getVertexes(Vector v) {
        PathIterator pi = this.shape.getPathIterator(null);
        double[] coord = new double[6];
        int i = 0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(coord)) {
                case 0: {
                    if (v != null) {
                        v.add(new Point2D.Double(coord[0], coord[1]));
                    }
                    ++i;
                    break;
                }
                case 1: {
                    if (v != null) {
                        v.add(new Point2D.Double(coord[0], coord[1]));
                    }
                    ++i;
                    break;
                }
            }
            pi.next();
        }
        return i;
    }

    public double calculateTriangleArea(double x1, double y1, double x2, double y2, double x3, double y3) {
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        double h = line.ptLineDist(x3, y3);
        double d = Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
        return h * d / 2.0;
    }

    public double calculateArea() {
        Line2D.Double line;
        Vector vertex = new Vector();
        int n = this.getVertexes(vertex);
        if (n < 3 || !this.closed) {
            return 0.0;
        }
        double area = 0.0;
        int i = 1;
        while (i < n) {
            line = new Line2D.Double(((Point2D)vertex.get(i - 1)).getX(), ((Point2D)vertex.get(i - 1)).getY(), ((Point2D)vertex.get(i)).getX(), ((Point2D)vertex.get(i)).getY());
            area += (double)line.relativeCCW(0.0, 0.0) * line.ptLineDist(0.0, 0.0) * ((Point2D)vertex.get(i - 1)).distance((Point2D)vertex.get(i)) / 2.0;
            ++i;
        }
        line = new Line2D.Double(((Point2D)vertex.get(n - 1)).getX(), ((Point2D)vertex.get(n - 1)).getY(), ((Point2D)vertex.get(0)).getX(), ((Point2D)vertex.get(0)).getY());
        return Math.abs(area += (double)line.relativeCCW(0.0, 0.0) * line.ptLineDist(0.0, 0.0) * ((Point2D)vertex.get(n - 1)).distance((Point2D)vertex.get(0)) / 2.0);
    }

    public double calculatePerimeter(int mode) {
        PathIterator pi = this.shape.getPathIterator(null);
        double[] coord = new double[6];
        double startX = 0.0;
        double startY = 0.0;
        double vx = 0.0;
        double vy = 0.0;
        if (pi.currentSegment(coord) == 0) {
            startX = coord[0];
            startY = coord[1];
        }
        int count = 0;
        double perimeter = 0.0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(coord)) {
                case 0: {
                    vx = coord[0];
                    vy = coord[1];
                    break;
                }
                case 1: {
                    ++count;
                    perimeter = mode == 2 ? (perimeter += Math.sqrt(Math.pow(vx - coord[0], 2.0) + 1.038055 * Math.pow(vy - coord[1], 2.0))) : (perimeter += Math.sqrt(Math.pow(vx - coord[0], 2.0) + Math.pow(vy - coord[1], 2.0)));
                    vx = coord[0];
                    vy = coord[1];
                    break;
                }
                case 4: {
                    if (mode == 2) {
                        perimeter += Math.sqrt(Math.pow(vx - startX, 2.0) + 1.038055 * Math.pow(vy - startY, 2.0));
                        break;
                    }
                    perimeter += Math.sqrt(Math.pow(vx - startX, 2.0) + Math.pow(vy - startY, 2.0));
                }
            }
            pi.next();
        }
        return perimeter;
    }

    public void moveVertex(int vi, int x, int y) {
        float[] coord = new float[6];
        GeneralPath gp = new GeneralPath();
        PathIterator pi = this.shape.getPathIterator(null);
        int i = 0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(coord)) {
                case 0: {
                    if (i == vi) {
                        gp.moveTo(x, y);
                        break;
                    }
                    gp.moveTo((int)coord[0], (int)coord[1]);
                    break;
                }
                case 1: {
                    if (i == vi) {
                        gp.lineTo(x, y);
                        break;
                    }
                    gp.lineTo((int)coord[0], (int)coord[1]);
                    break;
                }
                case 4: {
                    gp.closePath();
                }
            }
            pi.next();
            ++i;
        }
        this.shape = gp;
    }

    public int addVertex(int x, int y) {
        int px = 0;
        int py = 0;
        int startX = 0;
        int startY = 0;
        float[] coord = new float[6];
        GeneralPath gp = new GeneralPath();
        PathIterator pi = this.shape.getPathIterator(null);
        int index = 0;
        boolean added = false;
        while (!pi.isDone()) {
            switch (pi.currentSegment(coord)) {
                case 0: {
                    gp.moveTo((int)coord[0], (int)coord[1]);
                    startX = (int)coord[0];
                    startY = (int)coord[1];
                    px = (int)coord[0];
                    py = (int)coord[1];
                    break;
                }
                case 1: {
                    if (!added && XShape.onLine(px, py, (int)coord[0], (int)coord[1], x, y, 3)) {
                        gp.lineTo(x, y);
                        gp.lineTo((int)coord[0], (int)coord[1]);
                        added = true;
                    } else {
                        gp.lineTo((int)coord[0], (int)coord[1]);
                    }
                    px = (int)coord[0];
                    py = (int)coord[1];
                    break;
                }
                case 4: {
                    if (!added && XShape.onLine(px, py, startX, startY, x, y, 3)) {
                        gp.lineTo(x, y);
                        gp.closePath();
                        added = true;
                        break;
                    }
                    gp.closePath();
                }
            }
            pi.next();
            if (added) continue;
            ++index;
        }
        this.shape = gp;
        return index;
    }
}

