/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.math.BigDecimal;
import javax.swing.JPanel;

public class SidePanel
extends JPanel {
    private static final BasicStroke stroke = new BasicStroke(5.0f, 1, 1);
    private float initialWeight;

    public SidePanel() {
        this.setLayout(null);
    }

    public Component add(Component component) {
        int n = this.getCurrentRow();
        int n2 = this.getCurrentColumn();
        super.add(component);
        component.setBounds(6 + n2 * 33, this.getHeight() - n * 33 - 5, 32, 32);
        return component;
    }

    public float getWeight() {
        float f = 0.0f;
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Item)) continue;
            f += ((Item)componentArray[i]).getWeight();
        }
        BigDecimal bigDecimal = new BigDecimal(f);
        bigDecimal = bigDecimal.setScale(3, 4);
        return bigDecimal.floatValue();
    }

    private int getCurrentRow() {
        int n = this.getComponentCount();
        return n / 5 + 1;
    }

    private int getCurrentColumn() {
        int n = this.getComponentCount();
        return n % 5;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(stroke);
        graphics2D.drawLine(2, this.getHeight() - 3, this.getWidth() - 7, this.getHeight() - 3);
        graphics2D.drawLine(2, this.getHeight() - 3, 2, this.getHeight() - 30);
        graphics2D.drawLine(this.getWidth() - 7, this.getHeight() - 3, this.getWidth() - 7, this.getHeight() - 30);
    }
}

