/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.data.DefaultPieDataset;
import org.jfree.data.DefaultTableXYDataset;
import org.jfree.data.XYSeries;

public class PlotFrame
extends JFrame {
    JFreeChart chart;
    ChartPanel chartPanel;
    Color bgColor = Color.white;
    Color fgColor = Color.red;
    Color[] random_colors = new Color[]{Color.red, Color.blue, Color.green, Color.orange, Color.magenta, Color.black, Color.cyan, Color.gray};
    int type;
    int cur_section = -1;
    Color[] section_colors;
    final int BAR = 1;
    final int XY = 2;
    final int DOTS = 1;
    final int LINES = 2;
    final int LINES_DOTS = 3;
    final int VERTICAL = 1;
    final int HORIZONTAL = 2;
    Vector data;
    String[] cat;
    private JToggleButton jToggleButton3;
    private JButton jButton1;
    private JToggleButton jToggleButton5;
    private JToggleButton jToggleButton2;
    private JPanel mainPanel;
    private ButtonGroup buttonGroup1;
    private JToggleButton jToggleButton7;
    private JPanel jPanel1;
    private JToggleButton jToggleButton6;
    private JToggleButton jToggleButton1;

    public PlotFrame(int type, Vector data) {
        this.initComponents();
        this.data = data;
        this.type = type;
        this.setTitle("\u0394\u03b7\u03bc\u03b9\u03bf\u03c5\u03c1\u03b3\u03af\u03b1 \u0393\u03c1\u03b1\u03c6\u03ae\u03bc\u03b1\u03c4\u03bf\u03c2");
        this.setSize(500, 400);
        this.setLocation(300, 200);
        this.show();
        this.setButtonsVisible(false);
        int rand_index = 0;
        this.section_colors = new Color[data.size() / 2];
        for (int i = 0; i < this.section_colors.length; ++i) {
            this.section_colors[i] = this.random_colors[rand_index++];
            if (rand_index != this.random_colors.length) continue;
            rand_index = 0;
        }
        if (type == 1) {
            this.jToggleButton1.setVisible(true);
            this.jToggleButton2.setVisible(true);
            this.jToggleButton3.setVisible(true);
            this.jToggleButton1.setSelected(true);
            this.jToggleButton1.doClick();
        }
        if (type == 2) {
            this.jToggleButton5.setVisible(true);
            this.jToggleButton6.setVisible(true);
            this.jToggleButton7.setVisible(true);
            this.jToggleButton5.setSelected(true);
            this.jToggleButton5.doClick();
        }
    }

    private void setButtonsVisible(boolean status) {
        this.jToggleButton1.setVisible(status);
        this.jToggleButton2.setVisible(status);
        this.jToggleButton3.setVisible(status);
        this.jToggleButton5.setVisible(status);
        this.jToggleButton6.setVisible(status);
        this.jToggleButton7.setVisible(status);
    }

    private void createChart() {
        this.chartPanel = null;
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setHorizontalZoom(true);
        this.chartPanel.setVerticalZoom(true);
        this.chartPanel.setHorizontalAxisTrace(false);
        this.chartPanel.setVerticalAxisTrace(false);
        this.chartPanel.setFillZoomRectangle(true);
        this.chartPanel.setPreferredSize(new Dimension(500, 270));
        this.mainPanel.removeAll();
        this.mainPanel.add((Component)this.chartPanel, "Center");
        this.validate();
    }

    private JFreeChart createBar(int type) {
        String Title = "";
        String yTitle = "";
        String xTitle = "";
        this.cat = new String[this.data.size() / 2];
        int pos = 0;
        for (int i = 0; i < this.data.size(); i += 2) {
            this.cat[pos++] = (String)this.data.get(i);
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        pos = 0;
        for (int i = 1; i < this.data.size(); i += 2) {
            dataset.addValue(Double.parseDouble((String)this.data.get(i)), (Comparable)((Object)this.cat[pos]), (Comparable)((Object)this.cat[pos]));
            ++pos;
        }
        PlotOrientation por = PlotOrientation.VERTICAL;
        if (type == 2) {
            por = PlotOrientation.HORIZONTAL;
        }
        JFreeChart chart = ChartFactory.createBarChart(Title, yTitle, xTitle, dataset, por, true, true, false);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint(this.bgColor);
        CategoryItemRenderer renderer = plot.getRenderer();
        for (int i = 0; i < this.data.size() / 2; ++i) {
            if (this.section_colors[i] == null) continue;
            renderer.setSeriesPaint(i, this.section_colors[i]);
        }
        plot.setRenderer(renderer);
        return chart;
    }

    private JFreeChart createPie() {
        String Title = "";
        DefaultPieDataset dataset = new DefaultPieDataset();
        for (int i = 0; i < this.data.size(); ++i) {
            dataset.setValue((Comparable)((Object)((String)this.data.get(i++))), new Double((String)this.data.get(i)));
        }
        JFreeChart chart = ChartFactory.createPieChart(Title, dataset, true, true, false);
        PiePlot plot = (PiePlot)chart.getPlot();
        for (int i = 0; i < this.data.size() / 2; ++i) {
            if (this.section_colors[i] == null) continue;
            plot.setSectionPaint(i, this.section_colors[i]);
        }
        plot.setBackgroundPaint(this.bgColor);
        return chart;
    }

    private JFreeChart createXY(int type) {
        String Title = "";
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        XYSeries series1 = new XYSeries("", false);
        for (int i = 0; i < this.data.size(); ++i) {
            series1.add(Double.parseDouble((String)this.data.get(i++)), Double.parseDouble((String)this.data.get(i)));
        }
        dataset.addSeries(series1);
        JFreeChart chart = ChartFactory.createXYLineChart(Title, "X", "Y", dataset, PlotOrientation.VERTICAL, true, true, false);
        XYPlot plot = chart.getXYPlot();
        plot.setRenderer(new StandardXYItemRenderer(type));
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, this.fgColor);
        plot.setBackgroundPaint(this.bgColor);
        return chart;
    }

    public JToggleButton getSelectedButton() {
        if (this.jToggleButton1.isSelected()) {
            return this.jToggleButton1;
        }
        if (this.jToggleButton2.isSelected()) {
            return this.jToggleButton2;
        }
        if (this.jToggleButton3.isSelected()) {
            return this.jToggleButton3;
        }
        if (this.jToggleButton5.isSelected()) {
            return this.jToggleButton5;
        }
        if (this.jToggleButton6.isSelected()) {
            return this.jToggleButton6;
        }
        if (this.jToggleButton7.isSelected()) {
            return this.jToggleButton7;
        }
        return null;
    }

    public void setBgColor(Color c, int cur_section) {
        this.bgColor = c;
        this.getSelectedButton().doClick();
    }

    public void setFgColor(Color c, int cur_section) {
        this.fgColor = c;
        this.cur_section = cur_section;
        if (cur_section >= 0) {
            this.section_colors[cur_section] = this.fgColor;
        }
        this.getSelectedButton().doClick();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jToggleButton1 = new JToggleButton();
        this.jToggleButton2 = new JToggleButton();
        this.jToggleButton3 = new JToggleButton();
        this.jToggleButton5 = new JToggleButton();
        this.jToggleButton6 = new JToggleButton();
        this.jToggleButton7 = new JToggleButton();
        this.mainPanel = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PlotFrame.this.exitForm(evt);
            }
        });
        this.jButton1.setText("\u03a7\u03c1\u03ce\u03bc\u03b1\u03c4\u03b1");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.jToggleButton1.setText("\u039a\u03ac\u03b8\u03b5\u03c4\u03b5\u03c2 \u039c\u03c0\u03ac\u03c1\u03b5\u03c2");
        this.buttonGroup1.add(this.jToggleButton1);
        this.jToggleButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotFrame.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jToggleButton1);
        this.jToggleButton2.setText("\u039f\u03c1\u03b9\u03b6\u03cc\u03bd\u03c4\u03b9\u03b5\u03c2 \u039c\u03c0\u03ac\u03c1\u03b5\u03c2");
        this.buttonGroup1.add(this.jToggleButton2);
        this.jToggleButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotFrame.this.jToggleButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jToggleButton2);
        this.jToggleButton3.setText("\u03a0\u03af\u03c4\u03b1");
        this.buttonGroup1.add(this.jToggleButton3);
        this.jToggleButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotFrame.this.jToggleButton3ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jToggleButton3);
        this.jToggleButton5.setText("\u0393\u03c1\u03ac\u03c6\u03b7\u03bc\u03b1");
        this.buttonGroup1.add(this.jToggleButton5);
        this.jToggleButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotFrame.this.jToggleButton5ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jToggleButton5);
        this.jToggleButton6.setText("\u0393\u03c1\u03ac\u03c6\u03b7\u03bc\u03b1 (\u03b3\u03c1\u03b1\u03bc\u03bc\u03ad\u03c2)");
        this.buttonGroup1.add(this.jToggleButton6);
        this.jToggleButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotFrame.this.jToggleButton6ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jToggleButton6);
        this.jToggleButton7.setText("\u0393\u03c1\u03ac\u03c6\u03b7\u03bc\u03b1 (\u03c3\u03b7\u03bc\u03b5\u03af\u03b1)");
        this.buttonGroup1.add(this.jToggleButton7);
        this.jToggleButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotFrame.this.jToggleButton7ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jToggleButton7);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.mainPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int data_size = -1;
        if (this.type == 1) {
            data_size = this.data.size() / 2;
        }
        ColorChooser cc = new ColorChooser(this, data_size, this.cat);
    }

    private void jToggleButton7ActionPerformed(ActionEvent evt) {
        this.chart = this.createXY(1);
        this.createChart();
    }

    private void jToggleButton6ActionPerformed(ActionEvent evt) {
        this.chart = this.createXY(2);
        this.createChart();
    }

    private void jToggleButton5ActionPerformed(ActionEvent evt) {
        this.chart = this.createXY(3);
        this.createChart();
    }

    private void jToggleButton3ActionPerformed(ActionEvent evt) {
        this.chart = this.createPie();
        this.createChart();
    }

    private void jToggleButton2ActionPerformed(ActionEvent evt) {
        this.chart = this.createBar(2);
        this.createChart();
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.chart = this.createBar(1);
        this.createChart();
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

