/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Random;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GridDrawApplet
extends Applet {
    private GridCanvas grid;
    private CPalette palette;
    private PropertyPanel props;
    private int rotateDir = 1;
    private long randomMax;
    private Random random;
    private Vector images;
    private StatisticsFrame stat;
    private int statCount;
    private static final int NONE = 0;
    private static final int DRAW_LINE = 1;
    private static final int DRAWING_LINE = 2;
    private static final int DRAW_TRIANGLE = 3;
    private static final int DRAW_SQUARE = 4;
    private static final int DRAW_CIRCLE = 5;
    private static final int DRAW_HEXAGON = 6;
    private static final int DRAW_DIAMOND = 7;
    private static final int DRAW_TRAPEZOID = 8;
    private static final int MOVE_SHAPE = 10;
    private static final int MOVING_SHAPE = 11;
    private static final int RESIZE_SHAPE = 12;
    private static final int RESIZING_SHAPE = 13;
    private static final int ERASE_SHAPE = 14;
    private static final int ROTATE_SHAPE = 15;
    private static final int ROTATING_SHAPE = 16;
    private static final int CUT_SHAPE = 17;
    private static final int DEFINE_CUT_SHAPE = 18;
    private static final int CALCULATE = 19;
    private static final int DRAW_UNARY_SQUARE = 20;
    private static final int DRAW_UNARY_TRIANGLE = 21;
    private static final int DRAG_VERTEX = 22;
    private static final int DRAGING_VERTEX = 23;
    private static final int MEASURE_DISTANCE = 24;
    private static final int MEASURING_DISTANCE = 25;
    private static final int MEASURE_ANGLE = 26;
    private static final int MEASURING_ANGLE1 = 27;
    private static final int MEASURING_ANGLE2 = 28;
    private static final int DRAW_POINT = 30;
    private static final int HANDLE_POINT = 31;
    private static final int MOVING_POINT = 32;
    private static final int PAINT_SHAPE = 35;
    private static final int MIRROR_SHAPE = 36;
    private static final int SET_AXIS = 37;
    private static final int SETING_AXIS = 38;
    private static final int COD_BASED = 1111;
    private static final int DOC_BASED = 2222;
    private int status;
    private Graphics gridGraph;
    private Point lastPoint;
    private Point extraPoint;
    private int pointCounter;
    private double rotationAngle;
    private double resizeFactor;
    private JSeparator jSeparator9;
    private JToggleButton butSquare;
    private JMenuItem miDiv3;
    private JMenuItem miDiv2;
    private JSeparator jSeparator8;
    private JSeparator jSeparator13;
    private JSeparator jSeparator7;
    private JSeparator jSeparator12;
    private JSeparator jSeparator11;
    private JTextField textInfo;
    private JSeparator jSeparator6;
    private JSeparator jSeparator10;
    private JToggleButton butAxisTool;
    private JSeparator jSeparator5;
    private JSeparator jSeparator4;
    private JSeparator jSeparator3;
    private JSeparator jSeparator2;
    private JSeparator jSeparator1;
    private JToggleButton butRuler;
    private JToggleButton butRotateTool;
    private JMenuItem miR180;
    private JMenuItem miR60;
    private JMenuItem miHPDelete;
    private JToggleButton butTrapezoid;
    private JToggleButton butCalculate;
    private JPopupMenu popResize;
    private JButton butCalculator;
    private JToggleButton butSqrGridDots;
    private JMenuItem miImgCancel;
    private JToggleButton butHexagon;
    private JMenuItem miNoImage;
    private JToggleButton butEraseTool;
    private JCheckBox checkDekadika;
    private JTextField textArea;
    private JToggleButton butDragVertex;
    private JTextField textPerim;
    private ButtonGroup butGroupRotateDir;
    private JToggleButton butTrgGridLines;
    private JButton butValTable;
    private JMenuItem resizeCancel;
    private JToggleButton butResizeTool;
    private JMenuItem miR90;
    private JButton butClear;
    private JMenuItem miLocalFile;
    private Panel rightPanel;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JMenuItem miAxisSet;
    private JToggleButton butAngleRuler;
    private JPopupMenu popLoadImage;
    private ButtonGroup butGroupMode;
    private JButton butZari;
    private JMenuItem miHPCancel;
    private Panel leftPanel;
    private JRadioButtonMenuItem rotateCCW;
    private JToggleButton butCutTool;
    private JToggleButton butTrgGridDots;
    private JMenuItem miR45;
    private JPopupMenu popHandlePoint;
    private JMenuItem miAxisCancel;
    private JMenuItem rotateCancel;
    private JToggleButton butUSquare;
    private JToggleButton butCircle;
    private Panel topPanel;
    private Panel panel1;
    private JMenuItem miMul5;
    private JButton butPrint;
    private JToggleButton butDrawPoint;
    private JMenuItem miMul3;
    private JToggleButton butMoveTool;
    private JMenuItem miMul2;
    private JToggleButton butTriangle;
    private JButton butNotepad;
    private JButton butSave;
    private JToggleButton butUTriangle;
    private Panel bottomPanel;
    private ButtonGroup butGroupDrawTools;
    private JToggleButton butLine;
    private JToggleButton butDiamond;
    private JMenuItem miR30;
    private JPopupMenu popAxis;
    private JButton butBitmap;
    private JRadioButtonMenuItem rotateCW;
    private JPopupMenu popRotate;
    private JToggleButton butNoGrid;
    private JToggleButton butHandlePoint;
    private JButton butLoad;
    private JToggleButton butSqrGridLines;
    private JMenuItem miDiv5;

    public void init() {
        String loadFile;
        Image img;
        this.randomMax = 6L;
        this.random = new Random(System.currentTimeMillis());
        this.images = new Vector();
        MediaTracker tracker = new MediaTracker(this);
        String imgparam = this.getParameter("image");
        String[] imgname = imgparam.split(":");
        int i = 0;
        while (i < imgname.length) {
            Image img2 = this.getImage(this.getDocumentBase(), imgname[i]);
            if (img2 != null) {
                tracker.addImage(img2, 0);
                try {
                    tracker.waitForID(0);
                }
                catch (InterruptedException e) {
                    System.err.println("Media tracker error -> " + e.toString());
                }
                this.images.add(new LoadableImage(img2, imgname[i]));
            }
            ++i;
        }
        this.initComponents();
        this.props.disableSnap();
        this.grid = new GridCanvas(20, 0, false, false, false, null);
        this.add((Component)this.grid, "Center");
        this.gridGraph = this.grid.getGraphics();
        String defaultImg = this.getParameter("default");
        if (defaultImg != null && (img = this.getImage(this.getDocumentBase(), defaultImg)) != null) {
            tracker.addImage(img, 0);
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException e) {
                System.err.println("Media tracker error -> " + e.toString());
            }
            this.grid.setImage(img);
        }
        if ((loadFile = this.getParameter("load")) != null) {
            try {
                URL source = new URL(this.getDocumentBase(), loadFile);
                this.loadGDA(source.openStream());
            }
            catch (IOException e) {
                System.out.println(e.toString());
            }
        }
        this.textInfo.setColumns(41);
        this.palette.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                GridDrawApplet.this.palettePropertyChange(evt);
            }
        });
        this.props.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                GridDrawApplet.this.propsPropertyChange(evt);
            }
        });
        this.grid.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.gridMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                GridDrawApplet.this.gridMouseReleased(evt);
            }
        });
        this.grid.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                GridDrawApplet.this.gridMouseMoved(evt);
            }

            public void mouseDragged(MouseEvent evt) {
                GridDrawApplet.this.gridMouseDragged(evt);
            }
        });
        this.grid.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                GridDrawApplet.this.gridCanvasMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                GridDrawApplet.this.gridCanvasMouseExited(evt);
            }
        });
        this.grid.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                GridDrawApplet.this.gridCanvasKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                GridDrawApplet.this.gridCanvasKeyReleased(evt);
            }
        });
    }

    private Icon myLoadImage(String fileName) {
        return new ImageIcon(this.getImage(this.getDocumentBase(), fileName));
    }

    private Icon myLoadIcon(String fileName) {
        return new ImageIcon(this.getImage(this.getCodeBase(), fileName));
    }

    private void gridCanvasKeyReleased(KeyEvent evt) {
        if (!(evt.isControlDown() || this.status != 1 && this.status != 2)) {
            if (this.pointCounter >= 2) {
                this.grid.setShapeClosed(true);
            }
            if (this.status == 2) {
                this.grid.activeShapeDrawLineTo(this.lastPoint.x, this.lastPoint.y);
            }
        }
    }

    private void gridCanvasKeyPressed(KeyEvent evt) {
        if (evt.isControlDown() && (this.status == 1 || this.status == 2)) {
            this.grid.setShapeClosed(false);
            if (this.status == 2) {
                this.grid.activeShapeDrawLineTo(this.lastPoint.x, this.lastPoint.y);
            }
        }
    }

    private void gridCanvasMouseEntered(MouseEvent evt) {
        Cursor cur = new Cursor(1);
        this.setCursor(cur);
        if (!evt.isControlDown() && this.pointCounter >= 2) {
            this.grid.setShapeClosed(true);
        }
    }

    private void gridCanvasMouseExited(MouseEvent evt) {
        Cursor cur = new Cursor(0);
        this.setCursor(cur);
    }

    private void gridMouseMoved(MouseEvent evt) {
        Point pnt = evt.getPoint();
        Point spnt = this.grid.snap(pnt);
        this.textInfo.setText("\u03a3\u03c5\u03bd\u03c4/\u03bd\u03b5\u03c2:  x = " + String.valueOf(pnt.x) + " \u03b5\u03b9\u03ba\u03bf\u03bd\u03bf\u03c3\u03c4\u03bf\u03b9\u03c7\u03b5\u03af\u03b1  -  y = " + String.valueOf(this.grid.getHeight() - pnt.y - 1) + " \u03b5\u03b9\u03ba\u03bf\u03bd\u03bf\u03c3\u03c4\u03bf\u03b9\u03c7\u03b5\u03af\u03b1");
        switch (this.status) {
            case 2: {
                this.grid.activeShapeDrawLineTo(spnt.x, spnt.y);
                this.lastPoint = spnt;
                break;
            }
            case 10: {
                this.grid.checkShapeSelection(pnt);
                break;
            }
            case 14: {
                this.grid.checkShapeSelection(pnt);
                break;
            }
            case 15: {
                this.grid.checkShapeSelection(pnt);
                break;
            }
            case 12: {
                this.grid.checkShapeSelection(pnt);
                break;
            }
            case 35: {
                this.grid.checkShapeSelection(pnt);
                break;
            }
            case 18: {
                this.grid.drawDashedLine(this.lastPoint.x, this.lastPoint.y, spnt.x, spnt.y);
                break;
            }
            case 22: {
                this.grid.checkVertexSelection(pnt);
                break;
            }
            case 19: {
                if (this.grid.checkShapeSelection(pnt)) {
                    double p = this.grid.calcActiveShapePerimeter();
                    double a = this.grid.calcActiveShapeArea();
                    if (!this.checkDekadika.isSelected()) {
                        p = Math.round(p);
                        a = Math.round(a);
                    }
                    String perim = String.valueOf(p);
                    perim = this.strPrecision(perim, 2);
                    String area = String.valueOf(a);
                    area = this.strPrecision(area, 2);
                    this.textPerim.setText(perim);
                    this.textArea.setText(area);
                    break;
                }
                this.textPerim.setText("");
                this.textArea.setText("");
                break;
            }
            case 25: {
                this.grid.drawDashedLine(this.lastPoint.x, this.lastPoint.y, pnt.x, pnt.y);
                double dist = this.grid.measureDistance(this.lastPoint, pnt);
                this.textInfo.setText(this.textInfo.getText() + "    \u0391\u03c0\u03cc\u03c3\u03c4\u03b1\u03c3\u03b7: " + this.strPrecision(String.valueOf(dist), 2) + " \u03bc\u03bf\u03bd.\u03c0\u03bb.");
                break;
            }
            case 27: {
                this.grid.drawDashedLine(this.lastPoint.x, this.lastPoint.y, pnt.x, pnt.y);
                break;
            }
            case 28: {
                this.grid.drawDashedAngle(this.lastPoint.x, this.lastPoint.y, this.extraPoint.x, this.extraPoint.y, pnt.x, pnt.y);
                double angle = Math.toDegrees(this.grid.measureAngle(this.lastPoint, this.extraPoint, pnt));
                this.textInfo.setText(this.textInfo.getText() + "    \u0393\u03c9\u03bd\u03af\u03b1: " + this.strPrecision(String.valueOf(angle), 2) + " \u03bc\u03bf\u03af\u03c1\u03b5\u03c2");
                break;
            }
            case 31: {
                this.grid.checkPointSelection(pnt);
                break;
            }
            case 38: {
                this.grid.drawDashedLine(this.lastPoint.x, this.lastPoint.y, spnt.x, spnt.y);
                break;
            }
            case 36: {
                this.grid.checkShapeSelection(pnt);
            }
        }
    }

    private String strPrecision(String str, int n) {
        int len = str.length();
        int i = str.indexOf(46);
        if (i > -1) {
            if (this.checkDekadika.isSelected()) {
                if (len - i - 1 > n) {
                    str = str.substring(0, i + n + 1);
                }
            } else {
                str = str.substring(0, i);
            }
        }
        return new String(str);
    }

    private void gridMousePressed(MouseEvent evt) {
        Point pnt = evt.getPoint();
        Point spnt = this.grid.snap(pnt);
        if (evt.getButton() == 1) {
            switch (this.status) {
                case 1: {
                    ++this.pointCounter;
                    this.grid.activeShapeMoveTo(spnt.x, spnt.y);
                    this.status = 2;
                    this.lastPoint = spnt;
                    break;
                }
                case 2: {
                    ++this.pointCounter;
                    this.grid.activeShapeLineTo(spnt.x, spnt.y);
                    this.lastPoint = spnt;
                    this.grid.setShapeClosed(true);
                    break;
                }
                case 3: {
                    this.grid.addTriangle(spnt.x, spnt.y);
                    break;
                }
                case 21: {
                    this.grid.addUTriangle(pnt);
                    break;
                }
                case 4: {
                    this.grid.addSquare(spnt.x, spnt.y);
                    break;
                }
                case 20: {
                    this.grid.addUSquare(pnt);
                    break;
                }
                case 8: {
                    this.grid.addTrapezoid(spnt.x, spnt.y);
                    break;
                }
                case 7: {
                    this.grid.addDiamond(spnt.x, spnt.y);
                    break;
                }
                case 6: {
                    this.grid.addHexagon(spnt.x, spnt.y);
                    break;
                }
                case 5: {
                    this.grid.addCircle(spnt.x, spnt.y);
                    break;
                }
                case 10: {
                    if (!this.grid.checkShapeSelection(pnt)) break;
                    this.lastPoint = spnt;
                    this.status = 11;
                    if (!evt.isShiftDown()) break;
                    this.grid.copyActiveShape();
                    break;
                }
                case 15: {
                    if (!this.grid.checkShapeSelection(pnt)) break;
                    this.lastPoint = pnt;
                    this.status = 16;
                    if (evt.isShiftDown()) {
                        this.grid.copyActiveShape();
                    }
                    this.rotationAngle = 0.0;
                    break;
                }
                case 12: {
                    if (!this.grid.checkShapeSelection(pnt)) break;
                    this.lastPoint = pnt;
                    this.status = 13;
                    if (evt.isShiftDown()) {
                        this.grid.copyActiveShape();
                    }
                    this.resizeFactor = 1.0;
                    break;
                }
                case 14: {
                    if (!this.grid.checkShapeSelection(pnt)) break;
                    this.grid.deleteActiveShape();
                    break;
                }
                case 35: {
                    if (!this.grid.checkShapeSelection(pnt)) break;
                    this.grid.repaintActiveShape();
                    this.grid.forceBackRepaint();
                    break;
                }
                case 17: {
                    this.lastPoint = spnt;
                    this.status = 18;
                    break;
                }
                case 18: {
                    this.grid.drawDashedLine(this.lastPoint.x, this.lastPoint.y, spnt.x, spnt.y);
                    this.grid.cutShape(this.lastPoint.x, this.lastPoint.y, spnt.x, spnt.y);
                    this.status = 17;
                    break;
                }
                case 30: {
                    this.grid.addPoint(spnt.x, spnt.y);
                    break;
                }
                case 22: {
                    if (this.grid.checkVertexSelection(pnt)) {
                        this.status = 23;
                        break;
                    }
                    if (!this.grid.checkShapeSelection(pnt)) break;
                    this.grid.activeShapeAddVertex(pnt);
                    this.status = 23;
                    break;
                }
                case 24: {
                    this.lastPoint = pnt;
                    this.status = 25;
                    break;
                }
                case 25: {
                    this.status = 24;
                    break;
                }
                case 26: {
                    this.lastPoint = pnt;
                    this.status = 27;
                    break;
                }
                case 27: {
                    this.extraPoint = pnt;
                    this.status = 28;
                    break;
                }
                case 28: {
                    this.status = 26;
                    break;
                }
                case 31: {
                    if (!this.grid.checkPointSelection(pnt)) break;
                    this.status = 32;
                    break;
                }
                case 37: {
                    this.status = 38;
                    this.lastPoint = spnt;
                    break;
                }
                case 38: {
                    this.grid.setAxis(this.lastPoint, spnt);
                    this.status = 36;
                    break;
                }
                case 36: {
                    if (!this.grid.checkShapeSelection(pnt)) break;
                    if (evt.isShiftDown()) {
                        this.grid.copyActiveShape();
                    }
                    this.grid.mirrorActiveShape();
                    this.grid.forceBackRepaint();
                    break;
                }
                case 19: {
                    if (!this.grid.checkShapeSelection(pnt) || this.stat == null) break;
                    if (this.statCount == 0) {
                        this.stat.addData("\u039c\u03ad\u03c4\u03c1\u03b7\u03c3\u03b7 \u039c\u03ae\u03ba\u03bf\u03c2 \u0395\u03bc\u03b2\u03b1\u03b4\u03cc\u03bd");
                    }
                    ++this.statCount;
                    this.stat.addData("#" + this.statCount + " " + this.textPerim.getText() + " " + this.textArea.getText());
                }
            }
        } else {
            switch (this.status) {
                case 2: {
                    this.grid.activeShapeLineTo(spnt.x, spnt.y);
                    this.grid.activeShapeClose();
                    this.status = 1;
                    this.pointCounter = 0;
                    this.grid.setShapeClosed(false);
                    break;
                }
                case 12: {
                    if (!this.grid.checkShapeSelection(pnt)) break;
                    this.lastPoint = pnt;
                    this.popResize.show(this.grid, pnt.x, pnt.y);
                    break;
                }
                case 15: {
                    if (!this.grid.checkShapeSelection(pnt)) break;
                    this.lastPoint = pnt;
                    this.popRotate.show(this.grid, pnt.x, pnt.y);
                    break;
                }
                case 31: {
                    if (!this.grid.checkPointSelection(pnt)) break;
                    this.popHandlePoint.show(this.grid, pnt.x, pnt.y);
                }
            }
        }
    }

    private void gridMouseReleased(MouseEvent evt) {
        switch (this.status) {
            case 11: {
                this.grid.forceBackRepaint();
                this.status = 10;
                break;
            }
            case 16: {
                this.grid.forceBackRepaint();
                this.status = 15;
                break;
            }
            case 13: {
                this.grid.forceBackRepaint();
                this.status = 12;
                break;
            }
            case 23: {
                this.grid.forceBackRepaint();
                this.status = 22;
                break;
            }
            case 32: {
                this.grid.forceBackRepaint();
                this.status = 31;
            }
        }
    }

    private void gridMouseDragged(MouseEvent evt) {
        Point pnt = evt.getPoint();
        Point spnt = this.grid.snap(pnt);
        switch (this.status) {
            case 11: {
                this.grid.moveActiveShape(spnt.x - this.lastPoint.x, spnt.y - this.lastPoint.y);
                this.lastPoint = spnt;
                break;
            }
            case 16: {
                this.rotationAngle -= this.grid.rotateActiveShape(this.lastPoint, pnt, 0);
                this.textInfo.setText(" \u03a0\u03b5\u03c1\u03b9\u03c3\u03c4\u03c1\u03bf\u03c6\u03ae: " + this.strPrecision(String.valueOf(Math.toDegrees(this.rotationAngle)), 2) + " \u03bc\u03bf\u03af\u03c1\u03b5\u03c2");
                this.lastPoint = pnt;
                break;
            }
            case 13: {
                this.resizeFactor *= this.grid.resizeActiveShape(pnt.x - this.lastPoint.x, pnt.y - this.lastPoint.y);
                this.textInfo.setText(" \u039c\u03ad\u03b3\u03b5\u03b8\u03bf\u03c2: " + this.strPrecision(String.valueOf(this.resizeFactor * 100.0), 2) + " %");
                this.lastPoint = pnt;
                break;
            }
            case 23: {
                this.grid.dragActiveVertex(spnt);
                break;
            }
            case 32: {
                this.grid.moveActivePoint(spnt.x, spnt.y);
            }
        }
    }

    private void palettePropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "selectedColor") {
            this.grid.setColor((Color)evt.getNewValue());
        }
        if (evt.getPropertyName() == "selectedFillColor") {
            this.grid.setFillColor((Color)evt.getNewValue());
        }
    }

    private void propsPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "paint") {
            this.status = 35;
        }
        if (evt.getPropertyName() == "fill") {
            this.grid.setFill((Boolean)evt.getNewValue());
        }
        if (evt.getPropertyName() == "gsize") {
            this.grid.setGridSize((Integer)evt.getNewValue());
        }
        if (evt.getPropertyName() == "snap") {
            this.grid.setDoSnap((Boolean)evt.getNewValue());
        }
    }

    private void initComponents() {
        this.butGroupDrawTools = new ButtonGroup();
        this.butGroupMode = new ButtonGroup();
        this.popResize = new JPopupMenu();
        this.resizeCancel = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.miMul2 = new JMenuItem();
        this.miMul3 = new JMenuItem();
        this.miMul5 = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.miDiv2 = new JMenuItem();
        this.miDiv3 = new JMenuItem();
        this.miDiv5 = new JMenuItem();
        this.popRotate = new JPopupMenu();
        this.rotateCancel = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.miR30 = new JMenuItem();
        this.miR45 = new JMenuItem();
        this.miR60 = new JMenuItem();
        this.miR90 = new JMenuItem();
        this.miR180 = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.rotateCW = new JRadioButtonMenuItem();
        this.rotateCCW = new JRadioButtonMenuItem();
        this.butGroupRotateDir = new ButtonGroup();
        this.popLoadImage = new JPopupMenu();
        int i = 0;
        while (i < this.images.size()) {
            JMenuItem item = new JMenuItem(((LoadableImage)this.images.get((int)i)).name);
            item.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent evt) {
                    GridDrawApplet.this.PLOItemMouseReleased(evt);
                }
            });
            this.popLoadImage.add(item);
            ++i;
        }
        this.jSeparator7 = new JSeparator();
        this.miLocalFile = new JMenuItem();
        this.miNoImage = new JMenuItem();
        this.jSeparator8 = new JSeparator();
        this.miImgCancel = new JMenuItem();
        this.popHandlePoint = new JPopupMenu();
        this.miHPCancel = new JMenuItem();
        this.jSeparator12 = new JSeparator();
        this.miHPDelete = new JMenuItem();
        this.popAxis = new JPopupMenu();
        this.miAxisCancel = new JMenuItem();
        this.jSeparator13 = new JSeparator();
        this.miAxisSet = new JMenuItem();
        this.topPanel = new Panel();
        this.butClear = new JButton();
        this.butLoad = new JButton();
        this.butSave = new JButton();
        this.butPrint = new JButton();
        this.butBitmap = new JButton();
        this.jSeparator5 = new JSeparator();
        this.butNoGrid = new JToggleButton();
        this.butSqrGridDots = new JToggleButton();
        this.butTrgGridDots = new JToggleButton();
        this.butSqrGridLines = new JToggleButton();
        this.butTrgGridLines = new JToggleButton();
        this.jSeparator6 = new JSeparator();
        this.butMoveTool = new JToggleButton();
        this.butRotateTool = new JToggleButton();
        this.butResizeTool = new JToggleButton();
        this.butEraseTool = new JToggleButton();
        this.butCutTool = new JToggleButton();
        this.butDragVertex = new JToggleButton();
        this.butAxisTool = new JToggleButton();
        this.leftPanel = new Panel();
        this.panel1 = new Panel();
        this.palette = new CPalette();
        this.leftPanel.add(this.palette);
        this.props = new PropertyPanel(20, this.myLoadIcon("icons/plus.gif"), this.myLoadIcon("icons/minus.gif"), this.myLoadIcon("icons/tool_paint_medium_x.gif"), this.butGroupDrawTools);
        this.leftPanel.add(this.props);
        this.butCalculate = new JToggleButton();
        this.jLabel1 = new JLabel();
        this.textPerim = new JTextField();
        this.jLabel2 = new JLabel();
        this.textArea = new JTextField();
        this.checkDekadika = new JCheckBox();
        this.rightPanel = new Panel();
        this.butLine = new JToggleButton();
        this.butTriangle = new JToggleButton();
        this.butSquare = new JToggleButton();
        this.butDiamond = new JToggleButton();
        this.butTrapezoid = new JToggleButton();
        this.butHexagon = new JToggleButton();
        this.butCircle = new JToggleButton();
        this.jSeparator9 = new JSeparator();
        this.butUSquare = new JToggleButton();
        this.butUTriangle = new JToggleButton();
        this.butDrawPoint = new JToggleButton();
        this.butHandlePoint = new JToggleButton();
        this.bottomPanel = new Panel();
        this.butCalculator = new JButton();
        this.butNotepad = new JButton();
        this.butValTable = new JButton();
        this.jSeparator10 = new JSeparator();
        this.textInfo = new JTextField();
        this.jSeparator11 = new JSeparator();
        this.butRuler = new JToggleButton();
        this.butAngleRuler = new JToggleButton();
        this.butZari = new JButton();
        this.popResize.setBackground(Color.lightGray);
        this.resizeCancel.setText("\u0386\u03ba\u03c5\u03c1\u03bf");
        this.popResize.add(this.resizeCancel);
        this.popResize.add(this.jSeparator1);
        this.miMul2.setText("x2");
        this.miMul2.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.miMul2MousePressed(evt);
            }
        });
        this.popResize.add(this.miMul2);
        this.miMul3.setText("x3");
        this.miMul3.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.miMul3MousePressed(evt);
            }
        });
        this.popResize.add(this.miMul3);
        this.miMul5.setText("x5");
        this.miMul5.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.miMul5MousePressed(evt);
            }
        });
        this.popResize.add(this.miMul5);
        this.popResize.add(this.jSeparator2);
        this.miDiv2.setText("1:2");
        this.miDiv2.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.miDiv2MousePressed(evt);
            }
        });
        this.popResize.add(this.miDiv2);
        this.miDiv3.setText("1:3");
        this.miDiv3.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.miDiv3MousePressed(evt);
            }
        });
        this.popResize.add(this.miDiv3);
        this.miDiv5.setText("1:5");
        this.miDiv5.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.miDiv5MousePressed(evt);
            }
        });
        this.popResize.add(this.miDiv5);
        this.popRotate.setBackground(Color.lightGray);
        this.rotateCancel.setText("\u0386\u03ba\u03c5\u03c1\u03bf");
        this.popRotate.add(this.rotateCancel);
        this.popRotate.add(this.jSeparator3);
        this.miR30.setText("30 \u03bc\u03bf\u03af\u03c1\u03b5\u03c2");
        this.miR30.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.miR30MousePressed(evt);
            }
        });
        this.popRotate.add(this.miR30);
        this.miR45.setText("45 \u03bc\u03bf\u03af\u03c1\u03b5\u03c2");
        this.miR45.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.miR45MousePressed(evt);
            }
        });
        this.popRotate.add(this.miR45);
        this.miR60.setText("60 \u03bc\u03bf\u03af\u03c1\u03b5\u03c2");
        this.miR60.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.miR60MousePressed(evt);
            }
        });
        this.popRotate.add(this.miR60);
        this.miR90.setText("90 \u03bc\u03bf\u03af\u03c1\u03b5\u03c2");
        this.miR90.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.miR90MousePressed(evt);
            }
        });
        this.popRotate.add(this.miR90);
        this.miR180.setText("180 \u03bc\u03bf\u03af\u03c1\u03b5\u03c2");
        this.miR180.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.miR180MousePressed(evt);
            }
        });
        this.popRotate.add(this.miR180);
        this.popRotate.add(this.jSeparator4);
        this.rotateCW.setSelected(true);
        this.rotateCW.setText("\u0394\u03b5\u03be\u03b9\u03cc\u03c3\u03c4\u03c1\u03bf\u03c6\u03b1");
        this.butGroupRotateDir.add(this.rotateCW);
        this.rotateCW.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.rotateCWMousePressed(evt);
            }
        });
        this.popRotate.add(this.rotateCW);
        this.rotateCCW.setText("\u0391\u03c1\u03b9\u03c3\u03c4\u03b5\u03c1\u03cc\u03c3\u03c4\u03c1\u03bf\u03c6\u03b1");
        this.butGroupRotateDir.add(this.rotateCCW);
        this.rotateCCW.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.rotateCCWMousePressed(evt);
            }
        });
        this.popRotate.add(this.rotateCCW);
        this.popLoadImage.add(this.jSeparator7);
        this.miLocalFile.setText("\u0391\u03c0\u03cc \u03c4\u03bf\u03c0\u03b9\u03ba\u03cc \u03b1\u03c1\u03c7\u03b5\u03af\u03bf...");
        this.miLocalFile.setToolTipText("");
        this.miLocalFile.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                GridDrawApplet.this.miLocalFileMouseReleased(evt);
            }
        });
        this.popLoadImage.add(this.miLocalFile);
        this.miNoImage.setText("\u039a\u03b1\u03bc\u03af\u03b1 \u03b5\u03b9\u03ba\u03cc\u03bd\u03b1");
        this.miNoImage.setToolTipText("");
        this.miNoImage.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                GridDrawApplet.this.miNoImageMouseReleased(evt);
            }
        });
        this.popLoadImage.add(this.miNoImage);
        this.popLoadImage.add(this.jSeparator8);
        this.miImgCancel.setText("\u0391\u03ba\u03cd\u03c1\u03c9\u03c3\u03b7");
        this.miImgCancel.setToolTipText("");
        this.popLoadImage.add(this.miImgCancel);
        this.miHPCancel.setText("\u0386\u03ba\u03c5\u03c1\u03bf");
        this.popHandlePoint.add(this.miHPCancel);
        this.popHandlePoint.add(this.jSeparator12);
        this.miHPDelete.setText("\u0394\u03b9\u03b1\u03b3\u03c1\u03b1\u03c6\u03ae");
        this.miHPDelete.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.miHPDeleteMousePressed(evt);
            }
        });
        this.popHandlePoint.add(this.miHPDelete);
        this.miAxisCancel.setText("\u0386\u03ba\u03c5\u03c1\u03bf");
        this.popAxis.add(this.miAxisCancel);
        this.popAxis.add(this.jSeparator13);
        this.miAxisSet.setText("\u039f\u03c1\u03b9\u03c3\u03bc\u03cc\u03c2 \u03ac\u03be\u03bf\u03bd\u03b1 \u03c3\u03c5\u03bc\u03bc\u03b5\u03c4\u03c1\u03af\u03b1\u03c2");
        this.miAxisSet.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.miAxisSetMousePressed(evt);
            }
        });
        this.popAxis.add(this.miAxisSet);
        this.setLayout(new BorderLayout());
        this.topPanel.setLayout(new FlowLayout(1, 2, 1));
        this.topPanel.setBackground(Color.lightGray);
        this.butClear.setIcon(this.myLoadIcon("icons/clear2.gif"));
        this.butClear.setToolTipText("\u039a\u03b1\u03b8\u03b1\u03c1\u03b9\u03c3\u03bc\u03cc\u03c2 \u03b5\u03c0\u03b9\u03c6\u03ac\u03bd\u03b5\u03b9\u03b1\u03c2 \u03c3\u03c7\u03b5\u03b4\u03af\u03b1\u03c3\u03b7\u03c2");
        this.butClear.setMargin(new Insets(1, 1, 1, 1));
        this.butClear.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GridDrawApplet.this.butClearMouseClicked(evt);
            }
        });
        this.topPanel.add(this.butClear);
        this.butLoad.setIcon(this.myLoadIcon("icons/open.gif"));
        this.butLoad.setToolTipText("\u0391\u03bd\u03ac\u03ba\u03c4\u03b7\u03c3\u03b7");
        this.butLoad.setMargin(new Insets(1, 1, 1, 1));
        this.butLoad.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.butLoadMousePressed(evt);
            }
        });
        this.topPanel.add(this.butLoad);
        this.butSave.setIcon(this.myLoadIcon("icons/save.gif"));
        this.butSave.setToolTipText("\u0391\u03c0\u03bf\u03b8\u03ae\u03ba\u03b5\u03c5\u03c3\u03b7");
        this.butSave.setMargin(new Insets(1, 1, 1, 1));
        this.butSave.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.butSaveMousePressed(evt);
            }
        });
        this.topPanel.add(this.butSave);
        this.butPrint.setIcon(this.myLoadIcon("icons/print.gif"));
        this.butPrint.setToolTipText("\u0395\u03ba\u03c4\u03cd\u03c0\u03c9\u03c3\u03b7");
        this.butPrint.setMargin(new Insets(1, 1, 1, 1));
        this.butPrint.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.butPrintMousePressed(evt);
            }
        });
        this.topPanel.add(this.butPrint);
        this.butBitmap.setIcon(this.myLoadIcon("icons/photo.gif"));
        this.butBitmap.setToolTipText("\u0395\u03b9\u03c3\u03b1\u03b3\u03c9\u03b3\u03ae \u03b5\u03b9\u03ba\u03cc\u03bd\u03b1\u03c2");
        this.butBitmap.setMargin(new Insets(1, 1, 1, 1));
        this.butBitmap.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.butBitmapMousePressed(evt);
            }
        });
        this.topPanel.add(this.butBitmap);
        this.jSeparator5.setBackground(Color.lightGray);
        this.jSeparator5.setForeground(Color.lightGray);
        this.jSeparator5.setOrientation(1);
        this.jSeparator5.setMinimumSize(new Dimension(10, 38));
        this.jSeparator5.setPreferredSize(new Dimension(10, 38));
        this.topPanel.add(this.jSeparator5);
        this.butNoGrid.setIcon(this.myLoadIcon("icons/no_grid.gif"));
        this.butNoGrid.setSelected(true);
        this.butNoGrid.setToolTipText("\u039a\u03b1\u03bd\u03ad\u03bd\u03b1 \u03c0\u03bb\u03ad\u03b3\u03bc\u03b1");
        this.butGroupMode.add(this.butNoGrid);
        this.butNoGrid.setMargin(new Insets(1, 1, 1, 1));
        this.butNoGrid.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butNoGridStateChanged(evt);
            }
        });
        this.topPanel.add(this.butNoGrid);
        this.butSqrGridDots.setIcon(this.myLoadIcon("icons/square_grid_dots.gif"));
        this.butSqrGridDots.setToolTipText("\u03a4\u03b5\u03c4\u03c1\u03b1\u03b3\u03c9\u03bd\u03b9\u03ba\u03cc \u03c0\u03bb\u03ad\u03b3\u03bc\u03b1 (\u03bc\u03cc\u03bd\u03bf \u03ba\u03bf\u03c5\u03ba\u03ba\u03af\u03b4\u03b5\u03c2)");
        this.butGroupMode.add(this.butSqrGridDots);
        this.butSqrGridDots.setMargin(new Insets(1, 1, 1, 1));
        this.butSqrGridDots.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butSqrGridDotsStateChanged(evt);
            }
        });
        this.topPanel.add(this.butSqrGridDots);
        this.butTrgGridDots.setIcon(this.myLoadIcon("icons/triangle_grid_dots.gif"));
        this.butTrgGridDots.setToolTipText("\u03a4\u03c1\u03b9\u03b3\u03c9\u03bd\u03b9\u03ba\u03cc \u03c0\u03bb\u03ad\u03b3\u03bc\u03b1 (\u03bc\u03cc\u03bd\u03bf \u03ba\u03bf\u03c5\u03ba\u03ba\u03af\u03b4\u03b5\u03c2)");
        this.butGroupMode.add(this.butTrgGridDots);
        this.butTrgGridDots.setMargin(new Insets(1, 1, 1, 1));
        this.butTrgGridDots.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butTrgGridDotsStateChanged(evt);
            }
        });
        this.topPanel.add(this.butTrgGridDots);
        this.butSqrGridLines.setIcon(this.myLoadIcon("icons/square_grid_lines.gif"));
        this.butSqrGridLines.setToolTipText("\u03a4\u03b5\u03c4\u03c1\u03b1\u03b3\u03c9\u03bd\u03b9\u03ba\u03cc \u03c0\u03bb\u03ad\u03b3\u03bc\u03b1 (\u03b3\u03c1\u03b1\u03bc\u03bc\u03ad\u03c2)");
        this.butGroupMode.add(this.butSqrGridLines);
        this.butSqrGridLines.setMargin(new Insets(1, 1, 1, 1));
        this.butSqrGridLines.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butSqrGridLinesStateChanged(evt);
            }
        });
        this.topPanel.add(this.butSqrGridLines);
        this.butTrgGridLines.setIcon(this.myLoadIcon("icons/triangle_grid_lines.gif"));
        this.butTrgGridLines.setToolTipText("\u03a4\u03c1\u03b9\u03b3\u03c9\u03bd\u03b9\u03ba\u03cc \u03c0\u03bb\u03ad\u03b3\u03bc\u03b1 (\u03b3\u03c1\u03b1\u03bc\u03bc\u03ad\u03c2)");
        this.butGroupMode.add(this.butTrgGridLines);
        this.butTrgGridLines.setMargin(new Insets(1, 1, 1, 1));
        this.butTrgGridLines.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butTrgGridLinesStateChanged(evt);
            }
        });
        this.topPanel.add(this.butTrgGridLines);
        this.jSeparator6.setBackground(Color.lightGray);
        this.jSeparator6.setForeground(Color.lightGray);
        this.jSeparator6.setOrientation(1);
        this.jSeparator6.setMinimumSize(new Dimension(10, 38));
        this.jSeparator6.setPreferredSize(new Dimension(10, 38));
        this.topPanel.add(this.jSeparator6);
        this.butMoveTool.setIcon(this.myLoadIcon("icons/tool_move.gif"));
        this.butMoveTool.setToolTipText("\u0395\u03c1\u03b3\u03b1\u03bb\u03b5\u03af\u03bf \u03bc\u03b5\u03c4\u03b1\u03ba\u03af\u03bd\u03b7\u03c3\u03b7\u03c2");
        this.butGroupDrawTools.add(this.butMoveTool);
        this.butMoveTool.setMargin(new Insets(1, 1, 1, 1));
        this.butMoveTool.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butMoveToolStateChanged(evt);
            }
        });
        this.topPanel.add(this.butMoveTool);
        this.butRotateTool.setIcon(this.myLoadIcon("icons/tool_rotate.gif"));
        this.butRotateTool.setToolTipText("\u0395\u03c1\u03b3\u03b1\u03bb\u03b5\u03af\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c4\u03c1\u03bf\u03c6\u03ae\u03c2");
        this.butGroupDrawTools.add(this.butRotateTool);
        this.butRotateTool.setMargin(new Insets(1, 1, 1, 1));
        this.butRotateTool.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butRotateToolStateChanged(evt);
            }
        });
        this.topPanel.add(this.butRotateTool);
        this.butResizeTool.setIcon(this.myLoadIcon("icons/tool_resize1.gif"));
        this.butResizeTool.setToolTipText("\u0395\u03c1\u03b3\u03b1\u03bb\u03b5\u03af\u03bf \u03b1\u03bb\u03bb\u03b1\u03b3\u03ae\u03c2 \u03bc\u03b5\u03b3\u03ad\u03b8\u03bf\u03c5\u03c2");
        this.butGroupDrawTools.add(this.butResizeTool);
        this.butResizeTool.setMargin(new Insets(1, 1, 1, 1));
        this.butResizeTool.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butResizeToolStateChanged(evt);
            }
        });
        this.topPanel.add(this.butResizeTool);
        this.butEraseTool.setIcon(this.myLoadIcon("icons/tool_eraser1.gif"));
        this.butEraseTool.setToolTipText("\u0395\u03c1\u03b3\u03b1\u03bb\u03b5\u03af\u03bf \u03b4\u03b9\u03b1\u03b3\u03c1\u03b1\u03c6\u03ae\u03c2");
        this.butGroupDrawTools.add(this.butEraseTool);
        this.butEraseTool.setMargin(new Insets(1, 1, 1, 1));
        this.butEraseTool.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butEraseToolStateChanged(evt);
            }
        });
        this.topPanel.add(this.butEraseTool);
        this.butCutTool.setIcon(this.myLoadIcon("icons/tool_cut.gif"));
        this.butCutTool.setToolTipText("\u0395\u03c1\u03b3\u03b1\u03bb\u03b5\u03af\u03bf \u03ba\u03bf\u03c8\u03af\u03bc\u03b1\u03c4\u03bf\u03c2");
        this.butGroupDrawTools.add(this.butCutTool);
        this.butCutTool.setMargin(new Insets(1, 1, 1, 1));
        this.butCutTool.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butCutToolStateChanged(evt);
            }
        });
        this.topPanel.add(this.butCutTool);
        this.butDragVertex.setIcon(this.myLoadIcon("icons/dragvertex.gif"));
        this.butDragVertex.setToolTipText("\u0395\u03c1\u03b3\u03b1\u03bb\u03b5\u03af\u03bf \u03bc\u03b5\u03c4\u03b1\u03ba\u03af\u03bd\u03b7\u03c3\u03b7\u03c2/\u03b4\u03b7\u03bc\u03b9\u03bf\u03c5\u03c1\u03b3\u03af\u03b1\u03c2 \u03ba\u03bf\u03c1\u03c5\u03c6\u03ce\u03bd");
        this.butGroupDrawTools.add(this.butDragVertex);
        this.butDragVertex.setMargin(new Insets(1, 1, 1, 1));
        this.butDragVertex.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butDragVertexStateChanged(evt);
            }
        });
        this.topPanel.add(this.butDragVertex);
        this.butAxisTool.setIcon(this.myLoadIcon("icons/tool_axis.gif"));
        this.butAxisTool.setToolTipText("\u039a\u03b1\u03c4\u03bf\u03c0\u03c4\u03c1\u03b9\u03c3\u03bc\u03cc\u03c2 \u03c3\u03c7\u03ae\u03bc\u03b1\u03c4\u03bf\u03c2 \u03c9\u03c2 \u03c0\u03c1\u03bf\u03c2 \u03ac\u03be\u03bf\u03bd\u03b1 \u03c3\u03c5\u03bc\u03bc\u03b5\u03c4\u03c1\u03af\u03b1\u03c2");
        this.butGroupDrawTools.add(this.butAxisTool);
        this.butAxisTool.setMargin(new Insets(1, 1, 1, 1));
        this.butAxisTool.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butAxisToolStateChanged(evt);
            }
        });
        this.butAxisTool.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GridDrawApplet.this.butAxisToolMouseClicked(evt);
            }
        });
        this.topPanel.add(this.butAxisTool);
        this.add((Component)this.topPanel, "North");
        this.leftPanel.setLayout(new GridLayout(3, 1));
        this.leftPanel.setBackground(Color.lightGray);
        this.panel1.setLayout(new GridLayout(6, 1));
        this.butCalculate.setText("\u03a5\u03c0\u03bf\u03bb\u03bf\u03b3\u03b9\u03c3\u03bc\u03bf\u03af");
        this.butCalculate.setToolTipText("\u0395\u03c1\u03b3\u03b1\u03bb\u03b5\u03af\u03bf \u03c5\u03c0\u03bf\u03bb\u03bf\u03b3\u03b9\u03c3\u03bc\u03ce\u03bd \u03c0\u03b5\u03c1\u03b9\u03bc\u03ad\u03c4\u03c1\u03bf\u03c5 \u03ba\u03b1\u03b9 \u03b5\u03bc\u03b2\u03b1\u03b4\u03bf\u03cd");
        this.butGroupDrawTools.add(this.butCalculate);
        this.butCalculate.setMargin(new Insets(2, 3, 2, 3));
        this.butCalculate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butCalculateStateChanged(evt);
            }
        });
        this.panel1.add(this.butCalculate);
        this.jLabel1.setText("\u039c\u03ae\u03ba\u03bf\u03c2:");
        this.jLabel1.setVerticalAlignment(3);
        this.panel1.add(this.jLabel1);
        this.textPerim.setEditable(false);
        this.textPerim.setToolTipText("\u03a0\u03b5\u03c1\u03af\u03bc\u03b5\u03c4\u03c1\u03bf\u03c2 \u03c3\u03b5 \u03bc\u03bf\u03bd\u03ac\u03b4\u03b5\u03c2 \u03c0\u03bb\u03ad\u03b3\u03bc\u03b1\u03c4\u03bf\u03c2");
        this.panel1.add(this.textPerim);
        this.jLabel2.setText("\u0395\u03bc\u03b2\u03b1\u03b4\u03cc\u03bd:");
        this.jLabel2.setVerticalAlignment(3);
        this.panel1.add(this.jLabel2);
        this.textArea.setEditable(false);
        this.textArea.setToolTipText("\u0395\u03bc\u03b2\u03b1\u03b4\u03cc\u03bd \u03c3\u03b5 \u03c4\u03b5\u03c4\u03c1\u03b1\u03b3\u03c9\u03bd\u03b9\u03ba\u03ad\u03c2 \u03bc\u03bf\u03bd\u03ac\u03b4\u03b5\u03c2 \u03c0\u03bb\u03ad\u03b3\u03bc\u03b1\u03c4\u03bf\u03c2");
        this.panel1.add(this.textArea);
        this.checkDekadika.setBackground(Color.lightGray);
        this.checkDekadika.setSelected(true);
        this.checkDekadika.setText("\u0394\u03b5\u03ba\u03b1\u03b4\u03b9\u03ba\u03ac");
        this.checkDekadika.setToolTipText("\u0395\u03c0\u03b9\u03bb\u03bf\u03b3\u03ae \u03ba\u03b1\u03b9 \u03b5\u03bc\u03c6\u03ac\u03bd\u03b9\u03c3\u03b7 \u03b4\u03b5\u03ba\u03b1\u03b4\u03b9\u03ba\u03ce\u03bd \u03c8\u03b7\u03c6\u03af\u03c9\u03bd");
        this.panel1.add(this.checkDekadika);
        this.leftPanel.add(this.panel1);
        this.add((Component)this.leftPanel, "West");
        this.rightPanel.setLayout(new GridBagLayout());
        this.rightPanel.setBackground(Color.lightGray);
        this.butLine.setIcon(this.myLoadIcon("icons/line.gif"));
        this.butLine.setToolTipText("\u03a3\u03c7\u03b5\u03b4\u03b9\u03b1\u03c3\u03bc\u03cc\u03c2 \u03b5\u03c5\u03b8\u03cd\u03b3\u03c1\u03b1\u03bc\u03bc\u03bf\u03c5 \u03c4\u03bc\u03ae\u03bc\u03b1\u03c4\u03bf\u03c2");
        this.butGroupDrawTools.add(this.butLine);
        this.butLine.setMargin(new Insets(2, 2, 2, 2));
        this.butLine.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butLineStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.rightPanel.add((Component)this.butLine, gridBagConstraints);
        this.butTriangle.setIcon(this.myLoadIcon("icons/triangle.gif"));
        this.butTriangle.setToolTipText("\u03a3\u03c7\u03b5\u03b4\u03b9\u03b1\u03c3\u03bc\u03cc\u03c2 \u03c4\u03c1\u03b9\u03b3\u03ce\u03bd\u03bf\u03c5");
        this.butGroupDrawTools.add(this.butTriangle);
        this.butTriangle.setMargin(new Insets(2, 2, 2, 2));
        this.butTriangle.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butTriangleStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.rightPanel.add((Component)this.butTriangle, gridBagConstraints);
        this.butSquare.setIcon(this.myLoadIcon("icons/square.gif"));
        this.butSquare.setToolTipText("\u03a3\u03c7\u03b5\u03b4\u03b9\u03b1\u03c3\u03bc\u03cc\u03c2 \u03c4\u03b5\u03c4\u03c1\u03b1\u03b3\u03ce\u03bd\u03bf\u03c5");
        this.butGroupDrawTools.add(this.butSquare);
        this.butSquare.setMargin(new Insets(2, 2, 2, 2));
        this.butSquare.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butSquareStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.rightPanel.add((Component)this.butSquare, gridBagConstraints);
        this.butDiamond.setIcon(this.myLoadIcon("icons/diamond.gif"));
        this.butDiamond.setToolTipText("\u03a3\u03c7\u03b5\u03b4\u03b9\u03b1\u03c3\u03bc\u03cc\u03c2 \u03c1\u03cc\u03bc\u03b2\u03bf\u03c5");
        this.butGroupDrawTools.add(this.butDiamond);
        this.butDiamond.setMargin(new Insets(2, 2, 2, 2));
        this.butDiamond.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butDiamondStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.rightPanel.add((Component)this.butDiamond, gridBagConstraints);
        this.butTrapezoid.setIcon(this.myLoadIcon("icons/trapezio.gif"));
        this.butTrapezoid.setToolTipText("\u03a3\u03c7\u03b5\u03b4\u03b9\u03b1\u03c3\u03bc\u03cc\u03c2 \u03c4\u03c1\u03b1\u03c0\u03b5\u03b6\u03af\u03bf\u03c5");
        this.butGroupDrawTools.add(this.butTrapezoid);
        this.butTrapezoid.setMargin(new Insets(2, 2, 2, 2));
        this.butTrapezoid.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butTrapezoidStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.rightPanel.add((Component)this.butTrapezoid, gridBagConstraints);
        this.butHexagon.setIcon(this.myLoadIcon("icons/hexagon.gif"));
        this.butHexagon.setToolTipText("\u03a3\u03c7\u03b5\u03b4\u03b9\u03b1\u03c3\u03bc\u03cc\u03c2 \u03b5\u03be\u03b1\u03b3\u03ce\u03bd\u03bf\u03c5");
        this.butGroupDrawTools.add(this.butHexagon);
        this.butHexagon.setMargin(new Insets(2, 2, 2, 2));
        this.butHexagon.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butHexagonStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.rightPanel.add((Component)this.butHexagon, gridBagConstraints);
        this.butCircle.setIcon(this.myLoadIcon("icons/circle.gif"));
        this.butCircle.setToolTipText("\u03a3\u03c7\u03b5\u03b4\u03b9\u03b1\u03c3\u03bc\u03cc\u03c2 \u03ba\u03cd\u03ba\u03bb\u03bf\u03c5");
        this.butGroupDrawTools.add(this.butCircle);
        this.butCircle.setMargin(new Insets(2, 2, 2, 2));
        this.butCircle.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butCircleStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.rightPanel.add((Component)this.butCircle, gridBagConstraints);
        this.jSeparator9.setBackground(Color.lightGray);
        this.jSeparator9.setForeground(Color.lightGray);
        this.jSeparator9.setPreferredSize(new Dimension(32, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.rightPanel.add((Component)this.jSeparator9, gridBagConstraints);
        this.butUSquare.setIcon(this.myLoadIcon("icons/square_unary.gif"));
        this.butUSquare.setToolTipText("\u039c\u03bf\u03bd\u03b1\u03b4\u03b9\u03b1\u03af\u03bf \u03c4\u03b5\u03c4\u03c1\u03ac\u03b3\u03c9\u03bd\u03bf");
        this.butGroupDrawTools.add(this.butUSquare);
        this.butUSquare.setMargin(new Insets(0, 0, 0, 0));
        this.butUSquare.setEnabled(false);
        this.butUSquare.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butUSquareStateChanged(evt);
            }
        });
        this.rightPanel.add((Component)this.butUSquare, new GridBagConstraints());
        this.butUTriangle.setIcon(this.myLoadIcon("icons/triangle_unary.gif"));
        this.butUTriangle.setToolTipText("\u039c\u03bf\u03bd\u03b1\u03b4\u03b9\u03b1\u03af\u03bf \u03c4\u03c1\u03af\u03b3\u03c9\u03bd\u03bf");
        this.butGroupDrawTools.add(this.butUTriangle);
        this.butUTriangle.setMargin(new Insets(0, 0, 0, 0));
        this.butUTriangle.setEnabled(false);
        this.butUTriangle.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butUTriangleStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.rightPanel.add((Component)this.butUTriangle, gridBagConstraints);
        this.butDrawPoint.setIcon(this.myLoadIcon("icons/point.gif"));
        this.butDrawPoint.setToolTipText("\u0395\u03b9\u03c3\u03b1\u03b3\u03c9\u03b3\u03ae \u03c3\u03b7\u03bc\u03b5\u03af\u03bf\u03c5");
        this.butGroupDrawTools.add(this.butDrawPoint);
        this.butDrawPoint.setMargin(new Insets(0, 0, 0, 0));
        this.butDrawPoint.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butDrawPointStateChanged(evt);
            }
        });
        this.rightPanel.add((Component)this.butDrawPoint, new GridBagConstraints());
        this.butHandlePoint.setIcon(this.myLoadIcon("icons/handle_point.gif"));
        this.butHandlePoint.setToolTipText("\u0394\u03b9\u03b1\u03c7\u03b5\u03af\u03c1\u03b9\u03c3\u03b7 \u03c3\u03b7\u03bc\u03b5\u03af\u03bf\u03c5");
        this.butGroupDrawTools.add(this.butHandlePoint);
        this.butHandlePoint.setMargin(new Insets(0, 0, 0, 0));
        this.butHandlePoint.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butHandlePointStateChanged(evt);
            }
        });
        this.rightPanel.add((Component)this.butHandlePoint, new GridBagConstraints());
        this.add((Component)this.rightPanel, "East");
        this.bottomPanel.setLayout(new FlowLayout(0, 2, 1));
        this.bottomPanel.setBackground(Color.lightGray);
        this.butCalculator.setIcon(this.myLoadIcon("icons/calculator.gif"));
        this.butCalculator.setToolTipText("\u0391\u03c1\u03b9\u03b8\u03bc\u03bf\u03bc\u03b7\u03c7\u03b1\u03bd\u03ae");
        this.butCalculator.setMargin(new Insets(1, 1, 1, 1));
        this.butCalculator.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.butCalculatorMousePressed(evt);
            }
        });
        this.bottomPanel.add(this.butCalculator);
        this.butNotepad.setIcon(this.myLoadIcon("icons/note.gif"));
        this.butNotepad.setToolTipText("\u03a3\u03b7\u03bc\u03b5\u03b9\u03c9\u03bc\u03b1\u03c4\u03ac\u03c1\u03b9\u03bf");
        this.butNotepad.setMargin(new Insets(1, 1, 1, 1));
        this.butNotepad.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.butNotepadMousePressed(evt);
            }
        });
        this.bottomPanel.add(this.butNotepad);
        this.butValTable.setIcon(this.myLoadIcon("icons/table.gif"));
        this.butValTable.setToolTipText("\u03a0\u03af\u03bd\u03b1\u03ba\u03b1\u03c2 \u03c4\u03b9\u03bc\u03ce\u03bd");
        this.butValTable.setMargin(new Insets(1, 1, 1, 1));
        this.butValTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.butValTableMousePressed(evt);
            }
        });
        this.bottomPanel.add(this.butValTable);
        this.jSeparator10.setBackground(Color.lightGray);
        this.jSeparator10.setForeground(Color.lightGray);
        this.jSeparator10.setOrientation(1);
        this.jSeparator10.setMinimumSize(new Dimension(5, 36));
        this.jSeparator10.setPreferredSize(new Dimension(5, 36));
        this.bottomPanel.add(this.jSeparator10);
        this.textInfo.setColumns(38);
        this.textInfo.setEditable(false);
        this.textInfo.setMinimumSize(new Dimension(20, 20));
        this.bottomPanel.add(this.textInfo);
        this.jSeparator11.setBackground(Color.lightGray);
        this.jSeparator11.setForeground(Color.lightGray);
        this.jSeparator11.setOrientation(1);
        this.jSeparator11.setMinimumSize(new Dimension(5, 36));
        this.jSeparator11.setPreferredSize(new Dimension(5, 36));
        this.bottomPanel.add(this.jSeparator11);
        this.butRuler.setIcon(this.myLoadIcon("icons/ruler.gif"));
        this.butRuler.setToolTipText("\u03a7\u03ac\u03c1\u03b1\u03ba\u03b1\u03c2");
        this.butGroupDrawTools.add(this.butRuler);
        this.butRuler.setMargin(new Insets(1, 1, 1, 1));
        this.butRuler.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butRulerStateChanged(evt);
            }
        });
        this.bottomPanel.add(this.butRuler);
        this.butAngleRuler.setIcon(this.myLoadIcon("icons/mirognomonio.gif"));
        this.butAngleRuler.setToolTipText("\u039c\u03bf\u03b9\u03c1\u03bf\u03b3\u03bd\u03c9\u03bc\u03cc\u03bd\u03b9\u03bf");
        this.butGroupDrawTools.add(this.butAngleRuler);
        this.butAngleRuler.setMargin(new Insets(1, 1, 1, 1));
        this.butAngleRuler.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GridDrawApplet.this.butAngleRulerStateChanged(evt);
            }
        });
        this.bottomPanel.add(this.butAngleRuler);
        this.butZari.setIcon(this.myLoadIcon("icons/zari.gif"));
        this.butZari.setToolTipText("\u0393\u03ad\u03bd\u03bd\u03b7\u03c3\u03b7 \u03c4\u03c5\u03c7\u03b1\u03af\u03bf\u03c5 \u03b1\u03c1\u03b9\u03b8\u03bc\u03bf\u03cd");
        this.butZari.setMargin(new Insets(1, 1, 1, 1));
        this.butZari.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GridDrawApplet.this.butZariMousePressed(evt);
            }
        });
        this.bottomPanel.add(this.butZari);
        this.add((Component)this.bottomPanel, "South");
    }

    private void butValTableMousePressed(MouseEvent evt) {
        this.statCount = 0;
        this.stat = new StatisticsFrame((Applet)this);
        this.stat.show();
    }

    private void butZariMousePressed(MouseEvent evt) {
        if (evt.getButton() == 1) {
            long rand = Math.abs(this.random.nextLong() % this.randomMax);
            if (rand == 0L) {
                rand = this.randomMax;
            }
            this.textInfo.setText(" \u03a4\u03c5\u03c7\u03b1\u03af\u03bf\u03c2 \u03b1\u03c1\u03b9\u03b8\u03bc\u03cc\u03c2: " + rand);
        } else {
            GetNumberDialog dlg = new GetNumberDialog(null, true, this.randomMax);
            dlg.setLocation(this.getX() + 300, this.getY() + 200);
            dlg.show();
            this.randomMax = Math.abs(dlg.getValue());
        }
    }

    private void butPrintMousePressed(MouseEvent evt) {
        PrinterJob pjob = PrinterJob.getPrinterJob();
        PageFormat pf = pjob.pageDialog(pjob.defaultPage());
        pjob.setPrintable(this.grid, pf);
        if (pjob.printDialog()) {
            try {
                pjob.print();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void miAxisSetMousePressed(MouseEvent evt) {
        this.status = 37;
    }

    private void butAxisToolMouseClicked(MouseEvent evt) {
        if (evt.getButton() != 1) {
            this.butAxisTool.setSelected(true);
            this.popAxis.show(this, this.butAxisTool.getX() - 140, this.butAxisTool.getY() + 38);
        }
    }

    private void butAxisToolStateChanged(ChangeEvent evt) {
        if (this.butAxisTool.isSelected()) {
            this.status = 36;
            this.grid.showAxis();
        } else {
            this.grid.hideAxis();
        }
    }

    private void miHPDeleteMousePressed(MouseEvent evt) {
        this.grid.deleteActivePoint();
    }

    private void butDragVertexStateChanged(ChangeEvent evt) {
        if (this.butDragVertex.isSelected()) {
            this.status = 22;
        }
    }

    private void butAngleRulerStateChanged(ChangeEvent evt) {
        if (this.butAngleRuler.isSelected()) {
            this.status = 26;
        }
    }

    private void butRulerStateChanged(ChangeEvent evt) {
        if (this.butRuler.isSelected()) {
            this.status = 24;
        }
    }

    private void butHandlePointStateChanged(ChangeEvent evt) {
        if (this.butHandlePoint.isSelected()) {
            this.status = 31;
        }
    }

    private void butDrawPointStateChanged(ChangeEvent evt) {
        if (this.butDrawPoint.isSelected()) {
            this.status = 30;
        }
    }

    private void butUTriangleStateChanged(ChangeEvent evt) {
        if (this.butUTriangle.isSelected()) {
            this.status = 21;
        }
    }

    private void butUSquareStateChanged(ChangeEvent evt) {
        if (this.butUSquare.isSelected()) {
            this.status = 20;
        }
    }

    private void loadGDA(InputStream istream) {
        try {
            ObjectInputStream p = new ObjectInputStream(istream);
            System.err.print("Loading shapes ");
            Object obj = p.readObject();
            if (obj != null) {
                System.err.print("...");
                this.grid.setShapeVector((Vector)obj);
                System.err.println("OK!");
            }
            System.err.print("Loading points");
            obj = p.readObject();
            if (obj != null) {
                System.err.print("...");
                this.grid.setPointVector((Vector)obj);
                System.err.println("OK!");
            }
            p.close();
            System.err.println("File loaded!");
            this.grid.forceBackRepaint();
        }
        catch (IOException e) {
            System.err.println("Error opening file: " + e.toString());
        }
        catch (ClassNotFoundException e) {
            System.err.println("Error opening file: " + e.toString());
        }
    }

    private void butLoadMousePressed(MouseEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new GDAFileFilter());
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            String fname = chooser.getSelectedFile().getAbsolutePath();
            File f = new File(fname);
            try {
                FileInputStream istream = new FileInputStream(f);
                this.loadGDA(istream);
            }
            catch (FileNotFoundException e) {
                System.out.println(e.toString());
            }
        }
    }

    private void butSaveMousePressed(MouseEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new GDAFileFilter());
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            String fname = chooser.getSelectedFile().getAbsolutePath();
            try {
                FileOutputStream ostream = new FileOutputStream(fname);
                ObjectOutputStream p = new ObjectOutputStream(ostream);
                System.err.print("Saving ");
                p.writeObject(this.grid.getShapeVector());
                System.err.print("...Shapes [OK] ");
                p.writeObject(this.grid.getPointVector());
                System.err.println("...Points [OK]");
                p.close();
                System.err.println("File saved!");
            }
            catch (IOException e) {
                System.err.println("Error saving file: " + e.toString());
            }
        }
    }

    private void miLocalFileMouseReleased(MouseEvent evt) {
        String fname;
        ImageIcon img;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new GIFJPGFileFilter());
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0 && (img = new ImageIcon(fname = chooser.getSelectedFile().getAbsolutePath())) != null) {
            this.grid.setImage(img.getImage());
        }
    }

    private void miNoImageMouseReleased(MouseEvent evt) {
        this.grid.setImage(null);
    }

    private void PLOItemMouseReleased(MouseEvent evt) {
        int i = this.popLoadImage.getComponentIndex(evt.getComponent());
        this.grid.setImage(((LoadableImage)this.images.get((int)i)).img);
    }

    private void butCalculateStateChanged(ChangeEvent evt) {
        if (this.butCalculate.isSelected()) {
            this.status = 19;
        }
    }

    private void butBitmapMousePressed(MouseEvent evt) {
        this.popLoadImage.show(this, this.butBitmap.getX(), this.butBitmap.getY() + 38);
    }

    private void butCalculatorMousePressed(MouseEvent evt) {
        try {
            Process p = Runtime.getRuntime().exec("calc.exe");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private void butNotepadMousePressed(MouseEvent evt) {
        try {
            Process p = Runtime.getRuntime().exec("notepad.exe");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private void butClearMouseClicked(MouseEvent evt) {
        this.grid.clear();
    }

    private void rotateCCWMousePressed(MouseEvent evt) {
        this.rotateDir = -1;
    }

    private void rotateCWMousePressed(MouseEvent evt) {
        this.rotateDir = 1;
    }

    private void miR180MousePressed(MouseEvent evt) {
        if (evt.isShiftDown()) {
            this.grid.copyActiveShape();
        }
        this.grid.rotateActiveShape(180, this.rotateDir);
        this.grid.forceBackRepaint();
    }

    private void miR90MousePressed(MouseEvent evt) {
        if (evt.isShiftDown()) {
            this.grid.copyActiveShape();
        }
        this.grid.rotateActiveShape(90, this.rotateDir);
        this.grid.forceBackRepaint();
    }

    private void miR60MousePressed(MouseEvent evt) {
        if (evt.isShiftDown()) {
            this.grid.copyActiveShape();
        }
        this.grid.rotateActiveShape(60, this.rotateDir);
        this.grid.forceBackRepaint();
    }

    private void miR45MousePressed(MouseEvent evt) {
        if (evt.isShiftDown()) {
            this.grid.copyActiveShape();
        }
        this.grid.rotateActiveShape(45, this.rotateDir);
        this.grid.forceBackRepaint();
    }

    private void miR30MousePressed(MouseEvent evt) {
        if (evt.isShiftDown()) {
            this.grid.copyActiveShape();
        }
        this.grid.rotateActiveShape(30, this.rotateDir);
        this.grid.forceBackRepaint();
    }

    private void miDiv5MousePressed(MouseEvent evt) {
        if (evt.isShiftDown()) {
            this.grid.copyActiveShape();
        }
        this.grid.resizeActiveShape(-80, 0);
        this.grid.forceBackRepaint();
    }

    private void miDiv3MousePressed(MouseEvent evt) {
        if (evt.isShiftDown()) {
            this.grid.copyActiveShape();
        }
        this.grid.resizeActiveShape(-67, 0);
        this.grid.forceBackRepaint();
    }

    private void miDiv2MousePressed(MouseEvent evt) {
        if (evt.isShiftDown()) {
            this.grid.copyActiveShape();
        }
        this.grid.resizeActiveShape(-50, 0);
        this.grid.forceBackRepaint();
    }

    private void miMul5MousePressed(MouseEvent evt) {
        if (evt.isShiftDown()) {
            this.grid.copyActiveShape();
        }
        this.grid.resizeActiveShape(400, 0);
        this.grid.forceBackRepaint();
    }

    private void miMul3MousePressed(MouseEvent evt) {
        if (evt.isShiftDown()) {
            this.grid.copyActiveShape();
        }
        this.grid.resizeActiveShape(200, 0);
        this.grid.forceBackRepaint();
    }

    private void miMul2MousePressed(MouseEvent evt) {
        if (evt.isShiftDown()) {
            this.grid.copyActiveShape();
        }
        this.grid.resizeActiveShape(100, 0);
        this.grid.forceBackRepaint();
    }

    private void butCircleStateChanged(ChangeEvent evt) {
        if (this.butCircle.isSelected()) {
            this.status = 5;
        }
    }

    private void butHexagonStateChanged(ChangeEvent evt) {
        if (this.butHexagon.isSelected()) {
            this.status = 6;
        }
    }

    private void butTrapezoidStateChanged(ChangeEvent evt) {
        if (this.butTrapezoid.isSelected()) {
            this.status = 8;
        }
    }

    private void butDiamondStateChanged(ChangeEvent evt) {
        if (this.butDiamond.isSelected()) {
            this.status = 7;
        }
    }

    private void butSquareStateChanged(ChangeEvent evt) {
        if (this.butSquare.isSelected()) {
            this.status = 4;
        }
    }

    private void butCutToolStateChanged(ChangeEvent evt) {
        if (this.butCutTool.isSelected()) {
            this.status = 17;
        }
    }

    private void butResizeToolStateChanged(ChangeEvent evt) {
        if (this.butResizeTool.isSelected()) {
            this.status = 12;
        }
    }

    private void butRotateToolStateChanged(ChangeEvent evt) {
        if (this.butRotateTool.isSelected()) {
            this.status = 15;
        }
    }

    private void butEraseToolStateChanged(ChangeEvent evt) {
        if (this.butEraseTool.isSelected()) {
            this.status = 14;
        }
    }

    private void butTriangleStateChanged(ChangeEvent evt) {
        if (this.butTriangle.isSelected()) {
            this.status = 3;
        }
    }

    private void butMoveToolStateChanged(ChangeEvent evt) {
        if (this.butMoveTool.isSelected()) {
            this.status = 10;
        }
    }

    private void butTrgGridLinesStateChanged(ChangeEvent evt) {
        if (this.butTrgGridLines.isSelected()) {
            this.grid.setGridMode(2);
            this.grid.setDoSnap(true);
            this.grid.setShowLines(true);
            this.grid.repaint();
            this.props.enableSnap();
            this.props.setSnap(true);
            if (this.butUSquare.isSelected()) {
                this.butSquare.setSelected(true);
            }
            this.butUSquare.setEnabled(false);
            this.butUTriangle.setEnabled(true);
        }
    }

    private void butSqrGridLinesStateChanged(ChangeEvent evt) {
        if (this.butSqrGridLines.isSelected()) {
            this.grid.setGridMode(1);
            this.grid.setDoSnap(true);
            this.grid.setShowLines(true);
            this.grid.repaint();
            this.props.enableSnap();
            this.props.setSnap(true);
            if (this.butUTriangle.isSelected()) {
                this.butTriangle.setSelected(true);
            }
            this.butUSquare.setEnabled(true);
            this.butUTriangle.setEnabled(false);
        }
    }

    private void butTrgGridDotsStateChanged(ChangeEvent evt) {
        if (this.butTrgGridDots.isSelected()) {
            this.grid.setGridMode(2);
            this.grid.setDoSnap(true);
            this.grid.setShowLines(false);
            this.grid.repaint();
            this.props.enableSnap();
            this.props.setSnap(true);
            if (this.butUSquare.isSelected()) {
                this.butSquare.setSelected(true);
            }
            this.butUSquare.setEnabled(false);
            this.butUTriangle.setEnabled(true);
        }
    }

    private void butSqrGridDotsStateChanged(ChangeEvent evt) {
        if (this.butSqrGridDots.isSelected()) {
            this.grid.setGridMode(1);
            this.grid.setDoSnap(true);
            this.grid.setShowLines(false);
            this.grid.repaint();
            this.props.enableSnap();
            this.props.setSnap(true);
            if (this.butUTriangle.isSelected()) {
                this.butTriangle.setSelected(true);
            }
            this.butUSquare.setEnabled(true);
            this.butUTriangle.setEnabled(false);
        }
    }

    private void butNoGridStateChanged(ChangeEvent evt) {
        if (this.butNoGrid.isSelected()) {
            this.grid.setGridMode(0);
            this.grid.setDoSnap(false);
            this.grid.setShowLines(false);
            this.grid.repaint();
            this.props.setSnap(false);
            this.props.disableSnap();
            if (this.butUSquare.isSelected()) {
                this.butSquare.setSelected(true);
            }
            if (this.butUTriangle.isSelected()) {
                this.butTriangle.setSelected(true);
            }
            this.butUSquare.setEnabled(false);
            this.butUTriangle.setEnabled(false);
        }
    }

    private void butLineStateChanged(ChangeEvent evt) {
        if (this.butLine.isSelected()) {
            this.status = 1;
            this.pointCounter = 0;
            this.grid.setShapeClosed(false);
        }
    }

    static {
        NONE = 0;
        DRAW_LINE = 1;
        DRAWING_LINE = 2;
        DRAW_TRIANGLE = 3;
        DRAW_SQUARE = 4;
        DRAW_CIRCLE = 5;
        DRAW_HEXAGON = 6;
        DRAW_DIAMOND = 7;
        DRAW_TRAPEZOID = 8;
        MOVE_SHAPE = 10;
        MOVING_SHAPE = 11;
        RESIZE_SHAPE = 12;
        RESIZING_SHAPE = 13;
        ERASE_SHAPE = 14;
        ROTATE_SHAPE = 15;
        ROTATING_SHAPE = 16;
        CUT_SHAPE = 17;
        DEFINE_CUT_SHAPE = 18;
        CALCULATE = 19;
        DRAW_UNARY_SQUARE = 20;
        DRAW_UNARY_TRIANGLE = 21;
        DRAG_VERTEX = 22;
        DRAGING_VERTEX = 23;
        MEASURE_DISTANCE = 24;
        MEASURING_DISTANCE = 25;
        MEASURE_ANGLE = 26;
        MEASURING_ANGLE1 = 27;
        MEASURING_ANGLE2 = 28;
        DRAW_POINT = 30;
        HANDLE_POINT = 31;
        MOVING_POINT = 32;
        PAINT_SHAPE = 35;
        MIRROR_SHAPE = 36;
        SET_AXIS = 37;
        SETING_AXIS = 38;
        COD_BASED = 1111;
        DOC_BASED = 2222;
    }
}

