/*
 * Decompiled with CFR 0.152.
 */
public class DivisionOperator {
    public static final byte LTZ = -1;
    public static final byte NONE = 0;
    public static final byte DIVISOR = 1;
    public static final byte DIVIDER = 2;
    public static final byte QUOTIENT = 3;
    public static final byte REMAIN = 4;
    private int divisor = 0;
    private int divider = 0;
    private int quotient = 0;
    private int remain = 0;
    private ByteHistoryQueue history = new ByteHistoryQueue(3);

    public void clear() {
        this.divider = 0;
        this.divisor = 0;
        this.quotient = 0;
        this.remain = 0;
    }

    public void setDivisor(int d) {
        this.divisor = d;
        this.history.put((byte)1);
    }

    public void setDivider(int d) {
        this.divider = d;
        this.history.put((byte)2);
    }

    public void setQuotient(int q) {
        this.quotient = q;
        this.history.put((byte)3);
    }

    public void setRemain(int r) {
        this.remain = r;
        this.history.put((byte)4);
    }

    public int getDivisor() {
        return this.divisor;
    }

    public int getDivider() {
        return this.divider;
    }

    public int getQuotient() {
        return this.quotient;
    }

    public int getRemain() {
        return this.remain;
    }

    public int calcDivisor() {
        int d;
        this.divisor = d = this.divider * this.quotient + this.remain;
        return d;
    }

    public int calcRemain() {
        int r;
        this.remain = r = this.divisor - this.divider * this.quotient;
        return r;
    }

    public int calcQuotient() {
        int q = 0;
        this.quotient = q = (this.divisor - this.remain) / this.divider;
        return q;
    }

    public int calcDivider() {
        int d = 0;
        this.divider = d = (this.divisor - this.remain) / this.quotient;
        return d;
    }

    public byte calculate() {
        byte ret = 0;
        return ret;
    }

    public boolean isCorrect() {
        if (this.divider != 0) {
            if (this.divisor / this.divider != this.quotient) {
                return false;
            }
            if (this.divisor % this.divider != this.remain) {
                return false;
            }
            if (this.remain < 0) {
                return false;
            }
        } else if (this.quotient != 0 || this.remain != this.divisor) {
            return false;
        }
        return true;
    }

    public void copy(DivisionOperator op) {
        this.divider = op.getDivider();
        this.divisor = op.getDivisor();
        this.quotient = op.getQuotient();
        this.remain = op.getRemain();
    }

    static {
        LTZ = (byte)-1;
        NONE = 0;
        DIVISOR = 1;
        DIVIDER = (byte)2;
        QUOTIENT = (byte)3;
        REMAIN = (byte)4;
    }
}

