/*
 * Decompiled with CFR 0.152.
 */
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class IconBarPanel
extends JPanel
implements Printable {
    String[] labels;
    int[] data;
    Color bgColor;
    String[] image_names;
    Hashtable orig_images = new Hashtable();
    Image[] images;
    boolean showGrid = true;
    Applet parent;
    int w = 0;
    int h = 0;
    int vspace = 20;

    public IconBarPanel(Applet parent, String[] labels, int[] data, Color bgColor, String[] image_names, String[] origImages) {
        int i;
        this.initComponents();
        this.parent = parent;
        this.labels = labels;
        this.data = data;
        this.bgColor = bgColor;
        this.image_names = image_names;
        this.images = new Image[image_names.length];
        for (i = 0; i < image_names.length; ++i) {
            URL imgURL = this.getClass().getResource(image_names[i]);
            String imgStr = image_names[i];
            ImageIcon img = new ImageIcon(imgURL);
            this.images[i] = img.getImage();
        }
        for (i = 0; i < origImages.length; ++i) {
            this.orig_images.put(origImages[i], origImages[i]);
        }
        this.repaint();
        this.w = labels.length * 60;
        this.h = this.getMax() * 25;
        this.setPreferredSize(new Dimension(this.w, this.h));
    }

    private int getMax() {
        int max = this.data[0];
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] <= max) continue;
            max = this.data[i];
        }
        return max;
    }

    private int getMin() {
        int min = this.data[0];
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] >= min) continue;
            min = this.data[i];
        }
        return min;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.paintCanvas(g2, this.w, this.h);
    }

    private void paintCanvas(Graphics2D g2, int w, int h) {
        int i;
        this.drawBackground(g2);
        if (this.showGrid) {
            this.drawGrid(g2);
        }
        g2.setColor(Color.black);
        g2.drawLine(5, h - 25, w - 5, h - 25);
        g2.drawLine(5, h - 24, w - 5, h - 24);
        int space = (w - 20) / (this.labels.length + 1);
        int start = 10 + space;
        for (int i2 = 0; i2 < this.labels.length; ++i2) {
            g2.drawString(this.labels[i2], start, h - 10);
            start += space;
        }
        g2.setColor(Color.black);
        g2.drawLine(25, 0, 25, h - 10);
        g2.drawLine(26, 0, 26, h - 10);
        int max = this.getMax() + 1;
        if (max < 20) {
            max = 20;
        }
        int scale = 1;
        int[] data_points = new int[max];
        for (i = 1; i <= max; ++i) {
            g2.drawLine(23, h - 25 - i * this.vspace, 27, h - 25 - i * this.vspace);
            g2.drawString(String.valueOf(i * scale), 2, h - 25 - i * this.vspace + 5);
            data_points[i - 1] = h - 25 - i * this.vspace;
        }
        space = (w - 20) / (this.labels.length + 1);
        start = 10 + space;
        for (i = 0; i < this.labels.length; ++i) {
            for (int j = 1; j <= this.data[i]; ++j) {
                int y = data_points[j - 1];
                if (this.orig_images.get(this.image_names[i]) != null) {
                    Image image1 = this.parent.getImage(this.parent.getDocumentBase(), this.image_names[i]);
                    g2.drawImage(image1, start - 5, y - 10, 20, 20, null);
                    continue;
                }
                ImageIcon img = new ImageIcon(this.image_names[i]);
                g2.drawImage(img.getImage(), start - 5, y - 10, 20, 20, null);
            }
            start += space;
        }
    }

    private void drawBackground(Graphics2D g2) {
        g2.setColor(this.bgColor);
        g2.fillRect(0, 0, this.w, this.h);
    }

    private void drawGrid(Graphics2D g2) {
        g2.setColor(Color.lightGray);
        for (int i = this.h - 25; i > 0; i -= this.vspace) {
            g2.drawLine(25, i, this.w - 5, i);
        }
    }

    private void drawXY(Graphics2D g2) {
        g2.setColor(Color.black);
        g2.drawLine(10, this.h - 39, this.w, this.h - 39);
        g2.drawLine(10, this.h - 40, this.w, this.h - 40);
        g2.drawLine(20, 0, 20, this.h - 20);
        g2.drawLine(21, 0, 21, this.h - 20);
        g2.setColor(Color.red);
    }

    public void repaintChart(String[] image_names) {
        this.image_names = image_names;
        this.repaint();
        this.setPreferredSize(this.getPreferredSize());
    }

    public void setBackground(Color bgColor) {
        this.bgColor = bgColor;
        this.repaint();
    }

    public void showGrid(boolean show) {
        this.showGrid = show;
        this.repaint();
    }

    public void saveFile(File file) {
        BufferedImage image = new BufferedImage(this.w, this.h, 1);
        Graphics2D g = (Graphics2D)image.getGraphics();
        this.paintCanvas(g, this.getWidth(), this.getHeight());
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
            param.setQuality(100.0f, false);
            encoder.setJPEGEncodeParam(param);
            encoder.encode(image);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public int print(Graphics graphics, PageFormat pageFormat, int param) throws PrinterException {
        double height = pageFormat.getImageableHeight();
        double width = pageFormat.getImageableWidth();
        int totalNumPages = (int)Math.ceil((double)this.getHeight() / height);
        if (param >= totalNumPages) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(61.0, -((double)param * pageFormat.getImageableHeight()) + 1.0 + 60.0);
        g2d.setClip(0, (int)((double)param * pageFormat.getImageableHeight()), (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        this.paint(g2d);
        return 0;
    }
}

