/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;

public class TimeMeasure
extends JApplet
implements ActionListener,
PropertyChangeListener {
    private Timer singleTimer;
    private Beeper beeper;
    private Lane singleLane;
    private int numOfRoundsToBeDone;
    private JTextField turnTF;
    private JRadioButton clockRB;
    private Clock clock;
    private JPanel objectsP;
    private JButton resetB;
    private JButton stopB;
    private ButtonGroup bg;
    private Lane lane2;
    private JPanel tickP;
    private Lane lane1;
    private JButton startB;
    private JLabel turnL2;
    private JRadioButton tickRB;
    private JLabel tickL2;
    private JPanel clockP;
    private JTextField tickTF;
    private JLabel timeMeasureB;
    static /* synthetic */ Class class$TimeMeasure$Beeper;

    public TimeMeasure() {
        this.initComponents();
        this.timeMeasureB.setBorder(null);
        this.timeMeasureB.setFont(new Font("Tahoma", 1, 18));
        this.objectsP.setCursor(Cursor.getPredefinedCursor(12));
        this.lane1.setCursor(Cursor.getPredefinedCursor(12));
        this.lane2.setCursor(Cursor.getPredefinedCursor(12));
        this.objectsP.setLayout(new BoxLayout(this.objectsP, 0));
        this.objectsP.addMouseListener(new ObjectContainerMouseAdapter());
        this.objectsP.add(new Animal("turtle", 1));
        this.objectsP.add(new Animal("frog", 2));
        this.objectsP.add(new Animal("goat", 4));
        this.objectsP.add(new Animal("fox", 8));
        this.objectsP.add(new Animal("dog", 16));
        this.objectsP.add(new Animal("rabbit", 32));
        this.objectsP.add(new Animal("wolf", 64));
        this.objectsP.add(new Animal("bear", 128));
        this.objectsP.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                Component component = TimeMeasure.this.objectsP.getComponentAt(mouseEvent.getPoint());
                if (component != null && component instanceof Animal) {
                    TimeMeasure.this.objectsP.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    TimeMeasure.this.objectsP.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.lane1.getLanePanel().addMouseListener(new LaneContainerMouseAdapter());
        this.lane2.getLanePanel().addMouseListener(new LaneContainerMouseAdapter());
        this.lane1.addPropertyChangeListener("finished", this);
        this.lane2.addPropertyChangeListener("finished", this);
        this.turnTF.setDocument(new PositiveIntegerNumberDoc());
        this.tickTF.setDocument(new PositiveIntegerNumberDoc());
        ButtonActionListener buttonActionListener = new ButtonActionListener();
        this.startB.addActionListener(buttonActionListener);
        this.stopB.addActionListener(buttonActionListener);
        this.resetB.addActionListener(buttonActionListener);
        this.singleTimer = new Timer(0, this);
        this.singleTimer.setInitialDelay(0);
        this.beeper = new Beeper();
        this.reset();
        this.clock.addPropertyChangeListener("secs", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TimeMeasure.this.stopSingle();
                TimeMeasure.this.singleLane.putAnimalToTheEnd();
                TimeMeasure.this.turnTF.setText(String.valueOf(TimeMeasure.this.clock.getNumOfTurns()));
            }
        });
        this.clock.addPropertyChangeListener("turn", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TimeMeasure.this.turnTF.setText(String.valueOf(TimeMeasure.this.clock.getNumOfTurns()));
                if (TimeMeasure.this.tickRB.isSelected()) {
                    TimeMeasure.this.beeper.beep();
                    TimeMeasure.this.tickTF.setText(String.valueOf(TimeMeasure.this.beeper.getNumOfBeeps()));
                }
            }
        });
        SwingUtilities.invokeLater(new Thread(){

            public void run() {
                TimeMeasure.this.clockRB.doClick();
            }
        });
    }

    private void reset() {
        this.beeper.reset();
        this.clock.reset();
        this.turnTF.setText("");
        this.tickTF.setText("");
    }

    private void startWith(Lane lane) {
        this.singleLane = lane;
        this.numOfRoundsToBeDone = (int)((float)(512 / this.singleLane.getAnimal().getSpeed()) / this.singleLane.getSpeedModifier());
        System.out.println("numOfRoundsToBeDone=" + this.numOfRoundsToBeDone);
        int n = this.numOfRoundsToBeDone * 1000;
        this.clock.setEndingSecs(this.numOfRoundsToBeDone * 60);
        this.clock.start();
        this.singleTimer.setDelay(n / 48);
        this.singleTimer.restart();
    }

    private void startWithBoth() {
        this.lane1.start();
        this.lane2.start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        new Thread(){

            public void run() {
                TimeMeasure.this.singleLane.move(true, TimeMeasure.this.clock.getSecs(), TimeMeasure.this.clock.getEndingSecs());
            }
        }.start();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.stopBoth();
    }

    private void stopSingle() {
        Animal animal = null;
        if (!this.lane1.isEmpty() && this.lane2.isEmpty()) {
            animal = this.lane1.getAnimal();
        } else if (this.lane1.isEmpty() && !this.lane2.isEmpty()) {
            animal = this.lane2.getAnimal();
        }
        if (animal == null) {
            return;
        }
        this.singleTimer.stop();
        this.clock.stop();
    }

    private void stopBoth() {
        this.lane1.stop();
        this.lane2.stop();
    }

    private void initComponents() {
        this.bg = new ButtonGroup();
        this.timeMeasureB = new JLabel();
        this.clockRB = new JRadioButton();
        this.tickRB = new JRadioButton();
        this.clockP = new JPanel();
        this.clock = new Clock();
        this.turnL2 = new JLabel();
        this.turnTF = new JTextField();
        this.tickP = new JPanel();
        this.tickL2 = new JLabel();
        this.tickTF = new JTextField();
        this.lane1 = new Lane();
        this.lane2 = new Lane();
        this.startB = new JButton();
        this.stopB = new JButton();
        this.resetB = new JButton();
        this.objectsP = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.timeMeasureB.setFont(new Font("Tahoma", 1, 12));
        this.timeMeasureB.setHorizontalAlignment(0);
        this.timeMeasureB.setText("\u039c\u03ad\u03c4\u03c1\u03b7\u03c3\u03b7 \u03c4\u03bf\u03c5 \u03c7\u03c1\u03cc\u03bd\u03bf\u03c5");
        this.timeMeasureB.setBorder(new EtchedBorder());
        this.timeMeasureB.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 13;
        gridBagConstraints.ipady = 11;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.timeMeasureB, gridBagConstraints);
        this.clockRB.setFont(new Font("Tahoma", 1, 12));
        this.clockRB.setText("\u039c\u03ad\u03c4\u03c1\u03b7\u03c3\u03b7 \u03c4\u03bf\u03c5 \u03c7\u03c1\u03cc\u03bd\u03bf\u03c5 \u03bc\u03b5 \u03c4\u03bf \u03c1\u03bf\u03bb\u03cc\u03b9");
        this.bg.add(this.clockRB);
        this.clockRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TimeMeasure.this.modeRBActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.clockRB, gridBagConstraints);
        this.tickRB.setFont(new Font("Tahoma", 1, 12));
        this.tickRB.setText("\u039c\u03ad\u03c4\u03c1\u03b7\u03c3\u03b7 \u03c4\u03bf\u03c5 \u03c7\u03c1\u03cc\u03bd\u03bf\u03c5 \u03bc\u03b5 \u03ba\u03c4\u03cd\u03c0\u03bf\u03c5\u03c2");
        this.bg.add(this.tickRB);
        this.tickRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TimeMeasure.this.modeRBActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.tickRB, gridBagConstraints);
        this.clockP.setLayout(new GridBagLayout());
        this.clockP.setBorder(new EtchedBorder());
        this.clock.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.ipady = 100;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.clockP.add((Component)this.clock, gridBagConstraints);
        this.turnL2.setFont(new Font("Tahoma", 1, 12));
        this.turnL2.setText("\u03a0\u03bb\u03ae\u03b8\u03bf\u03c2 \u03c3\u03c4\u03c1\u03bf\u03c6\u03ce\u03bd");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.clockP.add((Component)this.turnL2, gridBagConstraints);
        this.turnTF.setFont(new Font("Tahoma", 1, 12));
        this.turnTF.setHorizontalAlignment(0);
        this.turnTF.setDisabledTextColor(Color.black);
        this.turnTF.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.clockP.add((Component)this.turnTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.clockP, gridBagConstraints);
        this.tickP.setLayout(new GridBagLayout());
        this.tickP.setBorder(new EtchedBorder());
        this.tickL2.setFont(new Font("Tahoma", 1, 12));
        this.tickL2.setText("\u03a0\u03bb\u03ae\u03b8\u03bf\u03c2 \u03ba\u03c4\u03cd\u03c0\u03c9\u03bd");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.tickP.add((Component)this.tickL2, gridBagConstraints);
        this.tickTF.setFont(new Font("Tahoma", 1, 12));
        this.tickTF.setHorizontalAlignment(0);
        this.tickTF.setDisabledTextColor(Color.black);
        this.tickTF.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 71;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 20, 0, 0);
        this.tickP.add((Component)this.tickTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.tickP, gridBagConstraints);
        this.lane1.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 50;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lane1, gridBagConstraints);
        this.lane2.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 50;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lane2, gridBagConstraints);
        this.startB.setBackground(Color.green);
        this.startB.setFont(new Font("Tahoma", 1, 12));
        this.startB.setText("\u0395\u03ba\u03ba\u03af\u03bd\u03b7\u03c3\u03b7");
        this.startB.setBorder(new BevelBorder(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.startB, gridBagConstraints);
        this.stopB.setBackground(Color.red);
        this.stopB.setFont(new Font("Tahoma", 1, 12));
        this.stopB.setText("\u03a3\u03c4\u03b1\u03bc\u03ac\u03c4\u03b7\u03bc\u03b1");
        this.stopB.setBorder(new BevelBorder(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.stopB, gridBagConstraints);
        this.resetB.setFont(new Font("Tahoma", 1, 12));
        this.resetB.setText("\u0391\u03c0\u03cc \u03c4\u03b7\u03bd \u03b1\u03c1\u03c7\u03ae");
        this.resetB.setBorder(new BevelBorder(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.resetB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.objectsP, gridBagConstraints);
    }

    private void modeRBActionPerformed(ActionEvent actionEvent) {
        if (this.clockRB.isSelected()) {
            this.clockP.setVisible(true);
            this.tickP.setVisible(false);
        } else {
            this.clockP.setVisible(false);
            this.tickP.setVisible(true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Beeper {
        public AudioClip ac = Applet.newAudioClip((class$TimeMeasure$Beeper == null ? (class$TimeMeasure$Beeper = TimeMeasure.class$("TimeMeasure$Beeper")) : class$TimeMeasure$Beeper).getResource("beep.wav"));
        private int numOfbeeps;

        public Beeper() {
            this.reset();
        }

        public void reset() {
            this.numOfbeeps = 0;
        }

        public void beep() {
            this.ac.play();
            ++this.numOfbeeps;
        }

        public int getNumOfBeeps() {
            return this.numOfbeeps;
        }
    }

    class ButtonActionListener
    implements ActionListener {
        ButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == TimeMeasure.this.startB) {
                if (TimeMeasure.this.lane1.isEmpty() && TimeMeasure.this.lane2.isEmpty()) {
                    return;
                }
                if (!TimeMeasure.this.lane1.isEmpty() && TimeMeasure.this.lane2.isEmpty()) {
                    TimeMeasure.this.startWith(TimeMeasure.this.lane1);
                } else if (TimeMeasure.this.lane1.isEmpty() && !TimeMeasure.this.lane2.isEmpty()) {
                    TimeMeasure.this.startWith(TimeMeasure.this.lane2);
                } else if (!TimeMeasure.this.lane1.isEmpty() && !TimeMeasure.this.lane2.isEmpty()) {
                    TimeMeasure.this.startWithBoth();
                }
            } else if (jButton == TimeMeasure.this.stopB) {
                if (TimeMeasure.this.lane1.isEmpty() && TimeMeasure.this.lane2.isEmpty()) {
                    return;
                }
                if (!TimeMeasure.this.lane1.isEmpty() && TimeMeasure.this.lane2.isEmpty()) {
                    TimeMeasure.this.stopSingle();
                } else if (TimeMeasure.this.lane1.isEmpty() && !TimeMeasure.this.lane2.isEmpty()) {
                    TimeMeasure.this.stopSingle();
                } else if (!TimeMeasure.this.lane1.isEmpty() && !TimeMeasure.this.lane2.isEmpty()) {
                    TimeMeasure.this.stopBoth();
                }
            } else if (jButton == TimeMeasure.this.resetB) {
                TimeMeasure.this.reset();
                TimeMeasure.this.lane1.putAnimalToTheStart();
                TimeMeasure.this.lane2.putAnimalToTheStart();
            }
        }
    }

    class LaneContainerMouseAdapter
    extends MouseAdapter {
        private Animal clickedAnimal;

        LaneContainerMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JPanel jPanel = (JPanel)mouseEvent.getSource();
            JComponent jComponent = (JComponent)jPanel.getComponentAt(mouseEvent.getPoint());
            if (jComponent instanceof Animal) {
                this.clickedAnimal = (Animal)jComponent;
                jPanel.removeAll();
                jPanel.repaint();
                jPanel.setCursor(this.clickedAnimal.getCustomCursor());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.clickedAnimal == null) {
                return;
            }
            JPanel jPanel = (JPanel)mouseEvent.getSource();
            if (jPanel.getBounds().contains(mouseEvent.getPoint())) {
                Point point = SwingUtilities.convertPoint(jPanel, mouseEvent.getPoint(), TimeMeasure.this.lane1);
                if (TimeMeasure.this.lane1.contains(point)) {
                    TimeMeasure.this.lane1.setAnimal(this.clickedAnimal);
                } else {
                    Point point2 = SwingUtilities.convertPoint(jPanel, mouseEvent.getPoint(), TimeMeasure.this.lane2);
                    if (TimeMeasure.this.lane2.contains(point2)) {
                        TimeMeasure.this.lane2.setAnimal(this.clickedAnimal);
                    }
                }
            } else {
                jPanel.removeAll();
                jPanel.repaint();
            }
            TimeMeasure.this.reset();
            this.clickedAnimal = null;
            jPanel.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    class ObjectContainerMouseAdapter
    extends MouseAdapter {
        private Animal clickedAnimal;

        ObjectContainerMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JComponent jComponent = (JComponent)TimeMeasure.this.objectsP.getComponentAt(mouseEvent.getPoint());
            if (jComponent instanceof Animal) {
                TimeMeasure.this.singleTimer.stop();
                this.clickedAnimal = new Animal((Animal)jComponent);
                TimeMeasure.this.objectsP.setCursor(this.clickedAnimal.getCustomCursor());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.clickedAnimal == null) {
                return;
            }
            Point point = SwingUtilities.convertPoint(TimeMeasure.this.objectsP, mouseEvent.getPoint(), TimeMeasure.this);
            if (TimeMeasure.this.lane1.getBounds().contains(point)) {
                TimeMeasure.this.lane1.setAnimal(this.clickedAnimal);
            } else if (TimeMeasure.this.lane2.getBounds().contains(point)) {
                TimeMeasure.this.lane2.setAnimal(this.clickedAnimal);
            }
            TimeMeasure.this.reset();
            this.clickedAnimal = null;
            TimeMeasure.this.objectsP.setCursor(Cursor.getPredefinedCursor(12));
        }
    }
}

